/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.metrics.jersey.dwconfig;

import io.dropwizard.configuration.ConfigurationSourceProvider;
import io.dropwizard.configuration.FileConfigurationSourceProvider;
import io.dropwizard.configuration.ResourceConfigurationSourceProvider;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public class StargateV1ConfigurationSourceProvider
implements ConfigurationSourceProvider {
    public static final String SYSPROP_CONFIG_FILE_PREFIX = "stargate.configurationFile.";
    private final String moduleName;

    public StargateV1ConfigurationSourceProvider(String moduleName) {
        this.moduleName = Objects.requireNonNull(moduleName);
    }

    public InputStream open(String configName) throws IOException {
        String sysprop = SYSPROP_CONFIG_FILE_PREFIX + this.moduleName;
        String customConfigFile = System.getProperty(sysprop);
        if (customConfigFile != null) {
            this.log("Found configuration override System Property '%s'; will use config file '%s'", sysprop, customConfigFile);
            return new FileConfigurationSourceProvider().open(customConfigFile);
        }
        this.log("No value for configuration override System Property '%s'", sysprop, customConfigFile);
        File f = new File(configName).getAbsoluteFile();
        if (f.exists()) {
            this.log("Found configuration override file '%s', will use that", f);
            return new FileConfigurationSourceProvider().open(f.getPath());
        }
        this.log("No configuration override file '%s' found", f);
        this.log("No configuration overrides found, will use the default config resource '%s'", configName);
        InputStream in = new ResourceConfigurationSourceProvider().open(configName);
        return in == null ? new ByteArrayInputStream(new byte[0]) : in;
    }

    private void log(String format, Object ... args) {
        String message = String.format(format, args);
        message = String.format("INFO [StargateV1ConfigurationSourceProvider](module=%s): %s", this.moduleName, message);
        System.err.println(message);
    }
}

