/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.metrics.jersey.sgv2;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.jersey2.server.JerseyTagsProvider;
import java.util.Objects;
import java.util.Optional;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.monitoring.RequestEvent;

public class TenantIdFromHostHeaderTagsProvider
implements JerseyTagsProvider {
    private static final String DEFAULT_TENANT_TAG_KEY = "tenant";
    private final String tenantTagName;
    private final Tags tagsForUnknown;

    public TenantIdFromHostHeaderTagsProvider() {
        this(DEFAULT_TENANT_TAG_KEY);
    }

    public TenantIdFromHostHeaderTagsProvider(String tenantTagName) {
        this.tenantTagName = Objects.requireNonNull(tenantTagName);
        this.tagsForUnknown = Tags.of((String)tenantTagName, (String)"unknown");
    }

    public Iterable<Tag> httpRequestTags(RequestEvent event) {
        return this.extractTenantFromHost(event);
    }

    public Iterable<Tag> httpLongRequestTags(RequestEvent event) {
        return this.extractTenantFromHost(event);
    }

    protected Iterable<Tag> extractTenantFromHost(RequestEvent event) {
        ContainerRequest request = event.getContainerRequest();
        MultivaluedMap headers = request.getHeaders();
        String value = (String)headers.getFirst((Object)"Host");
        if (value == null) {
            value = (String)headers.getFirst((Object)"host");
        }
        return (Iterable)this.extractTenantId(value).map(t -> Tags.of((String)this.tenantTagName, (String)t)).orElse(this.tagsForUnknown);
    }

    protected Optional<String> extractTenantId(String host) {
        if (host == null || host.length() < 36) {
            return Optional.empty();
        }
        return Optional.of(host.substring(0, 36));
    }
}

