/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.metrics.jersey.tags;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.jersey2.server.JerseyTagsProvider;
import io.stargate.core.metrics.StargateMetricConstants;
import io.stargate.core.metrics.api.HttpMetricsTagProvider;
import java.util.Map;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.monitoring.RequestEvent;

public class HttpCounterTagsProvider
implements JerseyTagsProvider {
    private final HttpMetricsTagProvider httpMetricsTagProvider;

    public HttpCounterTagsProvider() {
        this(null);
    }

    public HttpCounterTagsProvider(HttpMetricsTagProvider httpMetricsTagProvider) {
        this.httpMetricsTagProvider = httpMetricsTagProvider;
    }

    public Iterable<Tag> httpRequestTags(RequestEvent event) {
        Tags result = Tags.of((Tag[])new Tag[]{this.getErrorTag(event)});
        if (null != this.httpMetricsTagProvider) {
            return result.and((Iterable)this.httpMetricsTagProvider.getRequestTags((Map)event.getContainerRequest().getHeaders()));
        }
        return result;
    }

    public Iterable<Tag> httpLongRequestTags(RequestEvent event) {
        if (null != this.httpMetricsTagProvider) {
            return this.httpMetricsTagProvider.getRequestTags((Map)event.getContainerRequest().getHeaders());
        }
        return Tags.empty();
    }

    private Tag getErrorTag(RequestEvent event) {
        boolean error;
        ContainerResponse response = event.getContainerResponse();
        boolean bl = error = response == null || response.getStatus() >= 500;
        if (error) {
            return StargateMetricConstants.TAG_ERROR_TRUE;
        }
        return StargateMetricConstants.TAG_ERROR_FALSE;
    }
}

