/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.metrics.jersey.tags;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.jersey2.server.JerseyTagsProvider;
import io.stargate.core.metrics.api.Metrics;
import java.util.Collection;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.glassfish.jersey.server.ExtendedUriInfo;
import org.glassfish.jersey.server.monitoring.RequestEvent;

public class NonApiModuleTagsProvider
implements JerseyTagsProvider {
    public static final String NON_API_MODULE_EXTENSION = "other";
    private final Tags tags;
    private final Collection<Pattern> uriPatterns;

    public NonApiModuleTagsProvider(Metrics metrics, String module, Collection<String> uriRegexes) {
        this.tags = metrics.tagsForModule(module + "-" + NON_API_MODULE_EXTENSION);
        this.uriPatterns = uriRegexes.stream().map(Pattern::compile).collect(Collectors.toList());
    }

    public Iterable<Tag> httpRequestTags(RequestEvent event) {
        return this.tagsInternal(event);
    }

    public Iterable<Tag> httpLongRequestTags(RequestEvent event) {
        return this.tagsInternal(event);
    }

    private Iterable<Tag> tagsInternal(RequestEvent event) {
        if (this.isNonApiRequest(event.getUriInfo())) {
            return this.tags;
        }
        return Tags.empty();
    }

    private boolean isNonApiRequest(ExtendedUriInfo uriInfo) {
        if (this.uriPatterns.isEmpty()) {
            return false;
        }
        String path = uriInfo.getAbsolutePath().getPath();
        return this.uriPatterns.stream().anyMatch(p -> p.matcher(path).matches());
    }
}

