/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.metrics.jersey.tags;

import io.micrometer.core.instrument.Tag;
import io.micrometer.jersey2.server.JerseyTagsProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.jersey.server.ExtendedUriInfo;
import org.glassfish.jersey.server.monitoring.RequestEvent;

public class PathParametersTagsProvider
implements JerseyTagsProvider {
    private final Config config;

    public PathParametersTagsProvider() {
        this(Config.fromSystemProps());
    }

    public PathParametersTagsProvider(Config config) {
        this.config = config;
    }

    public Iterable<Tag> httpRequestTags(RequestEvent event) {
        if (this.config.whitelistedPathParams.isEmpty()) {
            return Collections.emptyList();
        }
        return this.pathParamTags(event);
    }

    public Iterable<Tag> httpLongRequestTags(RequestEvent event) {
        if (this.config.whitelistedPathParams.isEmpty()) {
            return Collections.emptyList();
        }
        return this.pathParamTags(event);
    }

    private Iterable<Tag> pathParamTags(RequestEvent event) {
        ExtendedUriInfo uriInfo = event.getUriInfo();
        MultivaluedMap pathParameters = uriInfo.getPathParameters(true);
        return this.config.whitelistedPathParams.stream().map(param -> Optional.ofNullable(pathParameters.get(param)).map(values -> Tag.of((String)param, (String)String.join((CharSequence)",", values))).orElseGet(() -> Tag.of((String)param, (String)"unknown"))).collect(Collectors.toList());
    }

    public static class Config {
        private final Collection<String> whitelistedPathParams;

        public Config(Collection<String> whitelistedPathParams) {
            this.whitelistedPathParams = null == whitelistedPathParams ? Collections.emptyList() : whitelistedPathParams;
        }

        public static Config fromSystemProps() {
            String property = System.getProperty("stargate.metrics.http_server_requests_path_param_tags");
            return Config.fromPropertyValue(property);
        }

        public static Config fromPropertyValue(String value) {
            if (null == value || value.length() == 0) {
                return new Config(Collections.emptyList());
            }
            return new Config(Arrays.asList(value.split(",")));
        }
    }
}

