/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.adapter.source;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.ReferenceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.WildcardType;
import io.sundr.adapter.source.NodeToPackage;
import io.sundr.adapter.source.TypeToTypeRef;
import io.sundr.model.ClassRef;
import io.sundr.model.ClassRefBuilder;
import io.sundr.model.TypeParamRef;
import io.sundr.model.TypeParamRefBuilder;
import io.sundr.model.TypeRef;
import io.sundr.model.WildcardRef;
import io.sundr.model.WildcardRefBuilder;
import java.util.ArrayList;
import java.util.function.Function;

public class ClassOrInterfaceToTypeRef
implements Function<ClassOrInterfaceType, TypeRef> {
    private static final Function<Node, String> PACKAGENAME = new NodeToPackage();
    private final Function<Type, TypeRef> typeToTypeRef;

    public ClassOrInterfaceToTypeRef() {
        this.typeToTypeRef = new TypeToTypeRef(this);
    }

    public ClassOrInterfaceToTypeRef(Function<Type, TypeRef> typeToTypeRef) {
        this.typeToTypeRef = typeToTypeRef;
    }

    @Override
    public TypeRef apply(ClassOrInterfaceType classOrInterfaceType) {
        String boundPackage = PACKAGENAME.apply((Node)classOrInterfaceType);
        String boundName = classOrInterfaceType.getName();
        ArrayList<Object> arguments = new ArrayList<Object>();
        for (Type arg : classOrInterfaceType.getTypeArgs()) {
            TypeRef bound;
            if (arg instanceof ReferenceType) {
                ReferenceType referenceType = (ReferenceType)arg;
                Type type = referenceType.getType();
                int dimensions = referenceType.getArrayCount();
                if (type instanceof ClassOrInterfaceType) {
                    TypeRef intermediateRef = this.apply((ClassOrInterfaceType)type);
                    if (intermediateRef instanceof ClassRef) {
                        arguments.add(((ClassRefBuilder)new ClassRefBuilder((ClassRef)intermediateRef).withDimensions(dimensions)).build());
                        continue;
                    }
                    if (intermediateRef instanceof TypeParamRef) {
                        arguments.add(((TypeParamRefBuilder)new TypeParamRefBuilder((TypeParamRef)intermediateRef).withDimensions(dimensions)).build());
                        continue;
                    }
                    throw new IllegalStateException("Expected class or type param reference");
                }
                String name = referenceType.toString();
                arguments.add(((TypeParamRefBuilder)((TypeParamRefBuilder)new TypeParamRefBuilder().withName(name)).withDimensions(dimensions)).build());
                continue;
            }
            if (!(arg instanceof WildcardType)) continue;
            WildcardType wildcardType = (WildcardType)arg;
            if (wildcardType.getExtends() != null) {
                bound = this.typeToTypeRef.apply((Type)wildcardType.getExtends());
                arguments.add(((WildcardRefBuilder)new WildcardRefBuilder().addToBounds(new TypeRef[]{bound})).build());
                continue;
            }
            if (wildcardType.getSuper() != null) {
                bound = this.typeToTypeRef.apply((Type)wildcardType.getSuper());
                arguments.add(((WildcardRefBuilder)((WildcardRefBuilder)new WildcardRefBuilder().addToBounds(new TypeRef[]{bound})).withBoundKind(WildcardRef.BoundKind.SUPER)).build());
                continue;
            }
            arguments.add(new WildcardRef());
        }
        if (classOrInterfaceType.getParentNode() == classOrInterfaceType) {
            return ((TypeParamRefBuilder)new TypeParamRefBuilder().withName(boundName)).build();
        }
        String fqcn = boundPackage + "." + boundName;
        if (classOrInterfaceType.getTypeArgs().isEmpty() && boundName.length() == 1) {
            return ((TypeParamRefBuilder)new TypeParamRefBuilder().withName(boundName)).build();
        }
        return ((ClassRefBuilder)((ClassRefBuilder)new ClassRefBuilder().withFullyQualifiedName(fqcn)).withArguments(arguments)).build();
    }
}

