/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.adapter.source;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.NamedNode;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.QualifiedNameExpr;
import io.sundr.model.ClassRef;
import io.sundr.model.ClassRefBuilder;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;

public class NodeToImports
implements Function<Node, Set<ClassRef>> {
    private static final String SEPARATOR = ".";

    @Override
    public Set<ClassRef> apply(Node node) {
        LinkedHashSet<ClassRef> imports = new LinkedHashSet<ClassRef>();
        if (node instanceof NamedNode) {
            String name = ((NamedNode)node).getName();
            Node current = node;
            while (!(current instanceof CompilationUnit)) {
                current = current.getParentNode();
            }
            CompilationUnit compilationUnit = (CompilationUnit)current;
            for (ImportDeclaration importDecl : compilationUnit.getImports()) {
                String className = null;
                String packageName = null;
                NameExpr importExpr = importDecl.getName();
                if (importExpr instanceof QualifiedNameExpr) {
                    QualifiedNameExpr qualifiedNameExpr = (QualifiedNameExpr)importExpr;
                    className = qualifiedNameExpr.getName();
                    packageName = qualifiedNameExpr.getQualifier().toString();
                } else if (importDecl.getName().getName().endsWith(SEPARATOR + name)) {
                    String importName = importDecl.getName().getName();
                    packageName = importName.substring(0, importName.length() - name.length() - 1);
                }
                if (className == null || className.isEmpty()) continue;
                imports.add(((ClassRefBuilder)new ClassRefBuilder().withFullyQualifiedName(packageName + SEPARATOR + className)).build());
            }
        }
        return imports;
    }
}

