/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.adapter.source;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.NamedNode;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.QualifiedNameExpr;
import java.util.function.Function;

public class NodeToPackage
implements Function<Node, String> {
    private static final String JAVA_LANG = "java.lang";
    private static final String SEPARATOR = ".";

    @Override
    public String apply(Node node) {
        String name = null;
        if (node instanceof NamedNode) {
            name = ((NamedNode)node).getName();
        }
        if (node instanceof AnnotationExpr) {
            name = ((AnnotationExpr)node).getName().getName();
        }
        Node current = node;
        while (!(current instanceof CompilationUnit)) {
            current = current.getParentNode();
        }
        CompilationUnit compilationUnit = (CompilationUnit)current;
        for (ImportDeclaration importDecl : compilationUnit.getImports()) {
            NameExpr importExpr = importDecl.getName();
            if (importExpr instanceof QualifiedNameExpr) {
                QualifiedNameExpr qualifiedNameExpr = (QualifiedNameExpr)importExpr;
                String className = qualifiedNameExpr.getName();
                if (!name.equals(className)) continue;
                return qualifiedNameExpr.getQualifier().toString();
            }
            if (!importDecl.getName().getName().endsWith(SEPARATOR + name)) continue;
            String importName = importDecl.getName().getName();
            return importName.substring(0, importName.length() - name.length() - 1);
        }
        try {
            Class.forName("java.lang." + name);
            return JAVA_LANG;
        }
        catch (ClassNotFoundException ex) {
            return compilationUnit.getPackage().getPackageName();
        }
    }
}

