/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.adapter.source;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.TypeParameter;
import com.github.javaparser.ast.body.AnnotationDeclaration;
import com.github.javaparser.ast.body.AnnotationMemberDeclaration;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.EnumConstantDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.ReferenceType;
import com.github.javaparser.ast.type.Type;
import io.sundr.adapter.api.AdapterContext;
import io.sundr.adapter.source.AnnotationExprToAnnotationRef;
import io.sundr.adapter.source.BlockStmtToBlock;
import io.sundr.adapter.source.ClassOrInterfaceToTypeRef;
import io.sundr.adapter.source.NodeToImports;
import io.sundr.adapter.source.NodeToPackage;
import io.sundr.adapter.source.TypeParameterToTypeParamDef;
import io.sundr.adapter.source.TypeToTypeRef;
import io.sundr.builder.Visitor;
import io.sundr.model.AnnotationRef;
import io.sundr.model.AttributeKey;
import io.sundr.model.Attributeable;
import io.sundr.model.Block;
import io.sundr.model.ClassRef;
import io.sundr.model.Kind;
import io.sundr.model.Method;
import io.sundr.model.MethodBuilder;
import io.sundr.model.Modifiers;
import io.sundr.model.Property;
import io.sundr.model.PropertyBuilder;
import io.sundr.model.TypeDef;
import io.sundr.model.TypeDefBuilder;
import io.sundr.model.TypeParamDef;
import io.sundr.model.TypeRef;
import io.sundr.model.utils.Types;
import io.sundr.model.visitors.context.resolver.TypeDefContextRefResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

public class TypeDeclarationToTypeDef
implements Function<TypeDeclaration, TypeDef> {
    private static final Function<Node, String> PACKAGENAME = new NodeToPackage();
    private static final Function<Node, Set<ClassRef>> IMPORTS = new NodeToImports();
    private static final Function<AnnotationExpr, AnnotationRef> ANNOTATIONREF = new AnnotationExprToAnnotationRef();
    private static final Function<BlockStmt, Block> BLOCK = new BlockStmtToBlock();
    private final AdapterContext context;
    private final Function<TypeParameter, TypeParamDef> typeParameterToTypeParamDef;
    private final Function<ClassOrInterfaceType, TypeRef> classOrInterfaceToTypeRef;
    private final Function<Type, TypeRef> typeToTypeRef;

    public TypeDeclarationToTypeDef(AdapterContext context) {
        this.context = context;
        this.classOrInterfaceToTypeRef = new ClassOrInterfaceToTypeRef();
        this.typeToTypeRef = new TypeToTypeRef(this.classOrInterfaceToTypeRef);
        this.typeParameterToTypeParamDef = new TypeParameterToTypeParamDef(this.classOrInterfaceToTypeRef);
    }

    @Override
    public TypeDef apply(TypeDeclaration type) {
        if (type instanceof ClassOrInterfaceDeclaration) {
            ClassOrInterfaceDeclaration decl = (ClassOrInterfaceDeclaration)type;
            Kind kind = decl.isInterface() ? Kind.INTERFACE : Kind.CLASS;
            ArrayList<TypeParamDef> parameters = new ArrayList<TypeParamDef>();
            ArrayList<ClassRef> extendsList = new ArrayList<ClassRef>();
            ArrayList<ClassRef> implementsList = new ArrayList<ClassRef>();
            ArrayList<Property> properties = new ArrayList<Property>();
            ArrayList<Method> methods = new ArrayList<Method>();
            ArrayList<Method> constructors = new ArrayList<Method>();
            ArrayList<AnnotationRef> annotations = new ArrayList<AnnotationRef>();
            for (AnnotationExpr annotationExpr : decl.getAnnotations()) {
                annotations.add(ANNOTATIONREF.apply(annotationExpr));
            }
            for (TypeParameter typeParameter : decl.getTypeParameters()) {
                parameters.add(this.typeParameterToTypeParamDef.apply(typeParameter));
            }
            for (ClassOrInterfaceType classOrInterfaceType : decl.getExtends()) {
                extendsList.add((ClassRef)this.classOrInterfaceToTypeRef.apply(classOrInterfaceType));
            }
            for (ClassOrInterfaceType classOrInterfaceType : decl.getImplements()) {
                implementsList.add((ClassRef)this.classOrInterfaceToTypeRef.apply(classOrInterfaceType));
            }
            for (BodyDeclaration bodyDeclaration : decl.getMembers()) {
                TypeRef typeRef;
                Boolean preferVarArg;
                ArrayList<ClassRef> exceptions;
                ArrayList<Property> arguments;
                if (bodyDeclaration instanceof FieldDeclaration) {
                    FieldDeclaration fieldDeclaration = (FieldDeclaration)bodyDeclaration;
                    for (VariableDeclarator var : fieldDeclaration.getVariables()) {
                        TypeRef fieldDeclRef = this.typeToTypeRef.apply(fieldDeclaration.getType());
                        TypeRef typeRef2 = this.checkAgainstTypeParamRef(fieldDeclRef, parameters);
                        ArrayList<AnnotationRef> fieldAnnotations = new ArrayList<AnnotationRef>();
                        for (AnnotationExpr annotationExpressions : fieldDeclaration.getAnnotations()) {
                            fieldAnnotations.add(ANNOTATIONREF.apply(annotationExpressions));
                        }
                        properties.add(((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)new PropertyBuilder().withName(var.getId().getName())).withTypeRef(typeRef2)).withAnnotations(fieldAnnotations)).withModifiers(Modifiers.from((int)fieldDeclaration.getModifiers()))).addToAttributes(Attributeable.INIT, var.getInit() != null ? var.getInit().toStringWithoutComments() : null)).build());
                    }
                    continue;
                }
                if (bodyDeclaration instanceof MethodDeclaration) {
                    Object referenceType2;
                    MethodDeclaration methodDeclaration = (MethodDeclaration)bodyDeclaration;
                    arguments = new ArrayList<Property>();
                    exceptions = new ArrayList<ClassRef>();
                    ArrayList<AnnotationRef> methodAnnotations = new ArrayList<AnnotationRef>();
                    for (AnnotationExpr annotationExpr : methodDeclaration.getAnnotations()) {
                        methodAnnotations.add(ANNOTATIONREF.apply(annotationExpr));
                    }
                    for (Object referenceType2 : methodDeclaration.getThrows()) {
                        TypeRef exceptionRef = this.typeToTypeRef.apply(referenceType2.getType());
                        if (!(exceptionRef instanceof ClassRef)) continue;
                        exceptions.add((ClassRef)exceptionRef);
                    }
                    preferVarArg = false;
                    referenceType2 = methodDeclaration.getParameters().iterator();
                    while (referenceType2.hasNext()) {
                        Object parameter = (Parameter)referenceType2.next();
                        ArrayList<AnnotationRef> paramAnnotations = new ArrayList<AnnotationRef>();
                        for (AnnotationExpr annotationExpr : parameter.getAnnotations()) {
                            paramAnnotations.add(ANNOTATIONREF.apply(annotationExpr));
                        }
                        typeRef = this.typeToTypeRef.apply(parameter.getType());
                        if (parameter.isVarArgs()) {
                            preferVarArg = true;
                            typeRef = typeRef.withDimensions(typeRef.getDimensions() + 1);
                        }
                        arguments.add(((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)new PropertyBuilder().withName(parameter.getId().getName())).withTypeRef(typeRef)).withModifiers(Modifiers.from((int)parameter.getModifiers()))).withAnnotations(paramAnnotations)).build());
                    }
                    ArrayList typeParamDefs = new ArrayList();
                    for (TypeParameter typeParameter : methodDeclaration.getTypeParameters()) {
                        typeParamDefs.add(this.typeParameterToTypeParamDef.apply(typeParameter));
                    }
                    TypeRef returnType = this.checkAgainstTypeParamRef(this.typeToTypeRef.apply(methodDeclaration.getType()), parameters);
                    methods.add(((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withName(methodDeclaration.getName())).withDefaultMethod(methodDeclaration.isDefault())).withModifiers(Modifiers.from((int)methodDeclaration.getModifiers()))).withParameters((List)typeParamDefs)).withVarArgPreferred(preferVarArg.booleanValue())).withReturnType(returnType)).withExceptions(exceptions)).withArguments(arguments)).withAnnotations(methodAnnotations)).withBlock(BLOCK.apply(methodDeclaration.getBody()))).build());
                    continue;
                }
                if (!(bodyDeclaration instanceof ConstructorDeclaration)) continue;
                ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)bodyDeclaration;
                arguments = new ArrayList();
                exceptions = new ArrayList();
                ArrayList<AnnotationRef> ctorAnnotations = new ArrayList<AnnotationRef>();
                preferVarArg = false;
                for (AnnotationExpr annotationExpr : constructorDeclaration.getAnnotations()) {
                    ctorAnnotations.add(ANNOTATIONREF.apply(annotationExpr));
                }
                for (ReferenceType referenceType : constructorDeclaration.getThrows()) {
                    TypeRef exceptionRef = this.typeToTypeRef.apply(referenceType.getType());
                    exceptions.add((ClassRef)exceptionRef);
                }
                for (Object parameter : constructorDeclaration.getParameters()) {
                    ArrayList<AnnotationRef> ctorParamAnnotations = new ArrayList<AnnotationRef>();
                    for (AnnotationExpr annotationExpr : parameter.getAnnotations()) {
                        ctorParamAnnotations.add(ANNOTATIONREF.apply(annotationExpr));
                    }
                    typeRef = this.checkAgainstTypeParamRef(this.typeToTypeRef.apply(parameter.getType()), parameters);
                    if (parameter.isVarArgs()) {
                        preferVarArg = true;
                        typeRef = typeRef.withDimensions(typeRef.getDimensions() + 1);
                    }
                    arguments.add(((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)new PropertyBuilder().withName(parameter.getId().getName())).withTypeRef(typeRef)).withModifiers(Modifiers.from((int)parameter.getModifiers()))).withAnnotations(ctorParamAnnotations)).build());
                }
                constructors.add(((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withModifiers(Modifiers.from((int)constructorDeclaration.getModifiers()))).withVarArgPreferred(preferVarArg.booleanValue())).withExceptions(exceptions)).withArguments(arguments)).withAnnotations(ctorAnnotations)).withBlock(BLOCK.apply(constructorDeclaration.getBlock()))).build());
            }
            return this.context.getDefinitionRepository().register(((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)new TypeDefBuilder().withKind(kind)).withPackageName(PACKAGENAME.apply((Node)type))).withName(decl.getName())).withModifiers(Modifiers.from((int)type.getModifiers()))).withParameters(parameters)).withExtendsList(extendsList)).withImplementsList(implementsList)).withProperties(properties)).withMethods(methods)).withConstructors(constructors)).withAnnotations(annotations)).addToAttributes(TypeDef.ALSO_IMPORT, IMPORTS.apply((Node)type))).accept(new Visitor[]{new TypeDefContextRefResolver()})).build());
        }
        if (type instanceof AnnotationDeclaration) {
            AnnotationDeclaration decl = (AnnotationDeclaration)type;
            Kind kind = Kind.ANNOTATION;
            ArrayList<Method> methods = new ArrayList<Method>();
            for (Object bodyDeclaration : decl.getMembers()) {
                if (!(bodyDeclaration instanceof AnnotationMemberDeclaration)) continue;
                HashMap<AttributeKey, String> attributes = new HashMap<AttributeKey, String>();
                AnnotationMemberDeclaration annotationMemberDeclaration = (AnnotationMemberDeclaration)bodyDeclaration;
                if (annotationMemberDeclaration.getDefaultValue() != null) {
                    attributes.put(Attributeable.DEFAULT_VALUE, annotationMemberDeclaration.getDefaultValue().toString());
                }
                TypeRef returnType = this.typeToTypeRef.apply(annotationMemberDeclaration.getType());
                methods.add(((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withName(annotationMemberDeclaration.getName())).withModifiers(Modifiers.from((int)annotationMemberDeclaration.getModifiers()))).withReturnType(returnType)).withAttributes(attributes)).build());
            }
            ArrayList<AnnotationRef> annotations = new ArrayList<AnnotationRef>();
            for (AnnotationExpr annotationExpr : decl.getAnnotations()) {
                annotations.add(ANNOTATIONREF.apply(annotationExpr));
            }
            return this.context.getDefinitionRepository().register(((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)new TypeDefBuilder().withKind(kind)).withPackageName(PACKAGENAME.apply((Node)type))).withName(decl.getName())).withModifiers(Modifiers.from((int)type.getModifiers()))).withMethods(methods)).withAnnotations(annotations)).addToAttributes(TypeDef.ALSO_IMPORT, IMPORTS.apply((Node)type))).accept(new Visitor[]{new TypeDefContextRefResolver()})).build());
        }
        if (type instanceof EnumDeclaration) {
            EnumDeclaration decl = (EnumDeclaration)type;
            Kind kind = Kind.ENUM;
            ArrayList<TypeParamDef> parameters = new ArrayList<TypeParamDef>();
            ArrayList<ClassRef> implementsList = new ArrayList<ClassRef>();
            ArrayList<Property> properties = new ArrayList<Property>();
            ArrayList<Method> methods = new ArrayList<Method>();
            ArrayList constructors = new ArrayList();
            ArrayList<AnnotationRef> annotations = new ArrayList<AnnotationRef>();
            for (AnnotationExpr annotationExpr : decl.getAnnotations()) {
                annotations.add(ANNOTATIONREF.apply(annotationExpr));
            }
            for (ClassOrInterfaceType classOrInterfaceType : decl.getImplements()) {
                implementsList.add((ClassRef)this.classOrInterfaceToTypeRef.apply(classOrInterfaceType));
            }
            for (EnumConstantDeclaration enumConstant : decl.getEntries()) {
                ArrayList<AnnotationRef> enumAnnotations = new ArrayList<AnnotationRef>();
                for (AnnotationExpr annotationExpr : enumConstant.getAnnotations()) {
                    enumAnnotations.add(ANNOTATIONREF.apply(annotationExpr));
                }
                String enumTypeName = PACKAGENAME.apply((Node)type) + "." + decl.getName();
                ClassRef enumType = new ClassRef(enumTypeName, 0, new ArrayList(), new HashMap());
                properties.add(((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)new PropertyBuilder().withName(enumConstant.getName())).withTypeRef((TypeRef)enumType)).withAnnotations(enumAnnotations)).build());
            }
            for (BodyDeclaration bodyDeclaration : decl.getMembers()) {
                Object referenceType3;
                if (bodyDeclaration instanceof FieldDeclaration) {
                    FieldDeclaration fieldDeclaration = (FieldDeclaration)bodyDeclaration;
                    for (VariableDeclarator var : fieldDeclaration.getVariables()) {
                        TypeRef fieldDeclRef = this.typeToTypeRef.apply(fieldDeclaration.getType());
                        TypeRef typeRef = this.checkAgainstTypeParamRef(fieldDeclRef, parameters);
                        ArrayList<AnnotationRef> fieldAnnotations = new ArrayList<AnnotationRef>();
                        for (AnnotationExpr annotationExpressions : fieldDeclaration.getAnnotations()) {
                            fieldAnnotations.add(ANNOTATIONREF.apply(annotationExpressions));
                        }
                        properties.add(((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)new PropertyBuilder().withName(var.getId().getName())).withTypeRef(typeRef)).withAnnotations(fieldAnnotations)).withModifiers(Modifiers.from((int)fieldDeclaration.getModifiers()))).build());
                    }
                    continue;
                }
                if (!(bodyDeclaration instanceof MethodDeclaration)) continue;
                MethodDeclaration methodDeclaration = (MethodDeclaration)bodyDeclaration;
                ArrayList<Property> arguments = new ArrayList<Property>();
                ArrayList<ClassRef> exceptions = new ArrayList<ClassRef>();
                ArrayList<AnnotationRef> methodAnnotations = new ArrayList<AnnotationRef>();
                for (AnnotationExpr annotationExpr : methodDeclaration.getAnnotations()) {
                    methodAnnotations.add(ANNOTATIONREF.apply(annotationExpr));
                }
                for (Object referenceType3 : methodDeclaration.getThrows()) {
                    TypeRef exceptionRef = this.typeToTypeRef.apply(referenceType3.getType());
                    if (!(exceptionRef instanceof ClassRef)) continue;
                    exceptions.add((ClassRef)exceptionRef);
                }
                Boolean preferVarArg = false;
                referenceType3 = methodDeclaration.getParameters().iterator();
                while (referenceType3.hasNext()) {
                    Parameter parameter = (Parameter)referenceType3.next();
                    ArrayList<AnnotationRef> paramAnnotations = new ArrayList<AnnotationRef>();
                    for (AnnotationExpr annotationExpr : parameter.getAnnotations()) {
                        paramAnnotations.add(ANNOTATIONREF.apply(annotationExpr));
                    }
                    TypeRef typeRef = this.typeToTypeRef.apply(parameter.getType());
                    if (parameter.isVarArgs()) {
                        preferVarArg = true;
                        typeRef = typeRef.withDimensions(typeRef.getDimensions() + 1);
                    }
                    arguments.add(((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)new PropertyBuilder().withName(parameter.getId().getName())).withTypeRef(typeRef)).withModifiers(Modifiers.from((int)parameter.getModifiers()))).withAnnotations(paramAnnotations)).build());
                }
                ArrayList<TypeParamDef> typeParamDefs = new ArrayList<TypeParamDef>();
                for (TypeParameter typeParameter : methodDeclaration.getTypeParameters()) {
                    typeParamDefs.add(this.typeParameterToTypeParamDef.apply(typeParameter));
                }
                TypeRef returnType = this.checkAgainstTypeParamRef(this.typeToTypeRef.apply(methodDeclaration.getType()), parameters);
                methods.add(((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withName(methodDeclaration.getName())).withDefaultMethod(methodDeclaration.isDefault())).withModifiers(Modifiers.from((int)methodDeclaration.getModifiers()))).withParameters(typeParamDefs)).withVarArgPreferred(preferVarArg.booleanValue())).withReturnType(returnType)).withExceptions(exceptions)).withArguments(arguments)).withAnnotations(methodAnnotations)).build());
            }
            return this.context.getDefinitionRepository().register(((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)new TypeDefBuilder().withKind(kind)).withPackageName(PACKAGENAME.apply((Node)type))).withName(decl.getName())).withModifiers(Modifiers.from((int)type.getModifiers()))).withParameters(parameters)).withImplementsList(implementsList)).withProperties(properties)).withMethods(methods)).withConstructors(constructors)).withAnnotations(annotations)).addToAttributes(TypeDef.ALSO_IMPORT, IMPORTS.apply((Node)type))).accept(new Visitor[]{new TypeDefContextRefResolver()})).build());
        }
        throw new IllegalArgumentException("Unsupported TypeDeclaration:[" + String.valueOf(type) + "].");
    }

    private TypeRef checkAgainstTypeParamRef(TypeRef typeRef, Collection<TypeParamDef> parameters) {
        TypeParamDef parameterDef = Types.getParameterDefinition((TypeRef)typeRef, parameters);
        if (parameterDef != null) {
            return parameterDef.toReference();
        }
        return typeRef;
    }
}

