/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.adapter.source.analysis;

import io.sundr.adapter.source.Project;
import io.sundr.adapter.source.analysis.ImpactAnalysisResult;
import io.sundr.adapter.source.change.Change;
import io.sundr.adapter.source.change.ChangeSet;
import io.sundr.builder.Visitor;
import io.sundr.model.Expression;
import io.sundr.model.Method;
import io.sundr.model.MethodBuilder;
import io.sundr.model.Property;
import io.sundr.model.PropertyRefFluent;
import io.sundr.model.Super;
import io.sundr.model.This;
import io.sundr.model.TypeDef;
import io.sundr.model.repo.DefinitionRepository;
import io.sundr.model.repo.MethodReference;
import io.sundr.utils.Dependencies;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class ImpactAnalyzer {
    private final Project project;
    private final DefinitionRepository repository;

    public ImpactAnalyzer(Project project) {
        this.project = project;
        this.repository = DefinitionRepository.getRepository();
    }

    public ImpactAnalyzer(Project project, DefinitionRepository repository) {
        this.project = project;
        this.repository = repository;
    }

    public ImpactAnalysisResult analyze(ChangeSet changeSet) {
        TypeDef changedTypeDef;
        if (changeSet == null || !changeSet.hasChanges()) {
            return new ImpactAnalysisResult(Set.of(), Set.of(), (Dependencies.DependencyTree<MethodReference>)Dependencies.newTree());
        }
        HashSet<Path> affectedFiles = new HashSet<Path>();
        HashSet<TypeDef> affectedTypeDefs = new HashSet<TypeDef>();
        Dependencies.DependencyTree dependencyTree = Dependencies.newTree(methodRef -> methodRef.getOwningType().getName() + "." + methodRef.getMethod().getName());
        TypeDef typeDef = changedTypeDef = changeSet.getNewTypeDef() != null ? changeSet.getNewTypeDef() : changeSet.getOldTypeDef();
        if (changedTypeDef != null) {
            affectedTypeDefs.add(changedTypeDef);
        }
        this.analyzeMethodChangesWithDependencyTree(changeSet, (Dependencies.DependencyTree<MethodReference>)dependencyTree);
        Set<MethodReference> propertyImpacts = this.analyzePropertyChanges(changeSet);
        for (MethodReference propertyImpact : propertyImpacts) {
            dependencyTree.addDependency((Object)propertyImpact, (Object[])new MethodReference[0]);
        }
        for (MethodReference methodRef2 : dependencyTree.getAllNodes()) {
            affectedTypeDefs.add(methodRef2.getOwningType());
        }
        for (TypeDef typeDef2 : affectedTypeDefs) {
            this.findFileForTypeDef(typeDef2).ifPresent(affectedFiles::add);
        }
        return new ImpactAnalysisResult(affectedFiles, affectedTypeDefs, (Dependencies.DependencyTree<MethodReference>)dependencyTree);
    }

    private void analyzeMethodChangesWithDependencyTree(ChangeSet changeSet, Dependencies.DependencyTree<MethodReference> dependencyTree) {
        for (Change<Method> methodChange : changeSet.getMethodChanges()) {
            TypeDef owningType;
            Method changedMethod = methodChange.getElement();
            TypeDef typeDef = owningType = changeSet.getNewTypeDef() != null ? changeSet.getNewTypeDef() : changeSet.getOldTypeDef();
            if (changedMethod == null || owningType == null) continue;
            Method repositoryMethod = this.findMethodInRepository(changedMethod, owningType);
            if (repositoryMethod == null) {
                repositoryMethod = changedMethod;
            }
            MethodReference rootMethodRef = new MethodReference(repositoryMethod, owningType);
            dependencyTree.addDependency((Object)rootMethodRef, (Object[])new MethodReference[0]);
            this.buildTransitiveDependencyTree(rootMethodRef, dependencyTree, new HashSet<MethodReference>());
        }
    }

    private Set<MethodReference> analyzeMethodChanges(ChangeSet changeSet) {
        Dependencies.DependencyTree tempTree = Dependencies.newTree();
        this.analyzeMethodChangesWithDependencyTree(changeSet, (Dependencies.DependencyTree<MethodReference>)tempTree);
        return tempTree.getAllNodes();
    }

    private Set<MethodReference> analyzePropertyChanges(ChangeSet changeSet) {
        HashSet<MethodReference> affectedMethodReferences = new HashSet<MethodReference>();
        for (Change<Property> propertyChange : changeSet.getPropertyChanges()) {
            Property changedProperty = propertyChange.getElement();
            if (changedProperty == null) continue;
            Set<MethodReference> propertyAccessors = this.findMethodsAccessingProperty(changedProperty);
            affectedMethodReferences.addAll(propertyAccessors);
        }
        return affectedMethodReferences;
    }

    private Set<MethodReference> findMethodReferencesToMethod(MethodReference targetMethod) {
        Set callers = MethodReference.getDirectMethodCallers((MethodReference)targetMethod, (DefinitionRepository)this.repository);
        return callers;
    }

    private void buildTransitiveDependencyTree(MethodReference target, Dependencies.DependencyTree<MethodReference> dependencyTree, Set<MethodReference> visited) {
        if (visited.contains(target)) {
            return;
        }
        visited.add(target);
        Set directCallers = MethodReference.getDirectMethodCallers((MethodReference)target, (DefinitionRepository)this.repository);
        for (MethodReference caller : directCallers) {
            dependencyTree.addDependency((Object)target, (Object[])new MethodReference[]{caller});
            this.buildTransitiveDependencyTree(caller, dependencyTree, visited);
        }
    }

    private Set<MethodReference> findMethodReferencesFromMethod(Method method) {
        try {
            return MethodReference.getMethodReferences((Method)method, (DefinitionRepository)this.repository);
        }
        catch (Exception e) {
            return Set.of();
        }
    }

    private Set<MethodReference> findMethodsAccessingProperty(Property property) {
        HashSet<MethodReference> accessors = new HashSet<MethodReference>();
        String propertyName = property.getName();
        for (TypeDef typeDef : this.repository.getDefinitions()) {
            for (Method method : typeDef.getMethods()) {
                if (!this.methodAccessesProperty(method, propertyName)) continue;
                MethodReference methodRef = new MethodReference(method, typeDef);
                accessors.add(methodRef);
            }
        }
        return accessors;
    }

    private boolean methodAccessesProperty(Method method, String propertyName) {
        if (method.getBlock() == null) {
            return false;
        }
        PropertyAccessVisitor visitor = new PropertyAccessVisitor(propertyName);
        MethodBuilder methodBuilder = new MethodBuilder(method);
        methodBuilder.accept(new Visitor[]{visitor});
        return visitor.foundPropertyAccess();
    }

    private Optional<Path> findFileForTypeDef(TypeDef typeDef) {
        if (typeDef == null) {
            return Optional.empty();
        }
        String fqcn = typeDef.getFullyQualifiedName();
        Optional<Path> sourceFile = this.project.findJavaSourceFile(fqcn);
        if (sourceFile.isPresent()) {
            return sourceFile;
        }
        return this.project.findJavaTestFile(fqcn);
    }

    private Method findMethodInRepository(Method targetMethod, TypeDef owningType) {
        TypeDef repositoryType = this.repository.getDefinition(owningType.getFullyQualifiedName());
        if (repositoryType == null) {
            return null;
        }
        String targetErasure = targetMethod.getErasure();
        for (Method method : repositoryType.getMethods()) {
            if (!targetErasure.equals(method.getErasure())) continue;
            return method;
        }
        return null;
    }

    private String capitalize(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    private static class PropertyAccessVisitor
    implements Visitor<PropertyRefFluent<?>> {
        private final String targetPropertyName;
        private boolean foundAccess = false;

        public PropertyAccessVisitor(String targetPropertyName) {
            this.targetPropertyName = targetPropertyName;
        }

        public void visit(PropertyRefFluent<?> propertyRefFluent) {
            Expression scope;
            if (propertyRefFluent.hasProperty() && this.targetPropertyName.equals(propertyRefFluent.buildProperty().getName()) && propertyRefFluent.hasScope() && ((scope = propertyRefFluent.buildScope()) instanceof This || scope instanceof Super)) {
                this.foundAccess = true;
            }
        }

        public boolean foundPropertyAccess() {
            return this.foundAccess;
        }
    }
}

