/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.ClassRef;
import io.sundr.model.Expression;
import io.sundr.model.ExpressionOrStatement;
import io.sundr.model.ValueRef;
import java.util.HashSet;
import java.util.Set;

public class Assign
implements ExpressionOrStatement {
    private final Expression target;
    private final Expression value;

    public Assign(Expression target, Expression value) {
        this.target = target;
        this.value = value;
    }

    public Expression getTarget() {
        return this.target;
    }

    public Expression getValue() {
        return this.value;
    }

    @Override
    public Set<ClassRef> getReferences() {
        HashSet<ClassRef> refs = new HashSet<ClassRef>();
        if (this.target != null) {
            refs.addAll(this.target.getReferences());
        }
        if (this.value != null) {
            refs.addAll(this.value.getReferences());
        }
        return refs;
    }

    @Override
    public String render() {
        return this.target.renderExpression() + " = " + this.value.renderExpression();
    }

    public static DslToStep to(Expression target) {
        return new DslToStep(target);
    }

    public static class DslToStep {
        private final Expression target;

        public DslToStep(Expression target) {
            this.target = target;
        }

        public Assign value(Object value, Object ... more) {
            return new Assign(this.target, ValueRef.from(value, more));
        }
    }
}

