/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.Assign;
import io.sundr.model.Cast;
import io.sundr.model.ClassRef;
import io.sundr.model.Construct;
import io.sundr.model.Divide;
import io.sundr.model.Enclosed;
import io.sundr.model.Equals;
import io.sundr.model.Index;
import io.sundr.model.InstanceOf;
import io.sundr.model.Lambda;
import io.sundr.model.LogicalAnd;
import io.sundr.model.LogicalOr;
import io.sundr.model.Method;
import io.sundr.model.MethodCall;
import io.sundr.model.Minus;
import io.sundr.model.Modulo;
import io.sundr.model.Multiply;
import io.sundr.model.Negative;
import io.sundr.model.NewArray;
import io.sundr.model.Not;
import io.sundr.model.NotEquals;
import io.sundr.model.Plus;
import io.sundr.model.Positive;
import io.sundr.model.PostDecrement;
import io.sundr.model.PostIncrement;
import io.sundr.model.PreDecrement;
import io.sundr.model.PreIncrement;
import io.sundr.model.Property;
import io.sundr.model.PropertyRef;
import io.sundr.model.Renderable;
import io.sundr.model.Statement;
import io.sundr.model.Ternary;
import io.sundr.model.TypeDef;
import io.sundr.model.TypeRef;
import io.sundr.model.ValueRef;
import io.sundr.model.WithReferences;
import java.util.function.Function;

public interface Expression
extends Renderable,
WithReferences {
    public static final Expression NULL = new ValueRef(null);

    default public String renderExpression() {
        return this.render();
    }

    public static Expression not(Expression expression) {
        return new Not(expression);
    }

    default public Expression not() {
        return new Not(this);
    }

    public static Expression and(Expression left, Expression right) {
        return new LogicalAnd(left, right);
    }

    default public Expression and(Expression expression) {
        return Expression.and(this, expression);
    }

    default public Expression and(Function<Expression, Expression> function) {
        return Expression.and(this, function.apply(this));
    }

    public static Expression or(Expression left, Expression right) {
        return new LogicalOr(left, right);
    }

    default public Expression or(Expression expression) {
        return Expression.or(this, expression);
    }

    default public Expression or(Function<Expression, Expression> function) {
        return Expression.or(this, function.apply(this));
    }

    public static Expression enclosed(Expression expression) {
        return new Enclosed(expression);
    }

    default public Expression enclosed() {
        return new Enclosed(this);
    }

    public static Expression positive(Expression expression) {
        return new Positive(expression);
    }

    default public Expression positive() {
        return new Positive(this);
    }

    public static Expression negative(Expression expression) {
        return new Negative(expression);
    }

    default public Expression negative() {
        return new Negative(this);
    }

    public static Expression cast(TypeRef type, Expression expression) {
        return new Cast(type, expression);
    }

    default public Expression cast(TypeRef type) {
        return new Cast(type, this);
    }

    public static Expression cast(Class type, Expression expression) {
        return Expression.cast(ClassRef.forClass(type), expression);
    }

    default public Expression cast(Class type) {
        return this.cast(ClassRef.forClass(type));
    }

    public static Expression eq(Expression left, Expression right) {
        return new Equals(left, right);
    }

    default public Expression eq(Expression expression) {
        return new Equals(this, expression);
    }

    public static Expression ne(Expression left, Expression right) {
        return new NotEquals(left, right);
    }

    default public Expression ne(Expression expression) {
        return new NotEquals(this, expression);
    }

    public static Expression notNull(Expression expression) {
        return new NotEquals(expression, ValueRef.from(null));
    }

    default public Expression notNull() {
        return Expression.notNull(this);
    }

    public static Expression isNull(Expression expression) {
        return new Equals(expression, ValueRef.from(null));
    }

    default public Expression isNull() {
        return Expression.isNull(this);
    }

    default public Expression instanceOf(ClassRef classRef) {
        return new InstanceOf(this, classRef);
    }

    default public Expression instanceOf(Class c) {
        return new InstanceOf(this, c);
    }

    public static Expression plus(Expression left, Expression right) {
        return new Plus(left, right);
    }

    default public Expression plus(Expression expression) {
        return new Plus(this, expression);
    }

    default public Expression plus(Number number) {
        return new Plus((Object)this, number);
    }

    public static Expression minus(Expression left, Expression right) {
        return new Minus(left, right);
    }

    default public Expression minus(Expression expression) {
        return new Minus(this, expression);
    }

    default public Expression minus(Number number) {
        return new Minus((Object)this, number);
    }

    public static Expression multiply(Expression left, Expression right) {
        return new Multiply(left, right);
    }

    default public Expression multiply(Expression expression) {
        return new Multiply(this, expression);
    }

    public static Expression divide(Expression left, Expression right) {
        return new Divide(left, right);
    }

    default public Expression divide(Expression expression) {
        return new Divide(this, expression);
    }

    public static Expression modulo(Expression left, Expression right) {
        return new Modulo(left, right);
    }

    default public Expression modulo(Expression expression) {
        return new Modulo(this, expression);
    }

    default public Expression property(String name) {
        return new PropertyRef(name, this);
    }

    default public Expression property(TypeRef type, String name) {
        return new PropertyRef(type, name, this);
    }

    default public Expression property(Property property) {
        return new PropertyRef(property, this);
    }

    public static MethodCall call(Class type, String name, Expression ... expression) {
        return new MethodCall(name, type, expression);
    }

    public static MethodCall call(TypeRef type, String name, Expression ... expression) {
        return new MethodCall(name, type, expression);
    }

    public static MethodCall call(TypeDef type, String name, Expression ... expression) {
        return new MethodCall(name, type, expression);
    }

    public static MethodCall newCall(String name, Expression ... expression) {
        return new MethodCall(name, (Expression)null, expression);
    }

    default public MethodCall call(String name, Expression ... expression) {
        return new MethodCall(name, this, expression);
    }

    default public MethodCall call(Method method, Expression ... expression) {
        return new MethodCall(method.getName(), this, expression);
    }

    default public Index index(Expression expression) {
        return new Index(this, expression);
    }

    default public Index index(int index) {
        return new Index(this, ValueRef.from(index, new Integer[0]));
    }

    default public Expression postIncrement() {
        return new PostIncrement(this);
    }

    default public Expression postDecrement() {
        return new PostDecrement(this);
    }

    default public Expression preIncrement() {
        return new PreIncrement(this);
    }

    default public Expression pretDecrement() {
        return new PreDecrement(this);
    }

    public static Ternary ternary(Expression condition, Expression thenExpression, Expression elseExpression) {
        return new Ternary(condition, thenExpression, elseExpression);
    }

    default public Assign assign(Expression expression) {
        return new Assign(this, expression);
    }

    default public Assign assign(Property property) {
        return new Assign(this, property);
    }

    default public Assign assignNew(Class type, Expression ... arguments) {
        return new Assign(this, new Construct(type, arguments));
    }

    default public Assign assignNew(ClassRef type, Expression ... arguments) {
        return new Assign(this, new Construct(type, arguments));
    }

    default public Assign assignNull() {
        return new Assign(this, ValueRef.NULL);
    }

    public static Construct createNew(Class type, Expression ... arguments) {
        return new Construct(type, arguments);
    }

    public static Construct createNew(ClassRef type, Expression ... arguments) {
        return new Construct(type, arguments);
    }

    public static NewArray createNewArray(Class type, Expression ... expressions) {
        return new NewArray(type, expressions);
    }

    public static NewArray createNewArray(TypeRef type, Expression ... expressions) {
        return new NewArray(type, expressions);
    }

    public static NewArray createNewArray(Class type, Integer ... sizes) {
        return new NewArray(type, sizes);
    }

    public static NewArray createNewArray(TypeRef type, Integer ... sizes) {
        return new NewArray(type, sizes);
    }

    public static Lambda lambda(Property parameter, Statement statement) {
        return new Lambda(parameter.getName(), statement);
    }

    public static Lambda lambda(Property parameter, Expression expression) {
        return new Lambda(parameter.getName(), expression);
    }

    public static Lambda lambda(String parameter, Expression expression) {
        return new Lambda(parameter, expression);
    }

    default public Statement ret() {
        return Statement.ret(this);
    }
}

