/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.ClassRef;
import io.sundr.model.Expression;
import io.sundr.model.PrimitiveRef;
import io.sundr.model.Property;
import io.sundr.model.TypeDef;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.stream.Collectors;

public class ValueRef
implements Expression {
    public static ValueRef NULL = new ValueRef(null);
    private final Object value;

    public ValueRef(Object value) {
        this.value = value;
    }

    public static <T> ValueRef from(T[] value) {
        return new ValueRef(value);
    }

    public static <T> ValueRef from(T value, T ... rest) {
        if (rest.length == 0) {
            return new ValueRef(value);
        }
        Object[] array = (Object[])Array.newInstance(value.getClass(), rest.length + 1);
        array[0] = value;
        System.arraycopy(rest, 0, array, 1, rest.length);
        return new ValueRef(array);
    }

    public Object getValue() {
        return this.value;
    }

    public static String toString(Object value) {
        if (value == null) {
            return "null";
        }
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            Object[] array = new Object[length];
            for (int i = 0; i < length; ++i) {
                array[i] = Array.get(value, i);
            }
            return "{" + Arrays.stream(array).map(ValueRef::toString).collect(Collectors.joining(", ")) + "}";
        }
        if (value instanceof Expression) {
            return ((Expression)value).renderExpression();
        }
        if (value instanceof Number) {
            return String.valueOf(value);
        }
        if (value instanceof Boolean) {
            return String.valueOf(value);
        }
        if (value instanceof String) {
            return "\"" + String.valueOf(value) + "\"";
        }
        if (value instanceof Property) {
            return ((Property)value).getName();
        }
        if (value instanceof TypeDef) {
            return ((TypeDef)value).getFullyQualifiedName() + ".class";
        }
        if (value instanceof ClassRef) {
            return ((ClassRef)value).getFullyQualifiedName() + ".class";
        }
        if (value instanceof PrimitiveRef) {
            return ((PrimitiveRef)value).getName() + ".class";
        }
        return "";
    }

    @Override
    public String render() {
        return ValueRef.toString(this.value);
    }
}

