/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.tui;

import io.sundr.tui.JLineTermInput;
import io.sundr.tui.Key;
import io.sundr.tui.KeyBinding;
import io.sundr.tui.TermFrameState;
import io.sundr.tui.TermInput;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.fusesource.jansi.AnsiConsole;
import org.jline.terminal.Terminal;

public class TermFrame
implements AutoCloseable {
    private static final String ESC = "\u001b[";
    private final PrintStream out;
    private Supplier<String> headerSupplier;
    private Supplier<String> footerSupplier;
    private int rows;
    private int cols;
    private int contentTop;
    private int contentBottom;
    private final Object renderLock = new Object();
    private boolean started = false;
    private Thread resizeThread;
    private final AtomicBoolean keepWatching = new AtomicBoolean(false);
    private int watchIntervalMs = 250;
    private final TermInput termInput;
    private Thread shutdownHook;
    private int currentLine;
    private final Map<Integer, KeyBinding> keyBindings;
    private final int helpKey;
    private final int exitKey;
    private final List<BiConsumer<TermFrame, Integer>> keyListeners;
    private List<String> contentBuffer;
    private int savedCurrentLine;
    private final List<String> displayedLines = new ArrayList<String>();
    private boolean helpMode = false;
    private TermFrameState savedState;

    private TermFrame(Supplier<String> headerSupplier, Supplier<String> footerSupplier, Integer initialRows, Integer initialCols, TermInput termInput, Map<Integer, KeyBinding> keyBindings, int helpKey, int exitKey, List<BiConsumer<TermFrame, Integer>> keyListeners) {
        this.out = AnsiConsole.out();
        this.headerSupplier = headerSupplier == null ? () -> "" : headerSupplier;
        this.footerSupplier = footerSupplier == null ? () -> "" : footerSupplier;
        this.termInput = termInput == null ? new JLineTermInput() : termInput;
        this.keyBindings = keyBindings == null ? new HashMap<Integer, KeyBinding>() : new HashMap<Integer, KeyBinding>(keyBindings);
        this.helpKey = helpKey;
        this.exitKey = exitKey;
        this.keyListeners = keyListeners == null ? new ArrayList<BiConsumer<TermFrame, Integer>>() : new ArrayList<BiConsumer<TermFrame, Integer>>(keyListeners);
        int[] size = this.detectSizeOrDefault(initialRows, initialCols);
        this.rows = size[0];
        this.cols = size[1];
        this.recomputeContentArea();
        this.validateHeights();
    }

    private TermFrame(Supplier<String> headerSupplier, Supplier<String> footerSupplier, Integer initialRows, Integer initialCols, TermInput termInput) {
        this(headerSupplier, footerSupplier, initialRows, initialCols, termInput, null, Key.QUESTION_MARK.getKeyCode(), Key.ESC.getKeyCode(), null);
    }

    public static TermFrame newFrame() {
        return new TermFrame(() -> "", () -> "", null, null, null);
    }

    public static TermFrame newFrame(Supplier<String> headerSupplier, Supplier<String> footerSupplier) {
        return new TermFrame(headerSupplier, footerSupplier, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.started) {
            return;
        }
        AnsiConsole.systemInstall();
        Object object = this.renderLock;
        synchronized (object) {
            this.hideCursor();
            this.fullRedraw();
            this.started = true;
            this.startResizeWatcher();
            this.shutdownHook = new Thread(() -> {
                try {
                    this.restoreTerminal();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }, "termframe-shutdown-hook");
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.renderLock;
        synchronized (object) {
            if (this.started) {
                try {
                    if (this.shutdownHook != null) {
                        Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                        this.shutdownHook = null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.restoreTerminal();
                this.started = false;
            }
        }
        try {
            this.termInput.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void restoreTerminal() {
        this.stopResizeWatcher();
        this.resetScrollRegion();
        this.clearScreen();
        this.moveCursor(1, 1);
        this.showCursor();
        this.out.print("\u001b[c");
        this.flush();
        AnsiConsole.systemUninstall();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearContent() {
        Object object = this.renderLock;
        synchronized (object) {
            for (int r = this.contentTop; r <= this.contentBottom; ++r) {
                this.moveCursor(r, 1);
                this.clearLine();
            }
            this.moveCursor(this.contentTop, 1);
            this.currentLine = this.contentTop;
            this.displayedLines.clear();
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String s) {
        Object object = this.renderLock;
        synchronized (object) {
            String[] lines;
            if (!this.started) {
                return;
            }
            for (String line : lines = (s == null ? "" : s).split("\\n|\\r")) {
                if (this.currentLine <= this.contentBottom) {
                    this.moveCursor(this.currentLine, 1);
                    this.clearLine();
                    this.out.print(line);
                    this.displayedLines.add(line);
                    ++this.currentLine;
                    continue;
                }
                this.moveCursor(this.contentBottom, 1);
                this.clearLine();
                this.out.print(line);
                this.out.print("\n");
                if (!this.displayedLines.isEmpty()) {
                    this.displayedLines.remove(0);
                }
                this.displayedLines.add(line);
            }
            this.drawHeader();
            this.drawFooter();
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printAt(int rowOffset, String s) {
        Object object = this.renderLock;
        synchronized (object) {
            int absRow = this.contentTop + rowOffset;
            if (absRow < this.contentTop || absRow > this.contentBottom) {
                return;
            }
            this.moveCursor(absRow, 1);
            this.clearLine();
            this.out.print(s == null ? "" : s);
            this.flush();
        }
    }

    public TermInput getTermInput() {
        return this.termInput;
    }

    public TermFrame withHeader(Supplier<String> headerSupplier) {
        return new TermFrame(headerSupplier, this.footerSupplier, null, null, this.termInput, this.keyBindings, this.helpKey, this.exitKey, this.keyListeners);
    }

    public TermFrame withHeader(String header) {
        return this.withHeader(() -> header);
    }

    public TermFrame withFooter(Supplier<String> footerSupplier) {
        return new TermFrame(this.headerSupplier, footerSupplier, null, null, this.termInput, this.keyBindings, this.helpKey, this.exitKey, this.keyListeners);
    }

    public TermFrame withFooter(String footer) {
        return this.withFooter(() -> footer);
    }

    public TermFrame withKeyBinding(Key key, String description, Consumer<TermFrame> action) {
        return this.withKeyBinding(key.getKeyCode(), description, action);
    }

    public TermFrame withKeyBinding(int keyCode, String description, Consumer<TermFrame> action) {
        HashMap<Integer, KeyBinding> newBindings = new HashMap<Integer, KeyBinding>(this.keyBindings);
        newBindings.put(keyCode, new KeyBinding(keyCode, description, action));
        return new TermFrame(this.headerSupplier, this.footerSupplier, null, null, this.termInput, newBindings, this.helpKey, this.exitKey, this.keyListeners);
    }

    public TermFrame withExitKey(Key exitKey) {
        return new TermFrame(this.headerSupplier, this.footerSupplier, null, null, this.termInput, this.keyBindings, this.helpKey, exitKey.getKeyCode(), this.keyListeners);
    }

    public TermFrame withHelpKey(Key helpKey) {
        return new TermFrame(this.headerSupplier, this.footerSupplier, null, null, this.termInput, this.keyBindings, helpKey.getKeyCode(), this.exitKey, this.keyListeners);
    }

    public TermFrame withHelpKey(int keyCode) {
        return new TermFrame(this.headerSupplier, this.footerSupplier, null, null, this.termInput, this.keyBindings, keyCode, this.exitKey, this.keyListeners);
    }

    public TermFrame withKeyListener(BiConsumer<TermFrame, Integer> listener) {
        ArrayList<BiConsumer<TermFrame, Integer>> newListeners = new ArrayList<BiConsumer<TermFrame, Integer>>(this.keyListeners);
        newListeners.add(listener);
        return new TermFrame(this.headerSupplier, this.footerSupplier, null, null, this.termInput, this.keyBindings, this.helpKey, this.exitKey, newListeners);
    }

    public boolean processKey(int keyCode) {
        if (this.helpMode) {
            this.helpMode = false;
            this.restoreContent();
            return true;
        }
        if (keyCode == this.exitKey) {
            return false;
        }
        if (keyCode == this.helpKey) {
            this.showHelp();
            return true;
        }
        KeyBinding binding = this.keyBindings.get(keyCode);
        if (binding != null) {
            binding.getAction().accept(this);
            return true;
        }
        return true;
    }

    public void showHelp() {
        this.saveContent();
        this.helpMode = true;
        this.clearContent();
        this.println("=== Key Bindings ===");
        this.println("");
        this.println(Key.getKeyName(this.exitKey) + " - Exit");
        this.println(Key.getKeyName(this.helpKey) + " - Show this help");
        for (KeyBinding binding : this.keyBindings.values()) {
            this.println(binding.getKeyName() + " - " + binding.getDescription());
        }
        if (this.keyBindings.isEmpty()) {
            this.println("(No custom key bindings defined)");
        }
        this.println("");
        this.println("Press any key to continue...");
    }

    private void saveContent() {
        this.contentBuffer = new ArrayList<String>(this.displayedLines);
        this.savedCurrentLine = this.currentLine;
    }

    public void restoreContent() {
        if (this.contentBuffer != null) {
            this.clearContent();
            for (String line : this.contentBuffer) {
                this.println(line);
            }
            this.contentBuffer = null;
        }
    }

    public void saveState() {
        this.savedState = new TermFrameState(this.headerSupplier, this.footerSupplier, new ArrayList<String>(this.displayedLines), this.currentLine);
    }

    public void restoreState() {
        if (this.savedState != null) {
            this.currentLine = this.savedState.getCurrentLine();
            this.clearContent();
            for (String line : this.savedState.getContentLines()) {
                this.println(line);
            }
            this.savedState = null;
        }
    }

    public void waitForAnyKeyPress(BiConsumer<TermFrame, Integer> callback) throws Exception {
        if (!this.started || this.termInput == null) {
            throw new IllegalStateException("TermFrame must be started before waiting for key press");
        }
        try (AutoCloseable rawMode = this.termInput.enterRawMode();){
            int key = this.termInput.readKey();
            if (key != -1) {
                callback.accept(this, key);
            }
        }
    }

    public void run() throws Exception {
        if (!this.started) {
            throw new IllegalStateException("TermFrame must be started before running event loop");
        }
        try (AutoCloseable rawMode = this.termInput.enterRawMode();){
            boolean running = true;
            while (running) {
                int key = this.termInput.readKey(1000L);
                if (key == -2) continue;
                if (key == -1) {
                    this.println("EOF received - exiting...");
                    break;
                }
                running = this.processKey(key);
                for (BiConsumer<TermFrame, Integer> listener : this.keyListeners) {
                    try {
                        listener.accept(this, key);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public int contentHeight() {
        return this.contentBottom - this.contentTop + 1;
    }

    public int rows() {
        return this.rows;
    }

    public int cols() {
        return this.cols;
    }

    public TermFrame watchIntervalMs(int ms) {
        this.watchIntervalMs = Math.max(50, ms);
        return this;
    }

    private void fullRedraw() {
        this.validateHeights();
        this.resetScrollRegion();
        this.clearScreen();
        this.drawHeader();
        this.drawFooter();
        this.setScrollRegion(this.contentTop, this.contentBottom);
        this.moveCursor(this.contentTop, 1);
        this.currentLine = this.contentTop;
        this.flush();
    }

    private void validateHeights() {
        int footerHeight;
        List<String> header = this.getHeaderLines();
        List<String> footer = this.getFooterLines();
        int headerHeight = header.size();
        if (headerHeight + (footerHeight = footer.size()) >= this.rows) {
            throw new IllegalStateException("Header+Footer exceed terminal height (" + this.rows + ")");
        }
    }

    private void recomputeContentArea() {
        List<String> header = this.getHeaderLines();
        List<String> footer = this.getFooterLines();
        int headerHeight = header.size();
        int footerHeight = footer.size();
        this.contentTop = headerHeight + 1;
        this.contentBottom = this.rows - footerHeight;
    }

    private List<String> getHeaderLines() {
        String headerText = this.headerSupplier.get();
        if (headerText == null || headerText.trim().isEmpty()) {
            return List.of();
        }
        return List.of(headerText.split("\\n"));
    }

    private List<String> getFooterLines() {
        String footerText = this.footerSupplier.get();
        if (footerText == null || footerText.trim().isEmpty()) {
            return List.of();
        }
        return List.of(footerText.split("\\n"));
    }

    private void drawHeader() {
        List<String> header = this.getHeaderLines();
        for (int i = 0; i < header.size(); ++i) {
            this.moveCursor(1 + i, 1);
            this.clearLine();
            this.out.print(header.get(i));
        }
    }

    private void drawFooter() {
        List<String> footer = this.getFooterLines();
        int topOfFooter = this.rows - footer.size() + 1;
        for (int i = 0; i < footer.size(); ++i) {
            this.moveCursor(topOfFooter + i, 1);
            this.clearLine();
            this.out.print(footer.get(i));
        }
    }

    private void clearScreen() {
        this.out.print("\u001b[2J\u001b[H");
    }

    private void clearLine() {
        this.out.print("\r");
        this.out.print("\u001b[2K");
    }

    private void moveCursor(int row, int col) {
        this.out.print(ESC + row + ";" + col + "H");
    }

    private void setScrollRegion(int top, int bottom) {
        this.out.print(ESC + top + ";" + bottom + "r");
    }

    private void resetScrollRegion() {
        this.out.print("\u001b[r");
    }

    private void hideCursor() {
        this.out.print("\u001b[?25l");
    }

    private void showCursor() {
        this.out.print("\u001b[?25h");
    }

    private void flush() {
        this.out.flush();
    }

    private int[] detectSizeOrDefault(Integer preferredRows, Integer preferredCols) {
        if (preferredRows != null && preferredRows > 0 && preferredCols != null && preferredCols > 0) {
            return new int[]{preferredRows, preferredCols};
        }
        if (this.termInput instanceof JLineTermInput) {
            try {
                JLineTermInput jlineInput = (JLineTermInput)this.termInput;
                Terminal terminal = jlineInput.getTerminal();
                if (terminal != null) {
                    int jlineRows = terminal.getHeight();
                    int jlineCols = terminal.getWidth();
                    if (jlineRows > 0 && jlineCols > 0) {
                        return new int[]{jlineRows, jlineCols};
                    }
                }
            }
            catch (Exception jlineInput) {
                // empty catch block
            }
        }
        int rows = TermFrame.detectRows().orElse(24);
        int cols = TermFrame.detectCols().orElse(80);
        return new int[]{rows, cols};
    }

    public static Optional<Integer> detectRows() {
        Integer v = TermFrame.runInt("stty size < /dev/tty", 0);
        if (v != null && v > 0) {
            return Optional.of(v);
        }
        v = TermFrame.runInt("tput lines", -1);
        return v != null && v > 0 ? Optional.of(v) : Optional.empty();
    }

    public static Optional<Integer> detectCols() {
        Integer v = TermFrame.runInt2("stty size < /dev/tty", 1);
        if (v != null && v > 0) {
            return Optional.of(v);
        }
        v = TermFrame.runInt("tput cols", -1);
        return v != null && v > 0 ? Optional.of(v) : Optional.empty();
    }

    private static Integer runInt(String cmd, int fallbackIfParseFail) {
        try {
            Process p = new ProcessBuilder("sh", "-c", cmd).redirectErrorStream(true).start();
            p.getOutputStream().close();
            String out = new String(p.getInputStream().readAllBytes(), StandardCharsets.UTF_8).trim();
            p.waitFor();
            return Integer.parseInt(out);
        }
        catch (Exception e) {
            return fallbackIfParseFail >= 0 ? Integer.valueOf(fallbackIfParseFail) : null;
        }
    }

    private static Integer runInt2(String cmd, int tokenIndex) {
        try {
            Process p = new ProcessBuilder("sh", "-c", cmd).redirectErrorStream(true).start();
            p.getOutputStream().close();
            String out = new String(p.getInputStream().readAllBytes(), StandardCharsets.UTF_8).trim();
            p.waitFor();
            if (out.isBlank()) {
                return null;
            }
            String[] parts = out.split("\\s+");
            if (parts.length <= tokenIndex) {
                return null;
            }
            return Integer.parseInt(parts[tokenIndex]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void startResizeWatcher() {
        this.keepWatching.set(true);
        this.resizeThread = new Thread(() -> {
            int lastRows = this.rows;
            int lastCols = this.cols;
            while (this.keepWatching.get()) {
                try {
                    int[] newSize = this.detectSizeOrDefault(null, null);
                    int r = newSize[0];
                    int c = newSize[1];
                    if (r != lastRows || c != lastCols) {
                        Object object = this.renderLock;
                        synchronized (object) {
                            this.rows = r;
                            this.cols = c;
                            this.recomputeContentArea();
                            this.fullRedraw();
                        }
                        lastRows = r;
                        lastCols = c;
                    }
                    Thread.sleep(this.watchIntervalMs);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    break;
                }
                catch (Exception exception) {
                }
            }
        }, "termframe-resize-watcher");
        this.resizeThread.setDaemon(true);
        this.resizeThread.start();
    }

    private void stopResizeWatcher() {
        this.keepWatching.set(false);
        if (this.resizeThread != null) {
            this.resizeThread.interrupt();
            try {
                this.resizeThread.join(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

