/*
 * Decompiled with CFR 0.152.
 */
package me.qoomon.gitversioning.commons;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringUtil {
    public static String substituteText(String text, Map<String, Supplier<String>> replacements) {
        StringBuffer result = new StringBuffer();
        Pattern placeholderPattern = Pattern.compile("\\$\\{(?<key>[^}:]+)(?<modifier>:?[-+])?(?<value>[^}]*)?}");
        Matcher placeholderMatcher = placeholderPattern.matcher(text);
        while (placeholderMatcher.find()) {
            String placeholderKey = placeholderMatcher.group("key");
            Supplier<String> replacementSupplier = replacements.get(placeholderKey);
            String replacement = replacementSupplier != null ? replacementSupplier.get() : null;
            String placeholderModifier = placeholderMatcher.group("modifier");
            if (placeholderModifier != null) {
                if (placeholderModifier.equals("-") && replacement == null) {
                    replacement = placeholderMatcher.group("value");
                }
                if (placeholderModifier.equals("+") && replacement != null) {
                    replacement = placeholderMatcher.group("value");
                }
                if (placeholderModifier.equals(":-") && (replacement == null || replacement.isEmpty())) {
                    replacement = placeholderMatcher.group("value");
                }
                if (placeholderModifier.equals(":+") && replacement != null && !replacement.isEmpty()) {
                    replacement = placeholderMatcher.group("value");
                }
            }
            if (replacement == null) continue;
            placeholderMatcher.appendReplacement(result, "");
            result.append(replacement);
        }
        placeholderMatcher.appendTail(result);
        return result.toString();
    }

    public static Map<String, String> patternGroupValues(Pattern pattern, String text) {
        HashMap<String, String> result = new HashMap<String, String>();
        Matcher groupMatcher = pattern.matcher(text);
        if (groupMatcher.find()) {
            for (int i = 1; i <= groupMatcher.groupCount(); ++i) {
                result.put(String.valueOf(i), groupMatcher.group(i));
            }
            for (String groupName : StringUtil.patternGroupNames(pattern)) {
                result.put(groupName, groupMatcher.group(groupName));
            }
        }
        return result;
    }

    public static Set<String> patternGroups(Pattern pattern) {
        HashSet<String> groups = new HashSet<String>();
        for (int groupIndex = 1; groupIndex <= StringUtil.patternGroupCount(pattern); ++groupIndex) {
            groups.add(String.valueOf(groupIndex));
        }
        groups.addAll(StringUtil.patternGroupNames(pattern));
        return groups;
    }

    public static int patternGroupCount(Pattern pattern) {
        return pattern.matcher("").groupCount();
    }

    public static Set<String> patternGroupNames(Pattern pattern) {
        HashSet<String> groups = new HashSet<String>();
        Pattern groupNamePattern = Pattern.compile("\\(\\?<(?<name>[a-zA-Z][a-zA-Z0-9]*)>");
        Matcher groupNameMatcher = groupNamePattern.matcher(pattern.toString());
        while (groupNameMatcher.find()) {
            String groupName = groupNameMatcher.group("name");
            groups.add(groupName);
        }
        return groups;
    }
}

