/*
 * Decompiled with CFR 0.152.
 */
package net.revelc.code.impsort;

import com.github.javaparser.Position;
import com.github.javaparser.Problem;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.revelc.code.impsort.Import;
import net.revelc.code.impsort.LineEnding;

public class Result {
    private Boolean isSorted;
    private final Path path;
    private final Charset sourceEncoding;
    private final String originalSection;
    private final String newSection;
    private final Collection<Import> allImports;
    private final List<String> fileLines;
    private final int start;
    private final int stop;
    private final LineEnding lineEnding;
    private List<Problem> problems;
    private List<Problem> reportableProblems;
    public static final Result EMPTY_FILE = new Result(null, null, null, 0, 0, "", "", Collections.emptyList(), null, null, null);

    Result(Path path, Charset sourceEncoding, List<String> fileLines, int start, int stop, String originalSection, String newSection, Collection<Import> allImports, LineEnding lineEnding, List<Problem> problems, List<Problem> reportableProblems) {
        this.path = path;
        this.sourceEncoding = sourceEncoding;
        this.originalSection = originalSection;
        this.newSection = newSection;
        this.allImports = allImports;
        this.fileLines = fileLines;
        this.start = start;
        this.stop = stop;
        this.lineEnding = lineEnding;
        this.problems = problems;
        this.reportableProblems = reportableProblems;
    }

    public boolean isSorted() {
        if (this.isSorted == null) {
            this.isSorted = this.originalSection.contentEquals(this.newSection);
        }
        return this.isSorted;
    }

    public Collection<Import> getImports() {
        return Collections.unmodifiableCollection(this.allImports);
    }

    public void saveBackup(Path destination) throws IOException {
        Files.copy(this.path, destination, StandardCopyOption.REPLACE_EXISTING);
    }

    public byte[] saveSorted(Path destination) throws IOException {
        if (this.isSorted()) {
            if (!Files.isSameFile(this.path, destination)) {
                this.saveBackup(destination);
            }
            return null;
        }
        List<String> beforeImports = this.fileLines.subList(0, this.start);
        List<String> importLines = Arrays.asList(this.newSection.split(this.lineEnding.getChars()));
        List<String> afterImports = this.fileLines.subList(this.stop, this.fileLines.size());
        ArrayList<String> allLines = new ArrayList<String>(beforeImports.size() + importLines.size() + afterImports.size() + 1);
        allLines.addAll(beforeImports);
        allLines.addAll(importLines);
        if (afterImports.size() > 0) {
            allLines.add("");
        }
        allLines.addAll(afterImports);
        return this.writeLines(destination, allLines, this.sourceEncoding);
    }

    private byte[] writeLines(Path destination, List<String> lines, Charset sourceEncoding) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baos, sourceEncoding.newEncoder());){
            for (String line : lines) {
                writer.write(line);
                writer.write(this.lineEnding.getChars());
            }
        }
        byte[] buf = baos.toByteArray();
        Files.write(destination, buf, new OpenOption[0]);
        return buf;
    }

    public Position getFirstLineContaining(String string) {
        for (int i = 0; i < this.fileLines.size(); ++i) {
            if (!this.fileLines.get(i).contains(string)) continue;
            return new Position(i, 0);
        }
        throw new IllegalStateException("Can't find '" + string + "'!");
    }

    public List<Problem> getProblems() {
        return Collections.unmodifiableList(this.problems);
    }

    public List<Problem> getReportableProblems() {
        return Collections.unmodifiableList(this.reportableProblems);
    }
}

