/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli;

import alluxio.AlluxioURI;
import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.FuseCommand;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.runtime.InvalidArgumentRuntimeException;
import alluxio.exception.status.InvalidArgumentException;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FuseShell {
    private static final Logger LOG = LoggerFactory.getLogger(FuseShell.class);
    private final AlluxioConfiguration mConf;
    private final FileSystem mFileSystem;
    private final Map<String, Command> mCommands;

    public FuseShell(FileSystem fs, AlluxioConfiguration conf) {
        this.mFileSystem = fs;
        this.mConf = conf;
        this.mCommands = CommandUtils.loadCommands((String)FuseShell.class.getPackage().getName(), (Class[])new Class[]{FileSystem.class, AlluxioConfiguration.class}, (Object[])new Object[]{this.mFileSystem, this.mConf});
    }

    public boolean isSpecialCommand(AlluxioURI uri) {
        int index = uri.getPath().lastIndexOf("/");
        return index != -1 && uri.getPath().substring(index).startsWith("/.alluxiocli");
    }

    public URIStatus runCommand(AlluxioURI uri) {
        AlluxioURI path = uri.getParent();
        int index = uri.getPath().lastIndexOf("/.alluxiocli");
        String cmdsInfo = uri.getPath().substring(index);
        String[] cmds = cmdsInfo.split("\\.");
        if (cmds.length <= 2) {
            this.logUsage();
            throw new InvalidArgumentRuntimeException("Command is needed in Fuse shell");
        }
        FuseCommand command = (FuseCommand)this.mCommands.get(cmds[2]);
        if (command == null) {
            this.logUsage();
            throw new InvalidArgumentRuntimeException(String.format("%s is an unknown command.", cmds[2]));
        }
        try {
            String[] currArgs = Arrays.copyOfRange(cmds, 2, cmds.length);
            while (command.hasSubCommand()) {
                if (currArgs.length < 2) {
                    throw new InvalidArgumentRuntimeException("No sub-command is specified");
                }
                if (!command.getSubCommands().containsKey(currArgs[1])) {
                    throw new InvalidArgumentRuntimeException("Unknown sub-command: " + currArgs[1]);
                }
                command = (FuseCommand)command.getSubCommands().get(currArgs[1]);
                currArgs = Arrays.copyOfRange(currArgs, 1, currArgs.length);
            }
            command.validateArgs(Arrays.copyOfRange(currArgs, 1, currArgs.length));
            return command.run(path, Arrays.copyOfRange(currArgs, 1, currArgs.length));
        }
        catch (InvalidArgumentException e) {
            LOG.info(command.getDescription());
            LOG.info("Usage: " + command.getUsage());
            throw new InvalidArgumentRuntimeException(String.format("Invalid arguments for command %s, For detailed usage please see the log formation.", command.getCommandName()), (Throwable)e);
        }
    }

    private void logUsage() {
        LOG.info(PropertyKey.FUSE_SPECIAL_COMMAND_ENABLED.getDescription());
    }
}

