/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.command.metadatacache;

import alluxio.AlluxioURI;
import alluxio.cli.command.metadatacache.AbstractMetadataCacheSubCommand;
import alluxio.client.file.FileSystem;
import alluxio.client.file.MetadataCachingFileSystem;
import alluxio.client.file.URIStatus;
import alluxio.conf.AlluxioConfiguration;
import alluxio.wire.FileInfo;

public final class SizeCommand
extends AbstractMetadataCacheSubCommand {
    public SizeCommand(FileSystem fs, AlluxioConfiguration conf, String parentCommandName) {
        super(fs, conf, parentCommandName);
    }

    public String getCommandName() {
        return "size";
    }

    public String getUsage() {
        return String.format("%s%s.%s.%s", "/mnt/alluxio-fuse", "/.alluxiocli", this.getParentCommandName(), this.getCommandName());
    }

    @Override
    protected URIStatus runSubCommand(AlluxioURI path, String[] argv, MetadataCachingFileSystem fileSystem) {
        long size = fileSystem.getMetadataCacheSize();
        return new URIStatus(new FileInfo().setLength(size).setCompleted(true));
    }

    public String getDescription() {
        return "Get fuse client metadata size.";
    }
}

