/*
 * Decompiled with CFR 0.152.
 */
package alluxio.fuse;

import alluxio.AlluxioURI;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.URIStatus;
import alluxio.client.file.options.UfsFileSystemOptions;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.exception.AccessControlException;
import alluxio.exception.AlluxioException;
import alluxio.exception.ConnectionFailedException;
import alluxio.exception.DirectoryNotEmptyException;
import alluxio.exception.FileAlreadyCompletedException;
import alluxio.exception.FileAlreadyExistsException;
import alluxio.exception.FileDoesNotExistException;
import alluxio.exception.InvalidPathException;
import alluxio.exception.runtime.AlluxioRuntimeException;
import alluxio.exception.runtime.AlreadyExistsRuntimeException;
import alluxio.exception.runtime.BlockDoesNotExistRuntimeException;
import alluxio.exception.runtime.FailedPreconditionRuntimeException;
import alluxio.exception.runtime.InvalidArgumentRuntimeException;
import alluxio.exception.runtime.NotFoundRuntimeException;
import alluxio.exception.runtime.PermissionDeniedRuntimeException;
import alluxio.exception.runtime.UnavailableRuntimeException;
import alluxio.fuse.auth.AuthPolicy;
import alluxio.fuse.file.CreateFileStatus;
import alluxio.fuse.options.FuseOptions;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.SetAttributePOptions;
import alluxio.jnifuse.ErrorCodes;
import alluxio.jnifuse.struct.FileStat;
import alluxio.jnifuse.struct.FuseFileInfo;
import alluxio.jnifuse.utils.Environment;
import alluxio.jnifuse.utils.LibfuseVersion;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.retry.RetryPolicy;
import alluxio.retry.RetryUtils;
import alluxio.security.authorization.Mode;
import alluxio.util.CommonUtils;
import alluxio.util.OSUtils;
import alluxio.util.ShellUtils;
import alluxio.util.WaitForOptions;
import alluxio.util.io.BufferUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class AlluxioFuseUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AlluxioFuseUtils.class);
    private static final long THRESHOLD = Configuration.global().getMs(PropertyKey.FUSE_LOGGING_THRESHOLD);
    private static final int MAX_ASYNC_RELEASE_WAITTIME_MS = 5000;
    private static final int MAX_LOCK_WAIT_TIME = 20000;
    public static final int MAX_NAME_LENGTH = 255;
    public static final long ID_NOT_SET_VALUE = -1L;
    public static final long ID_NOT_SET_VALUE_UNSIGNED = 0xFFFFFFFFL;
    public static final long MODE_NOT_SET_VALUE = -1L;
    public static final String MACFUSE_SUPPORT_MINIMUM_OS_VERSION = "10.9";

    private AlluxioFuseUtils() {
    }

    public static int checkNameLength(AlluxioURI uri) {
        if (uri.getName().length() > 255) {
            LOG.error("Failed to execute on {}: name longer than {} characters", (Object)uri, (Object)255);
            return -ErrorCodes.ENAMETOOLONG();
        }
        return 0;
    }

    public static FileOutStream createFile(FileSystem fileSystem, AuthPolicy authPolicy, AlluxioURI uri, CreateFileStatus fileStatus) {
        CreateFilePOptions.Builder optionsBuilder = CreateFilePOptions.newBuilder();
        if (fileStatus.getMode() != -1L) {
            optionsBuilder.setMode(new Mode((short)fileStatus.getMode()).toProto());
        }
        try {
            FileOutStream out = fileSystem.createFile(uri, optionsBuilder.build());
            authPolicy.setUserGroup(uri, fileStatus.getUid(), fileStatus.getGid());
            return out;
        }
        catch (FileAlreadyExistsException e) {
            throw new AlreadyExistsRuntimeException((Throwable)e);
        }
        catch (InvalidPathException e) {
            throw new InvalidArgumentRuntimeException((Throwable)e);
        }
        catch (AlluxioException | IOException e) {
            throw AlluxioRuntimeException.from((Throwable)e);
        }
    }

    public static void deletePath(FileSystem fileSystem, AlluxioURI uri) {
        try {
            fileSystem.delete(uri);
        }
        catch (FileDoesNotExistException e) {
            throw new NotFoundRuntimeException((Throwable)e);
        }
        catch (AlluxioException | IOException e) {
            throw AlluxioRuntimeException.from((Throwable)e);
        }
    }

    public static void setAttribute(FileSystem fileSystem, AlluxioURI uri, SetAttributePOptions options) {
        try {
            fileSystem.setAttribute(uri, options);
        }
        catch (FileDoesNotExistException e) {
            throw new NotFoundRuntimeException((Throwable)e);
        }
        catch (AlluxioException | IOException e) {
            throw AlluxioRuntimeException.from((Throwable)e);
        }
    }

    public static LibfuseVersion getLibfuseVersion(AlluxioConfiguration conf) {
        if (Environment.isMac()) {
            LOG.info("osxfuse doesn't support libfuse3 api. Using libfuse version 2.");
            return LibfuseVersion.VERSION_2;
        }
        int val = conf.getInt(PropertyKey.FUSE_JNIFUSE_LIBFUSE_VERSION);
        if (val == 2) {
            return LibfuseVersion.VERSION_2;
        }
        if (val == 3) {
            return LibfuseVersion.VERSION_3;
        }
        throw new InvalidArgumentRuntimeException(String.format("Libfuse version %d is invalid", val));
    }

    public static AlluxioConfiguration tryLoadingConfigFromMaster(FileSystemContext fsContext) {
        try {
            InetSocketAddress confMasterAddress = fsContext.getMasterClientContext().getConfMasterInquireClient().getPrimaryRpcAddress();
            RetryUtils.retry((String)("load cluster default configuration with master " + confMasterAddress), () -> fsContext.getClientContext().loadConfIfNotLoaded(confMasterAddress), (RetryPolicy)RetryUtils.defaultClientRetry());
        }
        catch (IOException e) {
            LOG.warn("Failed to load cluster default configuration for Fuse process. Proceed with local configuration for FUSE: {}", (Object)e.toString());
        }
        return fsContext.getClusterConf();
    }

    public static void fillStat(AuthPolicy policy, FileStat stat, URIStatus status) {
        AlluxioFuseUtils.updateStatSize(stat, status.getLength());
        long ctime_sec = status.getLastModificationTimeMs() / 1000L;
        long atime_sec = status.getLastAccessTimeMs() / 1000L;
        long ctime_nsec = status.getLastModificationTimeMs() % 1000L * 1000000L;
        long atime_nsec = status.getLastAccessTimeMs() % 1000L * 1000000L;
        stat.st_atim.tv_sec.set(atime_sec);
        stat.st_atim.tv_nsec.set((Number)atime_nsec);
        stat.st_ctim.tv_sec.set(ctime_sec);
        stat.st_ctim.tv_nsec.set((Number)ctime_nsec);
        stat.st_mtim.tv_sec.set(ctime_sec);
        stat.st_mtim.tv_nsec.set((Number)ctime_nsec);
        stat.st_uid.set((Number)policy.getUid(status.getOwner()).orElse(-1L));
        stat.st_gid.set((Number)policy.getGid(status.getGroup()).orElse(-1L));
        int mode = status.getMode();
        mode = status.isFolder() ? (mode |= 0x4000) : (mode |= 0x8000);
        stat.st_mode.set((Number)mode);
        stat.st_nlink.set((Number)1);
    }

    public static void fillStat(FileStat stat, CreateFileStatus status) {
        stat.st_mode.set((Number)(status.getMode() | 0x8000L));
        stat.st_uid.set(status.getUid());
        stat.st_gid.set(status.getGid());
        stat.st_nlink.set((Number)1);
        AlluxioFuseUtils.updateStatSize(stat, status.getFileLength());
        long timeSec = System.currentTimeMillis() / 1000L;
        stat.st_atim.tv_sec.set(timeSec);
        stat.st_atim.tv_nsec.set((Number)timeSec);
        stat.st_ctim.tv_sec.set(timeSec);
        stat.st_ctim.tv_nsec.set((Number)timeSec);
        stat.st_mtim.tv_sec.set(timeSec);
        stat.st_mtim.tv_nsec.set((Number)timeSec);
    }

    public static void updateStatSize(FileStat stat, long size) {
        stat.st_size.set((Number)size);
        stat.st_blocks.set((Number)((int)Math.ceil((double)size / 512.0)));
    }

    public static long getSystemUid() {
        String launchUser = System.getProperty("user.name");
        if (launchUser == null || launchUser.isEmpty()) {
            throw new UnavailableRuntimeException("Failed to get current system user name");
        }
        Optional<Long> launchUserId = AlluxioFuseUtils.getUid(launchUser);
        if (!launchUserId.isPresent()) {
            throw new FailedPreconditionRuntimeException("Failed to get uid of system user " + launchUser);
        }
        return launchUserId.get();
    }

    public static long getSystemGid() {
        String launchUser = System.getProperty("user.name");
        if (launchUser == null || launchUser.isEmpty()) {
            throw new FailedPreconditionRuntimeException("Failed to get current system user name");
        }
        Optional<String> launchGroupName = AlluxioFuseUtils.getGroupName(launchUser);
        if (!launchGroupName.isPresent()) {
            throw new FailedPreconditionRuntimeException("Failed to get group name from system user name " + launchUser);
        }
        Optional<Long> launchGroupId = AlluxioFuseUtils.getGidFromGroupName(launchGroupName.get());
        if (!launchGroupId.isPresent()) {
            throw new FailedPreconditionRuntimeException("Failed to get gid of system group " + launchGroupName.get());
        }
        return launchGroupId.get();
    }

    public static Optional<Long> getUid(String userName) {
        return AlluxioFuseUtils.getIdInfo("-u", userName);
    }

    public static Optional<Long> getGidFromUserName(String userName) {
        return AlluxioFuseUtils.getIdInfo("-g", userName);
    }

    public static Optional<Long> getGidFromGroupName(String groupName) {
        try {
            if (OSUtils.isLinux()) {
                String script = "getent group " + groupName + " | cut -d: -f3";
                String result = ShellUtils.execCommand((String[])new String[]{"bash", "-c", script}).trim();
                return Optional.of(Long.parseLong(result));
            }
            if (OSUtils.isMacOS()) {
                String script = "dscl . -read /Groups/" + groupName + " | awk '($1 == \"PrimaryGroupID:\") { print $2 }'";
                String result = ShellUtils.execCommand((String[])new String[]{"bash", "-c", script}).trim();
                return Optional.of(Long.parseLong(result));
            }
            return Optional.empty();
        }
        catch (IOException | NumberFormatException e) {
            LOG.error("Failed to get gid from group name {}.", (Object)groupName);
            return Optional.empty();
        }
    }

    public static Optional<String> getUserName(long uid) {
        if (uid == -1L || uid == 0xFFFFFFFFL) {
            return Optional.empty();
        }
        try {
            String userName = ShellUtils.execCommand((String[])new String[]{"bash", "-c", "id -nu " + uid}).trim();
            return userName.isEmpty() ? Optional.empty() : Optional.of(userName);
        }
        catch (IOException e) {
            LOG.error("Failed to get user name of uid {}", (Object)uid, (Object)e);
            return Optional.empty();
        }
    }

    public static Optional<String> getGroupName(String userName) {
        try {
            List groups = CommonUtils.getUnixGroups((String)userName);
            return groups.isEmpty() ? Optional.empty() : Optional.of(groups.get(0));
        }
        catch (IOException e) {
            LOG.error("Failed to get group name of user name {}", (Object)userName, (Object)e);
            return Optional.empty();
        }
    }

    public static Optional<String> getGroupName(long gid) {
        if (gid == -1L || gid == 0xFFFFFFFFL) {
            return Optional.empty();
        }
        try {
            String groupName = null;
            if (OSUtils.isLinux()) {
                String script = "getent group " + gid + " | cut -d: -f1";
                groupName = ShellUtils.execCommand((String[])new String[]{"bash", "-c", script}).trim();
            } else if (OSUtils.isMacOS()) {
                String script = "dscl . list /Groups PrimaryGroupID | awk '($2 == \"" + gid + "\") { print $1 }'";
                groupName = ShellUtils.execCommand((String[])new String[]{"bash", "-c", script}).trim();
            }
            return groupName == null || groupName.isEmpty() ? Optional.empty() : Optional.of(groupName);
        }
        catch (IOException e) {
            LOG.error("Failed to get group name of gid {}", (Object)gid, (Object)e);
            return Optional.empty();
        }
    }

    public static boolean isFuseInstalled() {
        try {
            if (OSUtils.isLinux()) {
                String result = ShellUtils.execCommand((String[])new String[]{"fusermount", "-V"});
                return !result.isEmpty();
            }
            if (OSUtils.isMacOS()) {
                String result = ShellUtils.execCommand((String[])new String[]{"bash", "-c", "pkgutil --pkgs | grep -i " + (AlluxioFuseUtils.isMacFuse() ? "io.macfuse.installer.components.core" : "com.github.osxfuse.pkg.Core")});
                return !result.isEmpty();
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static boolean isMacFuse() {
        return AlluxioFuseUtils.compareVersion(SystemUtils.OS_VERSION, MACFUSE_SUPPORT_MINIMUM_OS_VERSION) >= 0;
    }

    public static int compareVersion(String version1, String version2) {
        String[] versionParts1 = version1.split("\\.");
        String[] versionParts2 = version2.split("\\.");
        int minLength = Math.min(versionParts1.length, versionParts2.length);
        int diff = 0;
        for (int idx = 0; idx < minLength && (diff = Integer.parseInt(versionParts1[idx]) - Integer.parseInt(versionParts2[idx])) == 0; ++idx) {
        }
        diff = diff != 0 ? diff : versionParts1.length - versionParts2.length;
        return diff;
    }

    private static Optional<Long> getIdInfo(String option, String username) {
        try {
            String output = ShellUtils.execCommand((String[])new String[]{"id", option, username}).trim();
            return Optional.of(Long.parseLong(output));
        }
        catch (IOException | NumberFormatException e) {
            LOG.error("Failed to get id from {} with option {}", (Object)username, (Object)option);
            return Optional.empty();
        }
    }

    public static int getErrorCode(Throwable t) {
        if (t instanceof AlluxioException) {
            return AlluxioFuseUtils.getAlluxioErrorCode((AlluxioException)t);
        }
        if (t instanceof IOException) {
            return -ErrorCodes.EIO();
        }
        return -ErrorCodes.EBADMSG();
    }

    private static int getAlluxioErrorCode(AlluxioException e) {
        try {
            throw e;
        }
        catch (FileDoesNotExistException ex) {
            return -ErrorCodes.ENOENT();
        }
        catch (FileAlreadyExistsException ex) {
            return -ErrorCodes.EEXIST();
        }
        catch (InvalidPathException ex) {
            return -ErrorCodes.EFAULT();
        }
        catch (BlockDoesNotExistRuntimeException ex) {
            return -ErrorCodes.ENODATA();
        }
        catch (DirectoryNotEmptyException ex) {
            return -ErrorCodes.ENOTEMPTY();
        }
        catch (AccessControlException ex) {
            return -ErrorCodes.EACCES();
        }
        catch (ConnectionFailedException ex) {
            return -ErrorCodes.ECONNREFUSED();
        }
        catch (FileAlreadyCompletedException ex) {
            return -ErrorCodes.EOPNOTSUPP();
        }
        catch (AlluxioException ex) {
            return -ErrorCodes.EBADMSG();
        }
    }

    public static Optional<URIStatus> getPathStatus(FileSystem fileSystem, AlluxioURI uri) {
        try {
            return Optional.of(fileSystem.getStatus(uri));
        }
        catch (FileDoesNotExistException | InvalidPathException | NotFoundRuntimeException | FileNotFoundException e) {
            return Optional.empty();
        }
        catch (AccessControlException e) {
            throw new PermissionDeniedRuntimeException((Throwable)e);
        }
        catch (AlluxioException | IOException ex) {
            throw AlluxioRuntimeException.from((Throwable)ex);
        }
    }

    public static Optional<URIStatus> waitForFileCompleted(FileSystem fileSystem, AlluxioURI uri) {
        try {
            return Optional.of(CommonUtils.waitForResult((String)"file completed", () -> {
                try {
                    return fileSystem.getStatus(uri);
                }
                catch (Exception e) {
                    throw AlluxioRuntimeException.from((Throwable)e);
                }
            }, URIStatus::isCompleted, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(5000L)));
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            return Optional.empty();
        }
        catch (TimeoutException te) {
            return Optional.empty();
        }
    }

    public static int call(Logger logger, FuseCallable callable, String methodName, String description, Object ... args) {
        int ret;
        try {
            String debugDesc = logger.isDebugEnabled() ? String.format(description, args) : null;
            logger.debug("Enter: {}({})", (Object)methodName, (Object)debugDesc);
            long startMs = System.currentTimeMillis();
            ret = callable.call();
            long durationMs = System.currentTimeMillis() - startMs;
            logger.debug("Exit ({}): {}({}) in {} ms", new Object[]{ret, methodName, debugDesc, durationMs});
            MetricsSystem.timer((String)methodName).update(durationMs, TimeUnit.MILLISECONDS);
            MetricsSystem.timer((String)MetricKey.FUSE_TOTAL_CALLS.getName()).update(durationMs, TimeUnit.MILLISECONDS);
            if (ret < 0) {
                MetricsSystem.counter((String)(methodName + "Failures")).inc();
            }
            if (durationMs >= THRESHOLD) {
                logger.warn("{}({}) returned {} in {} ms (>={} ms)", new Object[]{methodName, String.format(description, args), ret, durationMs, THRESHOLD});
            }
        }
        catch (Throwable t) {
            String errorMessage;
            try {
                errorMessage = String.format(description, args);
            }
            catch (Throwable inner) {
                errorMessage = "";
            }
            LOG.error("Failed to {}({}) with unexpected throwable: ", new Object[]{methodName, errorMessage, t});
            return -ErrorCodes.EIO();
        }
        return ret;
    }

    public static String getMountedRootPath(AlluxioConfiguration conf, FuseOptions fuseOptions) {
        Optional options = fuseOptions.getFileSystemOptions().getUfsFileSystemOptions();
        return options.isPresent() ? ((UfsFileSystemOptions)options.get()).getUfsAddress() : conf.getString(PropertyKey.FUSE_MOUNT_ALLUXIO_PATH);
    }

    public static LoadingCache<String, AlluxioURI> getPathResolverCache(AlluxioConfiguration conf, FuseOptions options) {
        return CacheBuilder.newBuilder().maximumSize((long)conf.getInt(PropertyKey.FUSE_CACHED_PATHS_MAX)).build((CacheLoader)new PathCacheLoader(new AlluxioURI(AlluxioFuseUtils.getMountedRootPath(conf, options))));
    }

    @VisibleForTesting
    public static class CloseableFuseFileInfo
    implements Closeable {
        private final FuseFileInfo mInfo;
        private final ByteBuffer mBuffer = ByteBuffer.allocateDirect(36);

        public CloseableFuseFileInfo() {
            this.mBuffer.clear();
            this.mInfo = FuseFileInfo.of((ByteBuffer)this.mBuffer);
        }

        public FuseFileInfo get() {
            return this.mInfo;
        }

        @Override
        public void close() throws IOException {
            BufferUtils.cleanDirectBuffer((ByteBuffer)this.mBuffer);
        }
    }

    static final class PathCacheLoader
    extends CacheLoader<String, AlluxioURI> {
        private final AlluxioURI mRootURI;

        PathCacheLoader(AlluxioURI rootURI) {
            this.mRootURI = (AlluxioURI)Preconditions.checkNotNull((Object)rootURI);
        }

        public AlluxioURI load(String fusePath) {
            return this.mRootURI.join(fusePath);
        }
    }

    public static interface FuseCallable {
        public int call();
    }
}

