/*
 * Decompiled with CFR 0.152.
 */
package alluxio.fuse;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class CreateFileEntry<T extends OutputStream>
implements Closeable {
    private final long mId;
    private final T mOut;
    private String mPath;

    public CreateFileEntry(long id, String path, T out) {
        Preconditions.checkArgument((id != -1L && !path.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((out != null ? 1 : 0) != 0);
        this.mId = id;
        this.mOut = out;
        this.mPath = path;
    }

    public long getId() {
        return this.mId;
    }

    public String getPath() {
        return this.mPath;
    }

    public T getOut() {
        return this.mOut;
    }

    public void setPath(String path) {
        this.mPath = path;
    }

    @Override
    public void close() throws IOException {
        if (this.mOut != null) {
            ((OutputStream)this.mOut).close();
        }
    }
}

