/*
 * Decompiled with CFR 0.152.
 */
package alluxio.fuse;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class OpenFileEntry<T1 extends InputStream, T2 extends OutputStream>
implements Closeable {
    private final long mId;
    private final T1 mIn;
    private final T2 mOut;
    private String mPath;
    private long mOffset;

    public OpenFileEntry(long id, String path, T1 in, T2 out) {
        Preconditions.checkArgument((id != -1L && !path.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((in != null || out != null ? 1 : 0) != 0);
        this.mId = id;
        this.mIn = in;
        this.mOut = out;
        this.mPath = path;
        this.mOffset = -1L;
    }

    public long getId() {
        return this.mId;
    }

    public String getPath() {
        return this.mPath;
    }

    @Nullable
    public T1 getIn() {
        return this.mIn;
    }

    @Nullable
    public T2 getOut() {
        return this.mOut;
    }

    public long getWriteOffset() {
        return this.mOffset;
    }

    public void setPath(String path) {
        this.mPath = path;
    }

    public void setWriteOffset(long offset) {
        this.mOffset = offset;
    }

    @Override
    public void close() throws IOException {
        if (this.mIn != null) {
            ((InputStream)this.mIn).close();
        }
        if (this.mOut != null) {
            ((OutputStream)this.mOut).close();
        }
        this.mOffset = -1L;
    }
}

