/*
 * Decompiled with CFR 0.152.
 */
package alluxio.fuse;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.fuse.AlluxioFuseUtils;
import alluxio.fuse.StackFS;
import alluxio.jnifuse.LibFuse;
import alluxio.jnifuse.utils.LibfuseVersion;
import alluxio.metrics.MetricsSystem;
import alluxio.util.CommonUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;

public class StackMain {
    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: <mountPoint> <sourcePath> <fuseOpts e.g. -obig_writes...>");
            System.exit(1);
        }
        Path root = Paths.get(args[1], new String[0]);
        Path mountPoint = Paths.get(args[0], new String[0]);
        AlluxioConfiguration conf = Configuration.global();
        LibFuse.loadLibrary((LibfuseVersion)AlluxioFuseUtils.getLibfuseVersion(conf));
        StackFS fs = new StackFS(root, mountPoint);
        HashSet<String> fuseOpts = new HashSet<String>();
        for (int i = 2; i < args.length; ++i) {
            fuseOpts.add(args[i].substring(2));
        }
        try {
            CommonUtils.PROCESS_TYPE.set(CommonUtils.ProcessType.CLIENT);
            MetricsSystem.startSinks((String)conf.getString(PropertyKey.METRICS_CONF_FILE));
            fs.mount(true, false, fuseOpts);
        }
        catch (Exception e) {
            e.printStackTrace();
            fs.umount(true);
            System.exit(1);
        }
    }
}

