/*
 * Decompiled with CFR 0.152.
 */
package alluxio.fuse.auth;

import alluxio.AlluxioURI;
import alluxio.client.file.FileSystem;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.exception.runtime.AlluxioRuntimeException;
import alluxio.exception.runtime.InternalRuntimeException;
import alluxio.fuse.AlluxioFuseUtils;
import alluxio.fuse.auth.LaunchUserGroupAuthPolicy;
import alluxio.grpc.SetAttributePOptions;
import alluxio.jnifuse.FuseFileSystem;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomAuthPolicy
extends LaunchUserGroupAuthPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(CustomAuthPolicy.class);
    private final long mUid;
    private final long mGid;
    private final SetAttributePOptions mSetAttributeOptions;

    public static CustomAuthPolicy create(FileSystem fileSystem, AlluxioConfiguration conf, Optional<FuseFileSystem> fuseFileSystem) {
        String className = CustomAuthPolicy.class.getName();
        String owner = conf.getString(PropertyKey.FUSE_AUTH_POLICY_CUSTOM_USER);
        String group = conf.getString(PropertyKey.FUSE_AUTH_POLICY_CUSTOM_GROUP);
        Preconditions.checkArgument((!owner.isEmpty() ? 1 : 0) != 0, (Object)String.format("%s should not be null or empty when using %s", PropertyKey.FUSE_AUTH_POLICY_CUSTOM_USER.getName(), className));
        Preconditions.checkArgument((!group.isEmpty() ? 1 : 0) != 0, (Object)String.format("%s should not be null or empty when using %s", PropertyKey.FUSE_AUTH_POLICY_CUSTOM_GROUP.getName(), className));
        Optional<Long> uid = AlluxioFuseUtils.getUid(owner);
        Optional<Long> gid = AlluxioFuseUtils.getGidFromGroupName(group);
        if (!uid.isPresent()) {
            throw new InternalRuntimeException(String.format("Cannot create %s with invalid owner %s: failed to get uid", className, owner));
        }
        if (!gid.isPresent()) {
            throw new InternalRuntimeException(String.format("Cannot create %s with invalid group %s: failed to get gid", className, group));
        }
        SetAttributePOptions setAttributeOptions = SetAttributePOptions.newBuilder().setOwner(owner).setGroup(group).build();
        LOG.info("Creating {} with owner [id {}, name {}] and group [id {}, name {}]", new Object[]{className, owner, uid, group, gid});
        return new CustomAuthPolicy(fileSystem, fuseFileSystem, uid.get(), gid.get(), setAttributeOptions);
    }

    private CustomAuthPolicy(FileSystem fileSystem, Optional<FuseFileSystem> fuseFileSystem, long uid, long gid, SetAttributePOptions options) {
        super(fileSystem, fuseFileSystem);
        this.mUid = uid;
        this.mGid = gid;
        this.mSetAttributeOptions = options;
    }

    @Override
    public void setUserGroupIfNeeded(AlluxioURI uri) {
        try {
            this.mFileSystem.setAttribute(uri, this.mSetAttributeOptions);
        }
        catch (AlluxioException | IOException e) {
            throw AlluxioRuntimeException.from((Throwable)e);
        }
    }

    @Override
    public void setUserGroup(AlluxioURI uri, long uid, long gid) {
        if (uid == this.mUid && gid == this.mGid) {
            this.setUserGroupIfNeeded(uri);
            return;
        }
        super.setUserGroup(uri, uid, gid);
    }

    @Override
    public Optional<Long> getUid() {
        return Optional.of(this.mUid);
    }

    @Override
    public Optional<Long> getGid() {
        return Optional.of(this.mGid);
    }
}

