/*
 * Decompiled with CFR 0.152.
 */
package alluxio.fuse.auth;

import alluxio.AlluxioURI;
import alluxio.client.file.FileSystem;
import alluxio.conf.AlluxioConfiguration;
import alluxio.fuse.AlluxioFuseUtils;
import alluxio.fuse.auth.LaunchUserGroupAuthPolicy;
import alluxio.jnifuse.FuseFileSystem;
import alluxio.jnifuse.struct.FuseContext;
import com.google.common.base.Preconditions;
import java.util.Optional;

public final class SystemUserGroupAuthPolicy
extends LaunchUserGroupAuthPolicy {
    public static SystemUserGroupAuthPolicy create(FileSystem fileSystem, AlluxioConfiguration conf, Optional<FuseFileSystem> fuseFileSystem) {
        return new SystemUserGroupAuthPolicy(fileSystem, fuseFileSystem);
    }

    private SystemUserGroupAuthPolicy(FileSystem fileSystem, Optional<FuseFileSystem> fuseFileSystem) {
        super(fileSystem, fuseFileSystem);
        Preconditions.checkArgument((boolean)this.mFuseFileSystem.isPresent());
    }

    @Override
    public void setUserGroupIfNeeded(AlluxioURI uri) {
        FuseContext fc = ((FuseFileSystem)this.mFuseFileSystem.get()).getContext();
        this.setUserGroup(uri, fc.uid.get(), fc.gid.get());
    }

    @Override
    public Optional<Long> getUid() {
        return Optional.of(((FuseFileSystem)this.mFuseFileSystem.get()).getContext().uid.get());
    }

    @Override
    public Optional<Long> getUid(String owner) {
        return AlluxioFuseUtils.getUid(owner);
    }

    @Override
    public Optional<Long> getGid() {
        return Optional.of(((FuseFileSystem)this.mFuseFileSystem.get()).getContext().gid.get());
    }

    @Override
    public Optional<Long> getGid(String group) {
        return AlluxioFuseUtils.getGidFromGroupName(group);
    }
}

