/*
 * Decompiled with CFR 0.152.
 */
package alluxio.fuse.file;

import alluxio.fuse.auth.AuthPolicy;
import alluxio.fuse.file.FileStatus;
import com.google.common.base.Preconditions;

public class CreateFileStatus
extends FileStatus {
    private final long mMode;
    private final long mUid;
    private final long mGid;

    public static CreateFileStatus create(AuthPolicy authPolicy, long mode, long fileLength) {
        Preconditions.checkNotNull((Object)authPolicy);
        long uid = authPolicy.getUid().orElse(-1L);
        long gid = authPolicy.getGid().orElse(-1L);
        return new CreateFileStatus(fileLength, mode, uid, gid);
    }

    public CreateFileStatus(long fileLength, long mode, long uid, long gid) {
        super(fileLength);
        this.mMode = mode;
        this.mUid = uid;
        this.mGid = gid;
    }

    public long getMode() {
        return this.mMode;
    }

    public long getUid() {
        return this.mUid;
    }

    public long getGid() {
        return this.mGid;
    }
}

