/*
 * Decompiled with CFR 0.152.
 */
package alluxio.fuse.file;

import alluxio.fuse.file.FuseFileStream;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class FuseFileEntry<T extends FuseFileStream>
implements Closeable {
    private final long mId;
    private final String mPath;
    private final T mFileStream;

    public FuseFileEntry(long id, String path, T fileStream) {
        Preconditions.checkArgument((id >= 0L ? 1 : 0) != 0, (Object)"id should not be negative");
        Preconditions.checkArgument((path != null && !path.isEmpty() ? 1 : 0) != 0, (Object)"path should not be null or empty");
        this.mFileStream = (FuseFileStream)Preconditions.checkNotNull(fileStream, (Object)"file stream cannot be null");
        this.mId = id;
        this.mPath = path;
    }

    public long getId() {
        return this.mId;
    }

    public String getPath() {
        return this.mPath;
    }

    public T getFileStream() {
        return this.mFileStream;
    }

    @Override
    public void close() throws IOException {
        this.mFileStream.close();
    }
}

