/*
 * Decompiled with CFR 0.152.
 */
package alluxio.fuse.file;

import alluxio.AlluxioURI;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.exception.runtime.UnimplementedRuntimeException;
import alluxio.fuse.AlluxioFuseOpenUtils;
import alluxio.fuse.AlluxioFuseUtils;
import alluxio.fuse.auth.AuthPolicy;
import alluxio.fuse.file.FileStatus;
import alluxio.fuse.file.FuseFileInStream;
import alluxio.fuse.file.FuseFileOutStream;
import alluxio.fuse.file.FuseFileStream;
import alluxio.fuse.lock.FuseReadWriteLockManager;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Optional;
import javax.annotation.concurrent.ThreadSafe;
import jnr.constants.platform.OpenFlags;

@ThreadSafe
public class FuseFileInOrOutStream
implements FuseFileStream {
    private final AuthPolicy mAuthPolicy;
    private final FileSystem mFileSystem;
    private final FuseReadWriteLockManager mLockManager;
    private final long mMode;
    private final AlluxioURI mUri;
    private Optional<FuseFileInStream> mInStream = Optional.empty();
    private Optional<FuseFileOutStream> mOutStream;

    public static FuseFileInOrOutStream create(FileSystem fileSystem, AuthPolicy authPolicy, FuseReadWriteLockManager lockManager, AlluxioURI uri, int flags, long mode) {
        Preconditions.checkNotNull((Object)fileSystem);
        Preconditions.checkNotNull((Object)lockManager);
        Preconditions.checkNotNull((Object)uri);
        Optional<FuseFileOutStream> outStream = Optional.empty();
        if (AlluxioFuseOpenUtils.containsTruncate(flags) || AlluxioFuseOpenUtils.containsCreate(flags)) {
            outStream = Optional.of(FuseFileOutStream.create(fileSystem, authPolicy, lockManager, uri, flags, mode));
        }
        return new FuseFileInOrOutStream(fileSystem, authPolicy, lockManager, outStream, uri, mode);
    }

    private FuseFileInOrOutStream(FileSystem fileSystem, AuthPolicy authPolicy, FuseReadWriteLockManager lockManager, Optional<FuseFileOutStream> outStream, AlluxioURI uri, long mode) {
        this.mAuthPolicy = (AuthPolicy)Preconditions.checkNotNull((Object)authPolicy);
        this.mFileSystem = (FileSystem)Preconditions.checkNotNull((Object)fileSystem);
        this.mOutStream = (Optional)Preconditions.checkNotNull(outStream);
        this.mLockManager = (FuseReadWriteLockManager)Preconditions.checkNotNull((Object)lockManager);
        this.mUri = (AlluxioURI)Preconditions.checkNotNull((Object)uri);
        this.mMode = mode;
    }

    @Override
    public synchronized int read(ByteBuffer buf, long size, long offset) {
        if (this.mOutStream.isPresent()) {
            throw new UnimplementedRuntimeException("Alluxio does not support reading while writing/truncating");
        }
        if (!this.mInStream.isPresent()) {
            this.mInStream = Optional.of(FuseFileInStream.create(this.mFileSystem, this.mLockManager, this.mUri));
        }
        return this.mInStream.get().read(buf, size, offset);
    }

    @Override
    public synchronized void write(ByteBuffer buf, long size, long offset) {
        if (this.mInStream.isPresent()) {
            throw new UnimplementedRuntimeException("Alluxio does not support reading while writing/truncating");
        }
        if (!this.mOutStream.isPresent()) {
            this.mOutStream = Optional.of(FuseFileOutStream.create(this.mFileSystem, this.mAuthPolicy, this.mLockManager, this.mUri, OpenFlags.O_WRONLY.intValue(), this.mMode));
        }
        this.mOutStream.get().write(buf, size, offset);
    }

    @Override
    public synchronized FileStatus getFileStatus() {
        if (this.mOutStream.isPresent()) {
            return this.mOutStream.get().getFileStatus();
        }
        if (this.mInStream.isPresent()) {
            return this.mInStream.get().getFileStatus();
        }
        return new FileStatus(AlluxioFuseUtils.getPathStatus(this.mFileSystem, this.mUri).map(URIStatus::getLength).orElse(0L));
    }

    @Override
    public synchronized void flush() {
        if (this.mInStream.isPresent()) {
            this.mInStream.get().flush();
            return;
        }
        this.mOutStream.ifPresent(FuseFileOutStream::flush);
    }

    @Override
    public synchronized void truncate(long size) {
        if (this.mInStream.isPresent()) {
            throw new UnimplementedRuntimeException("Alluxio does not support reading while writing/truncating");
        }
        if (!this.mOutStream.isPresent()) {
            this.mOutStream = Optional.of(FuseFileOutStream.create(this.mFileSystem, this.mAuthPolicy, this.mLockManager, this.mUri, OpenFlags.O_WRONLY.intValue(), this.mMode));
        }
        this.mOutStream.get().truncate(size);
    }

    @Override
    public synchronized void close() {
        if (this.mInStream.isPresent()) {
            this.mInStream.get().close();
            return;
        }
        this.mOutStream.ifPresent(FuseFileOutStream::close);
    }
}

