/*
 * Decompiled with CFR 0.152.
 */
package alluxio.fuse.file;

import alluxio.AlluxioURI;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.concurrent.LockMode;
import alluxio.exception.PreconditionMessage;
import alluxio.exception.runtime.AlluxioRuntimeException;
import alluxio.exception.runtime.AlreadyExistsRuntimeException;
import alluxio.exception.runtime.FailedPreconditionRuntimeException;
import alluxio.exception.runtime.UnimplementedRuntimeException;
import alluxio.fuse.AlluxioFuseOpenUtils;
import alluxio.fuse.AlluxioFuseUtils;
import alluxio.fuse.auth.AuthPolicy;
import alluxio.fuse.file.CreateFileStatus;
import alluxio.fuse.file.FileStatus;
import alluxio.fuse.file.FuseFileStream;
import alluxio.fuse.lock.FuseReadWriteLockManager;
import alluxio.resource.CloseableResource;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class FuseFileOutStream
implements FuseFileStream {
    private static final Logger LOG = LoggerFactory.getLogger(FuseFileOutStream.class);
    private static final int DEFAULT_BUFFER_SIZE = 0x400000;
    private final AuthPolicy mAuthPolicy;
    private final FileSystem mFileSystem;
    private final CloseableResource<Lock> mLockResource;
    private final AlluxioURI mURI;
    private final CreateFileStatus mFileStatus;
    private volatile boolean mClosed = false;
    private Optional<FileOutStream> mOutStream;

    public static FuseFileOutStream create(FileSystem fileSystem, AuthPolicy authPolicy, FuseReadWriteLockManager lockManager, AlluxioURI uri, int flags, long mode) {
        Preconditions.checkNotNull((Object)fileSystem);
        Preconditions.checkNotNull((Object)authPolicy);
        Preconditions.checkNotNull((Object)lockManager);
        Preconditions.checkNotNull((Object)uri);
        CloseableResource<Lock> lockResource = lockManager.tryLock(uri.toString(), LockMode.WRITE);
        try {
            Optional<URIStatus> status = AlluxioFuseUtils.getPathStatus(fileSystem, uri);
            if (status.isPresent() && !status.get().isCompleted() && !(status = AlluxioFuseUtils.waitForFileCompleted(fileSystem, uri)).isPresent()) {
                throw new UnimplementedRuntimeException(String.format("Failed to create fuse file out stream for %s: cannot concurrently write same file", uri));
            }
            if (mode == -1L && status.isPresent()) {
                mode = status.get().getMode();
            }
            long fileLen = status.map(URIStatus::getLength).orElse(0L);
            CreateFileStatus createFileStatus = CreateFileStatus.create(authPolicy, mode, fileLen);
            if (status.isPresent()) {
                if (AlluxioFuseOpenUtils.containsTruncate(flags) || fileLen == 0L) {
                    AlluxioFuseUtils.deletePath(fileSystem, uri);
                    createFileStatus.setFileLength(0L);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(String.format("Open path %s with flag 0x%x for overwriting. Alluxio deleted the old file and created a new file for writing", uri, flags));
                    }
                } else {
                    return new FuseFileOutStream(fileSystem, authPolicy, uri, createFileStatus, lockResource, Optional.empty());
                }
            }
            return new FuseFileOutStream(fileSystem, authPolicy, uri, createFileStatus, lockResource, Optional.of(AlluxioFuseUtils.createFile(fileSystem, authPolicy, uri, createFileStatus)));
        }
        catch (Throwable t) {
            lockResource.close();
            throw t;
        }
    }

    private FuseFileOutStream(FileSystem fileSystem, AuthPolicy authPolicy, AlluxioURI uri, CreateFileStatus fileStatus, CloseableResource<Lock> lockResource, Optional<FileOutStream> outStream) {
        this.mFileSystem = (FileSystem)Preconditions.checkNotNull((Object)fileSystem);
        this.mAuthPolicy = (AuthPolicy)Preconditions.checkNotNull((Object)authPolicy);
        this.mFileStatus = (CreateFileStatus)Preconditions.checkNotNull((Object)fileStatus);
        this.mURI = (AlluxioURI)Preconditions.checkNotNull((Object)uri);
        this.mLockResource = (CloseableResource)Preconditions.checkNotNull(lockResource);
        this.mOutStream = (Optional)Preconditions.checkNotNull(outStream);
    }

    @Override
    public int read(ByteBuffer buf, long size, long offset) {
        throw new FailedPreconditionRuntimeException("Cannot read from write only stream");
    }

    @Override
    public synchronized void write(ByteBuffer buf, long size, long offset) {
        Preconditions.checkArgument((size >= 0L && offset >= 0L && size <= (long)buf.capacity() ? 1 : 0) != 0, (String)PreconditionMessage.ERR_BUFFER_STATE.toString(), (Object)buf.capacity(), (Object)offset, (Object)size);
        if (!this.mOutStream.isPresent()) {
            throw new AlreadyExistsRuntimeException("Cannot overwrite/extending existing file without O_TRUNC flag or truncate(0) operation");
        }
        if (size == 0L) {
            return;
        }
        int sz = (int)size;
        long bytesWritten = this.mOutStream.get().getBytesWritten();
        if (offset != bytesWritten && offset + (long)sz > bytesWritten) {
            throw new UnimplementedRuntimeException(String.format("Only sequential write is supported. Cannot write bytes of size %s to offset %s when %s bytes have written to path %s", size, offset, bytesWritten, this.mURI));
        }
        if (offset + (long)sz <= bytesWritten) {
            LOG.warn("Skip writing to file {} offset={} size={} when {} bytes has written to file", new Object[]{this.mURI, offset, sz, bytesWritten});
        }
        byte[] dest = new byte[sz];
        buf.get(dest, 0, sz);
        try {
            this.mOutStream.get().write(dest);
        }
        catch (IOException e) {
            throw AlluxioRuntimeException.from((IOException)e);
        }
    }

    @Override
    public synchronized FileStatus getFileStatus() {
        if (this.mOutStream.isPresent() && this.mOutStream.get().getBytesWritten() > this.mFileStatus.getFileLength()) {
            this.mFileStatus.setFileLength(this.mOutStream.get().getBytesWritten());
        }
        return this.mFileStatus;
    }

    @Override
    public synchronized void flush() {
        if (!this.mOutStream.isPresent()) {
            return;
        }
        try {
            this.mOutStream.get().flush();
        }
        catch (IOException e) {
            throw AlluxioRuntimeException.from((IOException)e);
        }
    }

    @Override
    public synchronized void truncate(long size) {
        long currentSize = this.getFileStatus().getFileLength();
        if (size == currentSize) {
            return;
        }
        if (size == 0L) {
            this.closeStreams();
            AlluxioFuseUtils.deletePath(this.mFileSystem, this.mURI);
            this.mOutStream = Optional.of(AlluxioFuseUtils.createFile(this.mFileSystem, this.mAuthPolicy, this.mURI, this.mFileStatus));
            this.mFileStatus.setFileLength(0L);
            return;
        }
        if (this.mOutStream.isPresent() && size >= this.mOutStream.get().getBytesWritten()) {
            this.mFileStatus.setFileLength(size);
            return;
        }
        throw new UnimplementedRuntimeException(String.format("Cannot truncate file %s from size %s to size %s", this.mURI, currentSize, size));
    }

    @Override
    public synchronized void close() {
        if (this.mClosed) {
            return;
        }
        this.mClosed = true;
        try {
            this.closeStreams();
        }
        finally {
            this.mLockResource.close();
        }
    }

    private void closeStreams() {
        try {
            this.writeToFileLengthIfNeeded();
            if (this.mOutStream.isPresent()) {
                this.mOutStream.get().close();
            }
        }
        catch (IOException e) {
            throw AlluxioRuntimeException.from((IOException)e);
        }
    }

    private void writeToFileLengthIfNeeded() throws IOException {
        long bytesGap;
        if (!this.mOutStream.isPresent()) {
            return;
        }
        long bytesWritten = this.mOutStream.get().getBytesWritten();
        if (bytesWritten >= this.mFileStatus.getFileLength()) {
            return;
        }
        long originalBytesGap = bytesGap = this.mFileStatus.getFileLength() - bytesWritten;
        int bufferSize = bytesGap >= 0x400000L ? 0x400000 : (int)bytesGap;
        byte[] buffer = new byte[bufferSize];
        Arrays.fill(buffer, (byte)0);
        while (bytesGap > 0L) {
            int bytesToWrite = bytesGap >= 0x400000L ? 0x400000 : (int)bytesGap;
            this.mOutStream.get().write(buffer, 0, bytesToWrite);
            bytesGap -= 0x400000L;
        }
        LOG.debug("Filled {} zero bytes to file {} to fulfill the extended file length of {}", new Object[]{originalBytesGap, this.mURI, this.mFileStatus.getFileLength()});
    }
}

