/*
 * Decompiled with CFR 0.152.
 */
package alluxio.fuse.options;

import alluxio.client.file.options.FileSystemOptions;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.runtime.InvalidArgumentRuntimeException;
import alluxio.fuse.AlluxioFuseUtils;
import alluxio.jnifuse.utils.LibfuseVersion;
import com.google.common.base.Preconditions;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FuseOptions {
    private static final Logger LOG = LoggerFactory.getLogger(FuseOptions.class);
    private final FileSystemOptions mFileSystemOptions;
    private final Set<String> mFuseMountOptions;
    private final boolean mUpdateCheckEnabled;

    public static FuseOptions create(AlluxioConfiguration conf) {
        return FuseOptions.create(conf, FileSystemOptions.create((AlluxioConfiguration)conf), false);
    }

    public static FuseOptions create(AlluxioConfiguration conf, boolean updateCheckEnabled) {
        return FuseOptions.create(conf, FileSystemOptions.create((AlluxioConfiguration)conf), updateCheckEnabled);
    }

    public static FuseOptions create(AlluxioConfiguration conf, FileSystemOptions fileSystemOptions, boolean updateCheckEnabled) {
        Set<String> mountOptions = conf.getList(PropertyKey.FUSE_MOUNT_OPTIONS).stream().filter(a -> !a.isEmpty()).collect(Collectors.toSet());
        LibfuseVersion version = AlluxioFuseUtils.getLibfuseVersion(conf);
        if (!conf.getBoolean(PropertyKey.FUSE_JNIFUSE_ENABLED) && version == LibfuseVersion.VERSION_3) {
            throw new InvalidArgumentRuntimeException("Cannot use JNR-FUSE with libfuse 3");
        }
        if (version == LibfuseVersion.VERSION_2) {
            String directIOOptions;
            String bigWritesOptions = "big_writes";
            if (mountOptions.add(bigWritesOptions)) {
                LOG.info("Added fuse mount option {} to enlarge single write request size", (Object)bigWritesOptions);
            }
            if (!conf.getBoolean(PropertyKey.FUSE_JNIFUSE_ENABLED) && mountOptions.add(directIOOptions = "direct_io")) {
                LOG.info("Added fuse mount option {} for JNR FUSE", (Object)directIOOptions);
            }
        } else {
            if (mountOptions.remove("direct_io")) {
                LOG.error("FUSE 3 does not support direct_io mount option");
            }
            if (mountOptions.stream().noneMatch(a -> a.startsWith("max_idle_threads"))) {
                String idleThreadsOption = "max_idle_threads=64";
                mountOptions.add(idleThreadsOption);
                LOG.info("Added fuse mount option {} for FUSE 3", (Object)idleThreadsOption);
            }
        }
        return new FuseOptions(fileSystemOptions, mountOptions, updateCheckEnabled);
    }

    private FuseOptions(FileSystemOptions fileSystemOptions, Set<String> fuseMountOptions, boolean updateCheckEnabled) {
        this.mFileSystemOptions = (FileSystemOptions)Preconditions.checkNotNull((Object)fileSystemOptions);
        this.mFuseMountOptions = (Set)Preconditions.checkNotNull(fuseMountOptions);
        this.mUpdateCheckEnabled = updateCheckEnabled;
    }

    public FileSystemOptions getFileSystemOptions() {
        return this.mFileSystemOptions;
    }

    public Set<String> getFuseMountOptions() {
        return this.mFuseMountOptions;
    }

    public boolean updateCheckEnabled() {
        return this.mUpdateCheckEnabled;
    }
}

