/*
 * Decompiled with CFR 0.152.
 */
package alluxio.jnifuse.struct;

import alluxio.jnifuse.struct.Fuse2FuseFileInfo;
import alluxio.jnifuse.struct.Fuse3FuseFileInfo;
import alluxio.jnifuse.utils.NativeLibraryLoader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.Struct;

public class FuseFileInfo
extends Struct {
    public ByteBuffer buffer;
    public Struct.u_int64_t fh;
    public Struct.Signed32 flags;

    public FuseFileInfo(Runtime runtime, ByteBuffer buffer) {
        super(runtime);
        this.buffer = buffer;
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public static FuseFileInfo of(ByteBuffer buffer) {
        Runtime runtime = Runtime.getSystemRuntime();
        NativeLibraryLoader.LoadState state = NativeLibraryLoader.getLoadState();
        if (state == NativeLibraryLoader.LoadState.NOT_LOADED) {
            throw new RuntimeException("NativeLibraryLoader is not loaded");
        }
        FuseFileInfo fi = state == NativeLibraryLoader.LoadState.LOADED_2 ? new Fuse2FuseFileInfo(runtime, buffer) : new Fuse3FuseFileInfo(runtime, buffer);
        fi.useMemory(Pointer.wrap((Runtime)runtime, (ByteBuffer)buffer));
        return fi;
    }
}

