/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.cmd.migrate;

import alluxio.client.WriteType;
import alluxio.grpc.OperationType;
import alluxio.job.cmd.CliConfig;
import alluxio.job.wire.JobSource;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class MigrateCliConfig
implements CliConfig {
    public static final String NAME = "MigrateCli";
    private static final long serialVersionUID = 6279399518859380714L;
    private final String mSource;
    private final String mDestination;
    private final WriteType mWriteType;
    private final boolean mOverwrite;
    private final int mBatchSize;

    public MigrateCliConfig(@JsonProperty(value="source") String source, @JsonProperty(value="destination") String dst, @JsonProperty(value="writeType") WriteType writeType, @JsonProperty(value="overwrite") boolean overwrite, @JsonProperty(value="batchSize") int batchSize) {
        this.mSource = (String)Preconditions.checkNotNull((Object)source, (Object)"source must be set");
        this.mDestination = (String)Preconditions.checkNotNull((Object)dst, (Object)"destination must be set");
        this.mWriteType = writeType;
        this.mOverwrite = overwrite;
        this.mBatchSize = batchSize;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public JobSource getJobSource() {
        return JobSource.CLI;
    }

    @Override
    public OperationType getOperationType() {
        return OperationType.DIST_CP;
    }

    @Override
    public Collection<String> affectedPaths() {
        return ImmutableList.of((Object)this.mSource, (Object)this.mDestination);
    }

    public String getSource() {
        return this.mSource;
    }

    public String getDestination() {
        return this.mDestination;
    }

    public WriteType getWriteType() {
        return this.mWriteType;
    }

    public boolean getOverWrite() {
        return this.mOverwrite;
    }

    public int getBatchSize() {
        return this.mBatchSize;
    }

    public boolean isOverwrite() {
        return this.mOverwrite;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MigrateCliConfig)) {
            return false;
        }
        MigrateCliConfig that = (MigrateCliConfig)obj;
        return Objects.equal((Object)this.mSource, (Object)that.mSource) && Objects.equal((Object)this.mDestination, (Object)that.mDestination) && Objects.equal((Object)this.mWriteType, (Object)that.mWriteType) && Objects.equal((Object)this.mOverwrite, (Object)that.mOverwrite);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mSource, this.mDestination, this.mWriteType, this.mOverwrite});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("source", (Object)this.mSource).add("destination", (Object)this.mDestination).add("writeType", (Object)this.mWriteType).add("overwrite", this.mOverwrite).toString();
    }
}

