/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.cmd.persist;

import alluxio.grpc.OperationType;
import alluxio.job.cmd.CliConfig;
import alluxio.job.plan.persist.PersistConfig;
import alluxio.job.wire.JobSource;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class PersistCmdConfig
implements CliConfig {
    public static final String NAME = "PersistCmdConfig";
    private static final long serialVersionUID = -7500991818979235916L;
    private String mFilePath;
    private long mMountId;
    private final boolean mOverwrite;
    private String mUfsPath;

    @JsonCreator
    public PersistCmdConfig(@JsonProperty(value="filePath") String filePath, @JsonProperty(value="mountId") long mountId, @JsonProperty(value="overwrite") boolean overwrite, @JsonProperty(value="ufsPath") String ufsPath) {
        this.mFilePath = (String)Preconditions.checkNotNull((Object)filePath, (Object)"The file path cannot be null");
        this.mMountId = (Long)Preconditions.checkNotNull((Object)mountId, (Object)"The mount ID cannot be null");
        this.mOverwrite = overwrite;
        this.mUfsPath = (String)Preconditions.checkNotNull((Object)ufsPath, (Object)"The UFS path cannot be null");
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public JobSource getJobSource() {
        return JobSource.SYSTEM;
    }

    @Override
    public OperationType getOperationType() {
        return OperationType.PERSIST;
    }

    public String getFilePath() {
        return this.mFilePath;
    }

    public long getMountId() {
        return this.mMountId;
    }

    public String getUfsPath() {
        return this.mUfsPath;
    }

    public boolean isOverwrite() {
        return this.mOverwrite;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PersistCmdConfig)) {
            return false;
        }
        PersistCmdConfig that = (PersistCmdConfig)obj;
        return Objects.equal((Object)this.mFilePath, (Object)that.mFilePath) && Objects.equal((Object)this.mMountId, (Object)that.mMountId) && Objects.equal((Object)this.mOverwrite, (Object)that.mOverwrite) && Objects.equal((Object)this.mUfsPath, (Object)that.mUfsPath);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mFilePath, this.mMountId, this.mOverwrite, this.mUfsPath});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("filePath", (Object)this.mFilePath).add("mountId", this.mMountId).add("overwrite", this.mOverwrite).add("ufsPath", (Object)this.mUfsPath).toString();
    }

    @Override
    public Collection<String> affectedPaths() {
        return ImmutableList.of((Object)this.mFilePath);
    }

    public PersistConfig toPersistConfig() {
        return new PersistConfig(this.mFilePath, this.mMountId, this.mOverwrite, this.mUfsPath);
    }
}

