/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.graph;

import alluxio.stress.graph.Graph;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BarGraph
extends Graph {
    private static final String VALUE_FIELD = "y";
    private static final String SERIES_FIELD = "series";

    public BarGraph(String title, List<String> subTitle, String xTitle) {
        this.mTitle.add(title);
        this.mSubTitle.addAll(subTitle);
        this.mGraph.put("$schema", "https://vega.github.io/schema/vega-lite/v4.json");
        this.mGraph.put("width", 700);
        this.mGraph.put("height", 400);
        this.mGraph.put("title", ImmutableMap.of((Object)"text", (Object)this.mTitle, (Object)"subtitle", (Object)this.mSubTitle));
        this.mGraph.put("mark", "bar");
        HashMap<String, Object> encoding = new HashMap<String, Object>();
        encoding.put("x", ImmutableMap.of((Object)"field", (Object)VALUE_FIELD, (Object)"type", (Object)"quantitative", (Object)"title", (Object)xTitle));
        encoding.put(VALUE_FIELD, ImmutableMap.of((Object)"field", (Object)SERIES_FIELD, (Object)"type", (Object)"nominal", (Object)"title", (Object)""));
        encoding.put("tooltip", Arrays.asList(ImmutableMap.of((Object)"field", (Object)SERIES_FIELD, (Object)"type", (Object)"nominal", (Object)"title", (Object)"Series"), ImmutableMap.of((Object)"field", (Object)VALUE_FIELD, (Object)"type", (Object)"quantitative", (Object)"title", (Object)xTitle)));
        this.mGraph.put("encoding", encoding);
    }

    public void addDataSeries(String series, Data data) {
        List newSeries = data.mData.stream().map(m -> {
            HashMap<String, String> newMap = new HashMap<String, String>((Map<String, String>)m);
            newMap.put(SERIES_FIELD, series);
            return newMap;
        }).collect(Collectors.toList());
        this.mData.addAll(newSeries);
    }

    public static class Data {
        private final List<Map<Object, Object>> mData = new ArrayList<Map<Object, Object>>();

        public void addData(Object value) {
            this.mData.add((Map<Object, Object>)ImmutableMap.of((Object)BarGraph.VALUE_FIELD, (Object)value));
        }
    }
}

