/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.worker;

import alluxio.collections.Pair;
import alluxio.stress.BaseParameters;
import alluxio.stress.Parameters;
import alluxio.stress.Summary;
import alluxio.stress.graph.BarGraph;
import alluxio.stress.graph.Graph;
import alluxio.stress.worker.IOTaskResult;
import alluxio.stress.worker.UfsIOParameters;
import alluxio.util.FormatUtils;
import alluxio.util.JsonSerializable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOTaskSummary
implements Summary {
    private static final Logger LOG = LoggerFactory.getLogger(IOTaskSummary.class);
    private List<IOTaskResult.Point> mPoints;
    private List<String> mErrors;
    private BaseParameters mBaseParameters;
    private UfsIOParameters mParameters;
    private SpeedStat mReadSpeedStat;
    private SpeedStat mWriteSpeedStat;

    @JsonCreator
    public IOTaskSummary() {
    }

    public IOTaskSummary(IOTaskResult result) {
        this.mPoints = new ArrayList<IOTaskResult.Point>(result.getPoints());
        this.mErrors = new ArrayList<String>(result.getErrors());
        this.mBaseParameters = result.getBaseParameters();
        this.mParameters = result.getParameters();
        this.calculateStats();
    }

    public List<IOTaskResult.Point> getPoints() {
        return this.mPoints;
    }

    public void setPoints(List<IOTaskResult.Point> points) {
        this.mPoints = points;
    }

    public List<String> getErrors() {
        return this.mErrors;
    }

    public void setErrors(List<String> errors) {
        this.mErrors = errors;
    }

    public BaseParameters getBaseParameters() {
        return this.mBaseParameters;
    }

    public void setBaseParameters(BaseParameters baseParameters) {
        this.mBaseParameters = baseParameters;
    }

    public UfsIOParameters getParameters() {
        return this.mParameters;
    }

    public void setParameters(UfsIOParameters parameters) {
        this.mParameters = parameters;
    }

    public SpeedStat getReadSpeedStat() {
        return this.mReadSpeedStat;
    }

    public void setReadSpeedStat(SpeedStat stat) {
        this.mReadSpeedStat = stat;
    }

    public SpeedStat getWriteSpeedStat() {
        return this.mWriteSpeedStat;
    }

    public void setWriteSpeedStat(SpeedStat stat) {
        this.mWriteSpeedStat = stat;
    }

    private static SpeedStat calculateStat(List<IOTaskResult.Point> points) {
        SpeedStat result = new SpeedStat();
        if (points.size() == 0) {
            return result;
        }
        long totalSize = 0L;
        double[] speeds = new double[points.size()];
        double maxSpeed = 0.0;
        double minSpeed = Double.MAX_VALUE;
        int i = 0;
        for (IOTaskResult.Point p : points) {
            result.mTotalDurationSeconds = Math.max(p.mDurationSeconds, result.mTotalDurationSeconds);
            totalSize += p.mDataSizeBytes;
            double speed = (double)p.mDataSizeBytes / (p.mDurationSeconds * 1024.0 * 1024.0);
            maxSpeed = Math.max(maxSpeed, speed);
            minSpeed = Math.min(minSpeed, speed);
            speeds[i++] = speed;
        }
        double avgPointSpeed = Arrays.stream(speeds).sum() / (double)points.size();
        double avgClusterSpeed = (double)totalSize / (result.mTotalDurationSeconds * 1024.0 * 1024.0);
        double var = 0.0;
        for (double s : speeds) {
            var += (s - avgPointSpeed) * (s - avgPointSpeed);
        }
        result.mTotalSizeBytes = totalSize;
        result.mMaxSpeedMbps = maxSpeed;
        result.mMinSpeedMbps = Double.compare(minSpeed, Double.MAX_VALUE) == 0 ? 0.0 : minSpeed;
        result.mAvgSpeedMbps = avgPointSpeed;
        result.mClusterAvgSpeedMbps = avgClusterSpeed;
        result.mStdDev = Math.sqrt(var);
        return result;
    }

    private void calculateStats() {
        List<IOTaskResult.Point> readPoints = this.mPoints.stream().filter(p -> p.mMode == IOTaskResult.IOMode.READ && p.mDurationSeconds > 0.0).collect(Collectors.toList());
        this.mReadSpeedStat = IOTaskSummary.calculateStat(readPoints);
        List<IOTaskResult.Point> writePoints = this.mPoints.stream().filter(p -> p.mMode == IOTaskResult.IOMode.WRITE && p.mDurationSeconds > 0.0).collect(Collectors.toList());
        this.mWriteSpeedStat = IOTaskSummary.calculateStat(writePoints);
    }

    @Override
    public GraphGenerator graphGenerator() {
        return new GraphGenerator();
    }

    public String toString() {
        return String.format("IOTaskSummary: {Points=%s, Errors=%s}%n", this.mPoints, this.mErrors);
    }

    public static final class GraphGenerator
    extends alluxio.stress.GraphGenerator {
        @Override
        public List<Graph> generate(List<? extends Summary> results) {
            ArrayList<Graph> graphs = new ArrayList<Graph>();
            List summaries = results.stream().map(x -> (IOTaskSummary)x).collect(Collectors.toList());
            if (summaries.isEmpty()) {
                LOG.info("No summaries to generate.");
                return graphs;
            }
            Pair<List<String>, List<String>> fieldNames = Parameters.partitionFieldNames(summaries.stream().map(x -> ((IOTaskSummary)x).mParameters).collect(Collectors.toList()));
            ArrayList<String> subTitle = new ArrayList<String>(Splitter.fixedLength((int)100).splitToList((CharSequence)((IOTaskSummary)summaries.get(0)).mParameters.getDescription((List)fieldNames.getFirst())));
            for (IOTaskSummary summary : summaries) {
                String series = summary.mParameters.getDescription((List)fieldNames.getSecond());
                subTitle.add(series);
            }
            BarGraph speedGraph = new BarGraph("Read/Write speed", subTitle, "Avg speed in MB/s");
            BarGraph stdDevGraph = new BarGraph("Read/Write speed standard deviation", subTitle, "Standard deviation in speed");
            for (IOTaskSummary summary : summaries) {
                String series = summary.mParameters.getDescription((List)fieldNames.getSecond());
                BarGraph.Data readSpeed = new BarGraph.Data();
                BarGraph.Data readStdDev = new BarGraph.Data();
                SpeedStat readStat = summary.getReadSpeedStat();
                readSpeed.addData(readStat.mAvgSpeedMbps);
                readStdDev.addData(readStat.mStdDev);
                speedGraph.addDataSeries("Read " + series, readSpeed);
                stdDevGraph.addDataSeries("Read " + series, readStdDev);
                BarGraph.Data writeSpeed = new BarGraph.Data();
                BarGraph.Data writeStdDev = new BarGraph.Data();
                SpeedStat writeStat = summary.getWriteSpeedStat();
                writeSpeed.addData(writeStat.mAvgSpeedMbps);
                writeStdDev.addData(writeStat.mStdDev);
                speedGraph.addDataSeries("Write " + series, writeSpeed);
                stdDevGraph.addDataSeries("Write " + series, writeStdDev);
            }
            graphs.add(speedGraph);
            graphs.add(stdDevGraph);
            return graphs;
        }
    }

    public static class SpeedStat
    implements JsonSerializable {
        public double mTotalDurationSeconds;
        public long mTotalSizeBytes;
        public double mMaxSpeedMbps;
        public double mMinSpeedMbps;
        public double mAvgSpeedMbps;
        public double mClusterAvgSpeedMbps;
        public double mStdDev;

        public String toString() {
            return String.format("{totalDuration=%ss, totalSize=%s, maxSpeed=%sMB/s, minSpeed=%sMB/s, avgSpeed=%sMB/s, clusterAvgSpeed=%sMB/s, stdDev=%s}", this.mTotalDurationSeconds, FormatUtils.getSizeFromBytes((long)this.mTotalSizeBytes), this.mMaxSpeedMbps, this.mMinSpeedMbps, this.mAvgSpeedMbps, this.mClusterAvgSpeedMbps, this.mStdDev);
        }
    }
}

