/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.local;

import alluxio.AlluxioURI;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.ExceptionMessage;
import alluxio.security.authorization.Mode;
import alluxio.underfs.AtomicFileOutputStream;
import alluxio.underfs.AtomicFileOutputStreamCallback;
import alluxio.underfs.ConsistentUnderFileSystem;
import alluxio.underfs.ContentHashable;
import alluxio.underfs.UfsDirectoryStatus;
import alluxio.underfs.UfsFileStatus;
import alluxio.underfs.UfsStatus;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.options.CreateOptions;
import alluxio.underfs.options.DeleteOptions;
import alluxio.underfs.options.FileLocationOptions;
import alluxio.underfs.options.GetFileStatusOptions;
import alluxio.underfs.options.MkdirsOptions;
import alluxio.underfs.options.OpenOptions;
import alluxio.util.UnderFileSystemUtils;
import alluxio.util.io.FileUtils;
import alluxio.util.io.PathUtils;
import alluxio.util.network.NetworkAddressUtils;
import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class LocalUnderFileSystem
extends ConsistentUnderFileSystem
implements AtomicFileOutputStreamCallback {
    private static final Logger LOG = LoggerFactory.getLogger(LocalUnderFileSystem.class);
    private final boolean mSkipBrokenSymlinks;

    public LocalUnderFileSystem(AlluxioURI uri, UnderFileSystemConfiguration ufsConf) {
        super(uri, ufsConf);
        this.mSkipBrokenSymlinks = ufsConf.getBoolean(PropertyKey.UNDERFS_LOCAL_SKIP_BROKEN_SYMLINKS);
    }

    public String getUnderFSType() {
        return "local";
    }

    public void cleanup() throws IOException {
    }

    public void close() throws IOException {
    }

    public OutputStream create(String path, CreateOptions options) throws IOException {
        if (!options.isEnsureAtomic()) {
            return this.createDirect(path, options);
        }
        return new AtomicFileOutputStream(path, (AtomicFileOutputStreamCallback)this, options);
    }

    public OutputStream createDirect(String path, CreateOptions options) throws IOException {
        File parent;
        path = this.stripPath(path);
        if (options.getCreateParent() && (parent = new File(path).getParentFile()) != null && !parent.mkdirs() && !parent.isDirectory()) {
            throw new IOException(ExceptionMessage.PARENT_CREATION_FAILED.getMessage(new Object[]{path}));
        }
        LocalOutputStream stream = new LocalOutputStream((OutputStream)new FileOutputStream(path), path);
        try {
            this.setMode(path, options.getMode().toShort());
        }
        catch (IOException e) {
            ((OutputStream)stream).close();
            throw e;
        }
        return stream;
    }

    public boolean deleteDirectory(String path, DeleteOptions options) throws IOException {
        String[] files;
        File file = new File(path = this.stripPath(path));
        if (!file.isDirectory()) {
            return false;
        }
        boolean success = true;
        if (options.isRecursive() && (files = file.list()) != null) {
            for (String child : files) {
                String childPath = PathUtils.concatPath((Object)path, (Object)child);
                success = this.isDirectory(childPath) ? success && this.deleteDirectory(childPath, DeleteOptions.defaults().setRecursive(true)) : success && this.deleteFile(PathUtils.concatPath((Object)path, (Object)child));
            }
        }
        return success && file.delete();
    }

    public boolean deleteFile(String path) throws IOException {
        File file = new File(path = this.stripPath(path));
        return file.isFile() && file.delete();
    }

    public boolean exists(String path) throws IOException {
        path = this.stripPath(path);
        File file = new File(path);
        return file.exists();
    }

    public long getBlockSizeByte(String path) throws IOException {
        File file = new File(path = this.stripPath(path));
        if (!file.exists()) {
            throw new FileNotFoundException(path);
        }
        return this.mUfsConf.getBytes(PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT);
    }

    public UfsDirectoryStatus getDirectoryStatus(String path) throws IOException {
        String tpath = this.stripPath(path);
        File file = new File(tpath);
        try {
            PosixFileAttributes attr = Files.readAttributes(Paths.get(file.getPath(), new String[0]), PosixFileAttributes.class, new LinkOption[0]);
            if (!attr.isDirectory()) {
                throw new IOException(String.format("path %s is not directory", path));
            }
            return new UfsDirectoryStatus(path, attr.owner().getName(), attr.group().getName(), FileUtils.translatePosixPermissionToMode(attr.permissions()), Long.valueOf(file.lastModified()));
        }
        catch (FileSystemException e) {
            throw new FileNotFoundException(e.getMessage());
        }
    }

    public List<String> getFileLocations(String path) throws IOException {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(NetworkAddressUtils.getConnectHost((NetworkAddressUtils.ServiceAttributeProvider)NetworkAddressUtils.ServiceType.WORKER_RPC, (AlluxioConfiguration)this.mUfsConf));
        return ret;
    }

    public List<String> getFileLocations(String path, FileLocationOptions options) throws IOException {
        return this.getFileLocations(path);
    }

    public UfsFileStatus getFileStatus(String path, GetFileStatusOptions options) throws IOException {
        String tpath = this.stripPath(path);
        File file = new File(tpath);
        try {
            PosixFileAttributes attr = Files.readAttributes(Paths.get(file.getPath(), new String[0]), PosixFileAttributes.class, new LinkOption[0]);
            if (attr.isDirectory()) {
                throw new IOException(String.format("path %s is not a file", path));
            }
            String contentHash = UnderFileSystemUtils.approximateContentHash((long)file.length(), (long)file.lastModified());
            return new UfsFileStatus(path, contentHash, file.length(), Long.valueOf(file.lastModified()), attr.owner().getName(), attr.group().getName(), FileUtils.translatePosixPermissionToMode(attr.permissions()), this.mUfsConf.getBytes(PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT));
        }
        catch (FileSystemException e) {
            throw new FileNotFoundException(e.getMessage());
        }
    }

    public long getSpace(String path, UnderFileSystem.SpaceType type) throws IOException {
        path = this.stripPath(path);
        File file = new File(path);
        switch (type) {
            case SPACE_TOTAL: {
                return file.getTotalSpace();
            }
            case SPACE_FREE: {
                return file.getFreeSpace();
            }
            case SPACE_USED: {
                return file.getTotalSpace() - file.getFreeSpace();
            }
        }
        throw new IOException("Unknown space type: " + type);
    }

    public UfsStatus getStatus(String path) throws IOException {
        String tpath = this.stripPath(path);
        File file = new File(tpath);
        try {
            PosixFileAttributes attr = Files.readAttributes(Paths.get(file.getPath(), new String[0]), PosixFileAttributes.class, new LinkOption[0]);
            if (file.isFile()) {
                String contentHash = UnderFileSystemUtils.approximateContentHash((long)file.length(), (long)file.lastModified());
                return new UfsFileStatus(path, contentHash, file.length(), Long.valueOf(file.lastModified()), attr.owner().getName(), attr.group().getName(), FileUtils.translatePosixPermissionToMode(attr.permissions()), this.mUfsConf.getBytes(PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT));
            }
            return new UfsDirectoryStatus(path, attr.owner().getName(), attr.group().getName(), FileUtils.translatePosixPermissionToMode(attr.permissions()), Long.valueOf(file.lastModified()));
        }
        catch (FileSystemException e) {
            throw new FileNotFoundException(e.getMessage());
        }
    }

    public boolean isDirectory(String path) throws IOException {
        path = this.stripPath(path);
        File file = new File(path);
        return file.isDirectory();
    }

    public boolean isFile(String path) throws IOException {
        path = this.stripPath(path);
        File file = new File(path);
        return file.isFile();
    }

    public UfsStatus[] listStatus(String path) throws IOException {
        File[] files;
        path = this.stripPath(path);
        File file = new File(path);
        File[] fileArray = files = this.mSkipBrokenSymlinks ? file.listFiles(File::exists) : file.listFiles();
        if (files != null) {
            UfsStatus[] rtn = new UfsStatus[files.length];
            int i = 0;
            for (File f : files) {
                UfsDirectoryStatus retStatus;
                PosixFileAttributes attr = Files.readAttributes(Paths.get(f.getPath(), new String[0]), PosixFileAttributes.class, new LinkOption[0]);
                short mode = FileUtils.translatePosixPermissionToMode(attr.permissions());
                if (f.isDirectory()) {
                    retStatus = new UfsDirectoryStatus(f.getName(), attr.owner().getName(), attr.group().getName(), mode, Long.valueOf(f.lastModified()));
                } else {
                    String contentHash = UnderFileSystemUtils.approximateContentHash((long)f.length(), (long)f.lastModified());
                    retStatus = new UfsFileStatus(f.getName(), contentHash, f.length(), Long.valueOf(f.lastModified()), attr.owner().getName(), attr.group().getName(), mode, this.mUfsConf.getBytes(PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT));
                }
                rtn[i++] = retStatus;
            }
            return rtn;
        }
        return null;
    }

    public boolean mkdirs(String path, MkdirsOptions options) throws IOException {
        path = this.stripPath(path);
        File file = new File(path);
        if (!options.getCreateParent()) {
            if (file.mkdir()) {
                this.setMode(file.getPath(), options.getMode().toShort());
                FileUtils.setLocalDirStickyBit((String)file.getPath());
                try {
                    this.setOwner(file.getPath(), options.getOwner(), options.getGroup());
                }
                catch (IOException e) {
                    LOG.warn("Failed to update the ufs dir ownership, default values will be used: {}", (Object)e.toString());
                }
                return true;
            }
            return false;
        }
        Stack<File> dirsToMake = new Stack<File>();
        dirsToMake.push(file);
        for (File parent = file.getParentFile(); parent != null && !parent.exists(); parent = parent.getParentFile()) {
            dirsToMake.push(parent);
        }
        while (!dirsToMake.empty()) {
            File dirToMake = (File)dirsToMake.pop();
            if (dirToMake.mkdir()) {
                this.setMode(dirToMake.getAbsolutePath(), options.getMode().toShort());
                FileUtils.setLocalDirStickyBit((String)file.getPath());
                try {
                    this.setOwner(dirToMake.getAbsolutePath(), options.getOwner(), options.getGroup());
                }
                catch (IOException e) {
                    LOG.warn("Failed to update the ufs dir ownership, default values will be used: {}", (Object)e.toString());
                }
                continue;
            }
            return false;
        }
        return true;
    }

    public InputStream open(String path, OpenOptions options) throws IOException {
        path = this.stripPath(path);
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(path));
        try {
            ByteStreams.skipFully((InputStream)inputStream, (long)options.getOffset());
        }
        catch (IOException e) {
            ((InputStream)inputStream).close();
            throw e;
        }
        return inputStream;
    }

    public boolean renameDirectory(String src, String dst) throws IOException {
        if (!this.isDirectory(src)) {
            LOG.warn("Unable to rename {} to {} because source does not exist or is a file.", (Object)src, (Object)dst);
            return false;
        }
        return this.rename(src, dst);
    }

    public boolean renameFile(String src, String dst) throws IOException {
        if (!this.isFile(src)) {
            LOG.warn("Unable to rename {} to {} because source does not exist or is a directory.", (Object)src, (Object)dst);
            return false;
        }
        return this.rename(src, dst);
    }

    public void setOwner(String path, String user, String group) throws IOException {
        path = this.stripPath(path);
        try {
            if (!Strings.isNullOrEmpty((String)user)) {
                FileUtils.changeLocalFileUser((String)path, (String)user);
            }
            if (!Strings.isNullOrEmpty((String)group)) {
                FileUtils.changeLocalFileGroup((String)path, (String)group);
            }
        }
        catch (IOException e) {
            LOG.debug("Exception: ", (Throwable)e);
            if (!this.mUfsConf.getBoolean(PropertyKey.UNDERFS_ALLOW_SET_OWNER_FAILURE)) {
                LOG.warn("Failed to set owner for {} with user: {}, group: {}: {}. Running Alluxio as superuser is required to modify ownership of local files", new Object[]{path, user, group, e.toString()});
                throw e;
            }
            LOG.warn("Failed to set owner for {} with user: {}, group: {}: {}. This failure is ignored but may cause permission inconsistency between Alluxio and local under file system", new Object[]{path, user, group, e.toString()});
        }
    }

    public void setMode(String path, short mode) throws IOException {
        path = this.stripPath(path);
        String posixPerm = new Mode(mode).toString();
        FileUtils.changeLocalFilePermission((String)path, (String)posixPerm);
    }

    public void connectFromMaster(String hostname) throws IOException {
    }

    public void connectFromWorker(String hostname) throws IOException {
    }

    public boolean supportsFlush() throws IOException {
        return true;
    }

    private boolean rename(String src, String dst) throws IOException {
        src = this.stripPath(src);
        dst = this.stripPath(dst);
        File file = new File(src);
        return file.renameTo(new File(dst));
    }

    private String stripPath(String path) {
        return new AlluxioURI(path).getPath();
    }

    static class LocalOutputStream
    extends BufferedOutputStream
    implements ContentHashable {
        private final String mPath;

        LocalOutputStream(OutputStream out, String path) {
            super(out);
            this.mPath = path;
        }

        public Optional<String> getContentHash() {
            File file = new File(this.mPath);
            return Optional.of(UnderFileSystemUtils.approximateContentHash((long)file.length(), (long)file.lastModified()));
        }
    }
}

