/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.collections;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.common.collections.BatchedArrayBlockingQueue;
import org.apache.bookkeeper.common.collections.GrowableMpScArrayConsumerBlockingQueue;
import org.junit.Assert;
import org.junit.Test;

public class BatchedArrayBlockingQueueTest {
    @Test
    public void simple() throws Exception {
        BatchedArrayBlockingQueue queue = new BatchedArrayBlockingQueue(4);
        Assert.assertEquals(null, queue.poll());
        Assert.assertEquals((long)4L, (long)queue.remainingCapacity());
        try {
            queue.element();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            queue.iterator();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        for (int i = 0; i < 100; ++i) {
            queue.add(i);
            Assert.assertEquals((long)i, (long)((Integer)queue.take()).intValue());
        }
        queue.offer(1);
        queue.offer(2);
        queue.offer(3);
        queue.offer(4);
        Assert.assertEquals((long)4L, (long)queue.size());
        ArrayList list = new ArrayList();
        queue.drainTo(list, 3);
        Assert.assertEquals((long)1L, (long)queue.size());
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Integer[]{1, 2, 3}), list);
        Assert.assertEquals((long)4L, (long)((Integer)queue.peek()).intValue());
        Assert.assertEquals((long)4L, (long)((Integer)queue.element()).intValue());
        Assert.assertEquals((long)4L, (long)((Integer)queue.remove()).intValue());
        try {
            queue.remove();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void blockingTake() throws Exception {
        GrowableMpScArrayConsumerBlockingQueue queue = new GrowableMpScArrayConsumerBlockingQueue();
        CountDownLatch latch = new CountDownLatch(1);
        new Thread(() -> BatchedArrayBlockingQueueTest.lambda$blockingTake$0((BlockingQueue)queue, latch)).start();
        int n = 0;
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                queue.put(n);
                ++n;
            }
            while (!queue.isEmpty()) {
                Thread.sleep(1L);
            }
        }
        latch.await();
    }

    @Test
    public void blockWhenFull() throws Exception {
        BatchedArrayBlockingQueue queue = new BatchedArrayBlockingQueue(4);
        Assert.assertEquals(null, queue.poll());
        Assert.assertTrue((boolean)queue.offer(1));
        Assert.assertTrue((boolean)queue.offer(2));
        Assert.assertTrue((boolean)queue.offer(3));
        Assert.assertTrue((boolean)queue.offer(4));
        Assert.assertFalse((boolean)queue.offer(5));
        Assert.assertEquals((long)4L, (long)queue.size());
        CountDownLatch latch = new CountDownLatch(1);
        new Thread(() -> BatchedArrayBlockingQueueTest.lambda$blockWhenFull$1((BlockingQueue)queue, latch)).start();
        Thread.sleep(100L);
        Assert.assertEquals((long)1L, (long)latch.getCount());
        Assert.assertEquals((long)1L, (long)((Integer)queue.poll()).intValue());
        Assert.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS));
        Assert.assertEquals((long)4L, (long)queue.size());
        queue.clear();
        Assert.assertEquals((long)0L, (long)queue.size());
        Assert.assertTrue((boolean)queue.offer(1, 1L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)queue.offer(2, 1L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)queue.offer(3, 1L, TimeUnit.SECONDS));
        Assert.assertEquals((long)3L, (long)queue.size());
        ArrayList list = new ArrayList();
        queue.drainTo(list);
        Assert.assertEquals((long)0L, (long)queue.size());
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Integer[]{1, 2, 3}), list);
    }

    @Test
    public void pollTimeout() throws Exception {
        BatchedArrayBlockingQueue queue = new BatchedArrayBlockingQueue(4);
        Assert.assertEquals(null, queue.poll(1L, TimeUnit.MILLISECONDS));
        queue.put(1);
        Assert.assertEquals((long)1L, (long)((Integer)queue.poll(1L, TimeUnit.MILLISECONDS)).intValue());
        Assert.assertEquals(null, queue.poll(0L, TimeUnit.HOURS));
        queue.put(2);
        queue.put(3);
        Assert.assertEquals((long)2L, (long)((Integer)queue.poll(1L, TimeUnit.HOURS)).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)queue.poll(1L, TimeUnit.HOURS)).intValue());
    }

    @Test
    public void pollTimeout2() throws Exception {
        BatchedArrayBlockingQueue queue = new BatchedArrayBlockingQueue(10);
        CountDownLatch latch = new CountDownLatch(1);
        new Thread(() -> BatchedArrayBlockingQueueTest.lambda$pollTimeout2$2((BlockingQueue)queue, latch)).start();
        Thread.sleep(100L);
        queue.put(1);
        latch.await();
    }

    @Test
    public void drainToArray() throws Exception {
        int i;
        BatchedArrayBlockingQueue queue = new BatchedArrayBlockingQueue(100);
        for (int i2 = 0; i2 < 10; ++i2) {
            queue.add((Object)i2);
        }
        Object[] local = new Integer[5];
        int items = queue.takeAll(local);
        Assert.assertEquals((long)5L, (long)items);
        for (i = 0; i < items; ++i) {
            Assert.assertEquals((long)i, (long)((Integer)local[i]).intValue());
        }
        Assert.assertEquals((long)5L, (long)queue.size());
        items = queue.takeAll(local);
        Assert.assertEquals((long)5L, (long)items);
        for (i = 0; i < items; ++i) {
            Assert.assertEquals((long)(i + 5), (long)((Integer)local[i]).intValue());
        }
        Assert.assertEquals((long)0L, (long)queue.size());
        CountDownLatch latch = new CountDownLatch(1);
        new Thread(() -> BatchedArrayBlockingQueueTest.lambda$drainToArray$3(queue, (Integer[])local, latch)).start();
        Thread.sleep(100L);
        Assert.assertEquals((long)1L, (long)latch.getCount());
        Assert.assertEquals((long)0L, (long)queue.size());
        queue.put((Object)1);
        Assert.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS));
        Assert.assertEquals((long)0L, (long)queue.size());
    }

    @Test
    public void putAll() throws Exception {
        BatchedArrayBlockingQueue queue = new BatchedArrayBlockingQueue(10);
        Object[] items = new Integer[100];
        for (int i = 0; i < 100; ++i) {
            items[i] = i;
        }
        queue.putAll(items, 0, 5);
        Assert.assertEquals((long)5L, (long)queue.size());
        queue.putAll(items, 0, 5);
        Assert.assertEquals((long)10L, (long)queue.size());
        queue.clear();
        CountDownLatch latch = new CountDownLatch(1);
        new Thread(() -> BatchedArrayBlockingQueueTest.lambda$putAll$4(queue, (Integer[])items, latch)).start();
        Thread.sleep(100L);
        Assert.assertEquals((long)1L, (long)latch.getCount());
        Assert.assertEquals((long)10L, (long)queue.size());
        queue.take();
        Assert.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS));
        Assert.assertEquals((long)10L, (long)queue.size());
    }

    private static /* synthetic */ void lambda$putAll$4(BatchedArrayBlockingQueue queue, Integer[] items, CountDownLatch latch) {
        try {
            queue.putAll((Object[])items, 0, 11);
            latch.countDown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void lambda$drainToArray$3(BatchedArrayBlockingQueue queue, Integer[] local, CountDownLatch latch) {
        try {
            int c = queue.takeAll((Object[])local);
            Assert.assertEquals((long)1L, (long)c);
            latch.countDown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void lambda$pollTimeout2$2(BlockingQueue queue, CountDownLatch latch) {
        try {
            queue.poll(1L, TimeUnit.HOURS);
            latch.countDown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void lambda$blockWhenFull$1(BlockingQueue queue, CountDownLatch latch) {
        try {
            queue.put(5);
            latch.countDown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void lambda$blockingTake$0(BlockingQueue queue, CountDownLatch latch) {
        try {
            int expected = 0;
            for (int i = 0; i < 100; ++i) {
                int n = (Integer)queue.take();
                Assert.assertEquals((long)expected++, (long)n);
            }
            latch.countDown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

