/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.conf;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import org.apache.bookkeeper.common.conf.ConcurrentConfiguration;
import org.apache.bookkeeper.common.conf.ConfigException;
import org.apache.bookkeeper.common.conf.ConfigKey;
import org.apache.bookkeeper.common.conf.Type;
import org.apache.bookkeeper.common.conf.Validator;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ConfigKeyTest {
    @Rule
    public final TestName runtime = new TestName();

    @Test
    public void testValidateRequiredField() {
        String keyName = this.runtime.getMethodName();
        ConcurrentConfiguration conf = new ConcurrentConfiguration();
        ConfigKey key = ConfigKey.builder((String)keyName).required(true).build();
        try {
            key.validate((Configuration)conf);
            Assert.fail((String)"Required key should exist in the configuration");
        }
        catch (ConfigException configException) {
            // empty catch block
        }
    }

    @Test
    public void testValidateFieldSuccess() throws ConfigException {
        String keyName = this.runtime.getMethodName();
        Validator validator = (Validator)Mockito.mock(Validator.class);
        Mockito.when((Object)validator.validate(ArgumentMatchers.anyString(), ArgumentMatchers.any())).thenReturn((Object)true);
        ConcurrentConfiguration conf = new ConcurrentConfiguration();
        conf.setProperty(keyName, (Object)"test-value");
        ConfigKey key = ConfigKey.builder((String)keyName).validator(validator).build();
        key.validate((Configuration)conf);
        ((Validator)Mockito.verify((Object)validator, (VerificationMode)Mockito.times((int)1))).validate((String)ArgumentMatchers.eq((Object)keyName), ArgumentMatchers.eq((Object)"test-value"));
    }

    @Test
    public void testValidateFieldFailure() {
        String keyName = this.runtime.getMethodName();
        Validator validator = (Validator)Mockito.mock(Validator.class);
        Mockito.when((Object)validator.validate(ArgumentMatchers.anyString(), ArgumentMatchers.any())).thenReturn((Object)false);
        ConcurrentConfiguration conf = new ConcurrentConfiguration();
        conf.setProperty(keyName, (Object)"test-value");
        ConfigKey key = ConfigKey.builder((String)keyName).validator(validator).build();
        try {
            key.validate((Configuration)conf);
            Assert.fail((String)"Should fail validation if validator#validate returns false");
        }
        catch (ConfigException configException) {
            // empty catch block
        }
        ((Validator)Mockito.verify((Object)validator, (VerificationMode)Mockito.times((int)1))).validate((String)ArgumentMatchers.eq((Object)keyName), ArgumentMatchers.eq((Object)"test-value"));
    }

    @Test
    public void testGetLong() {
        String keyName = this.runtime.getMethodName();
        long defaultValue = System.currentTimeMillis();
        ConfigKey key = ConfigKey.builder((String)keyName).required(true).type(Type.LONG).defaultValue((Object)defaultValue).build();
        ConcurrentConfiguration conf = new ConcurrentConfiguration();
        Assert.assertEquals((long)defaultValue, (long)key.getLong((Configuration)conf));
        Assert.assertEquals((Object)defaultValue, (Object)key.get((Configuration)conf));
        long newValue = System.currentTimeMillis() * 2L;
        key.set((Configuration)conf, (Object)newValue);
        Assert.assertEquals((long)newValue, (long)key.getLong((Configuration)conf));
        Assert.assertEquals((Object)newValue, (Object)key.get((Configuration)conf));
    }

    @Test
    public void testGetInt() {
        String keyName = this.runtime.getMethodName();
        int defaultValue = ThreadLocalRandom.current().nextInt(10000);
        ConfigKey key = ConfigKey.builder((String)keyName).required(true).type(Type.INT).defaultValue((Object)defaultValue).build();
        ConcurrentConfiguration conf = new ConcurrentConfiguration();
        Assert.assertEquals((long)defaultValue, (long)key.getInt((Configuration)conf));
        Assert.assertEquals((Object)defaultValue, (Object)key.get((Configuration)conf));
        int newValue = defaultValue * 2;
        key.set((Configuration)conf, (Object)newValue);
        Assert.assertEquals((long)newValue, (long)key.getInt((Configuration)conf));
        Assert.assertEquals((Object)newValue, (Object)key.get((Configuration)conf));
    }

    @Test
    public void testGetShort() {
        String keyName = this.runtime.getMethodName();
        short defaultValue = (short)ThreadLocalRandom.current().nextInt(10000);
        ConfigKey key = ConfigKey.builder((String)keyName).required(true).type(Type.SHORT).defaultValue((Object)defaultValue).build();
        ConcurrentConfiguration conf = new ConcurrentConfiguration();
        Assert.assertEquals((long)defaultValue, (long)key.getShort((Configuration)conf));
        Assert.assertEquals((Object)defaultValue, (Object)key.get((Configuration)conf));
        short newValue = (short)(defaultValue * 2);
        key.set((Configuration)conf, (Object)newValue);
        Assert.assertEquals((long)newValue, (long)key.getShort((Configuration)conf));
        Assert.assertEquals((Object)newValue, (Object)key.get((Configuration)conf));
    }

    @Test
    public void testGetDouble() {
        String keyName = this.runtime.getMethodName();
        double defaultValue = ThreadLocalRandom.current().nextDouble(10000.0);
        ConfigKey key = ConfigKey.builder((String)keyName).required(true).type(Type.DOUBLE).defaultValue((Object)defaultValue).build();
        ConcurrentConfiguration conf = new ConcurrentConfiguration();
        Assert.assertEquals((double)defaultValue, (double)key.getDouble((Configuration)conf), (double)1.0E-4);
        Assert.assertEquals((Object)defaultValue, (Object)key.get((Configuration)conf));
        double newValue = defaultValue * 2.0;
        key.set((Configuration)conf, (Object)newValue);
        Assert.assertEquals((double)newValue, (double)key.getDouble((Configuration)conf), (double)1.0E-4);
        Assert.assertEquals((Object)newValue, (Object)key.get((Configuration)conf));
    }

    @Test
    public void testGetBoolean() {
        String keyName = this.runtime.getMethodName();
        boolean defaultValue = ThreadLocalRandom.current().nextBoolean();
        ConfigKey key = ConfigKey.builder((String)keyName).required(true).type(Type.BOOLEAN).defaultValue((Object)defaultValue).build();
        ConcurrentConfiguration conf = new ConcurrentConfiguration();
        Assert.assertEquals((Object)defaultValue, (Object)key.getBoolean((Configuration)conf));
        Assert.assertEquals((Object)defaultValue, (Object)key.get((Configuration)conf));
        boolean newValue = !defaultValue;
        key.set((Configuration)conf, (Object)newValue);
        Assert.assertEquals((Object)newValue, (Object)key.getBoolean((Configuration)conf));
        Assert.assertEquals((Object)newValue, (Object)key.get((Configuration)conf));
    }

    @Test
    public void testGetList() {
        String keyName = this.runtime.getMethodName();
        ArrayList defaultList = Lists.newArrayList((Object[])new String[]{"item1", "item2", "item3"});
        ConfigKey key = ConfigKey.builder((String)keyName).required(true).type(Type.LIST).defaultValue((Object)defaultList).build();
        CompositeConfiguration conf = new CompositeConfiguration(){
            {
                this.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
            }
        };
        Assert.assertEquals((Object)defaultList, (Object)key.getList((Configuration)conf));
        Assert.assertEquals((Object)defaultList, (Object)key.get((Configuration)conf));
        ArrayList newList = Lists.newArrayList((Object[])new String[]{"item4", "item5", "item6"});
        key.set((Configuration)conf, (Object)newList);
        Assert.assertEquals((Object)newList, (Object)key.getList((Configuration)conf));
        Assert.assertEquals((Object)newList, (Object)key.get((Configuration)conf));
        newList = Lists.newArrayList((Object[])new String[]{"item7", "item8", "item9"});
        conf.setProperty(key.name(), (Object)"item7,item8,item9");
        Assert.assertEquals((Object)newList, (Object)key.getList((Configuration)conf));
        Assert.assertEquals((Object)newList, (Object)key.get((Configuration)conf));
    }

    @Test
    public void testGetClass() {
        String keyName = this.runtime.getMethodName();
        Class<TestFunctionA> defaultClass = TestFunctionA.class;
        ConfigKey key = ConfigKey.builder((String)keyName).required(true).type(Type.CLASS).defaultValue(defaultClass).build();
        CompositeConfiguration conf = new CompositeConfiguration();
        Assert.assertEquals(defaultClass, (Object)key.getClass((Configuration)conf));
        Assert.assertEquals(defaultClass, (Object)key.get((Configuration)conf));
        Class<TestFunctionB> newClass = TestFunctionB.class;
        key.set((Configuration)conf, newClass);
        Assert.assertEquals(newClass, (Object)key.getClass((Configuration)conf));
        Assert.assertEquals(newClass, (Object)key.get((Configuration)conf));
        String newClassName = TestFunctionC.class.getName();
        conf.setProperty(key.name(), (Object)newClassName);
        Assert.assertEquals(TestFunctionC.class, (Object)key.getClass((Configuration)conf));
        Assert.assertEquals(TestFunctionC.class, (Object)key.get((Configuration)conf));
    }

    @Test
    public void testGetString() {
        String keyName = this.runtime.getMethodName();
        String defaultValue = "default-string-value";
        ConfigKey key = ConfigKey.builder((String)keyName).required(true).type(Type.STRING).defaultValue((Object)defaultValue).build();
        CompositeConfiguration conf = new CompositeConfiguration();
        Assert.assertEquals((Object)defaultValue, (Object)key.getString((Configuration)conf));
        Assert.assertEquals((Object)defaultValue, (Object)key.get((Configuration)conf));
        String newValue = "new-string-value";
        key.set((Configuration)conf, (Object)newValue);
        Assert.assertEquals((Object)newValue, (Object)key.getString((Configuration)conf));
        Assert.assertEquals((Object)newValue, (Object)key.get((Configuration)conf));
    }

    private static class TestFunctionC
    implements Function<String, String> {
        private TestFunctionC() {
        }

        @Override
        public String apply(String s) {
            return s + "!";
        }
    }

    private static class TestFunctionB
    implements Function<String, String> {
        private TestFunctionB() {
        }

        @Override
        public String apply(String s) {
            return s + "!";
        }
    }

    private static class TestFunctionA
    implements Function<String, String> {
        private TestFunctionA() {
        }

        @Override
        public String apply(String s) {
            return s + "!";
        }
    }
}

