/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.conf.validators;

import org.apache.bookkeeper.common.conf.validators.RangeValidator;
import org.junit.Assert;
import org.junit.Test;

public class RangeValidatorTest {
    @Test
    public void testAtLeastRangeValidator() {
        RangeValidator range = RangeValidator.atLeast((Number)1234L);
        Assert.assertTrue((boolean)range.validate("test-0", (Object)1235L));
        Assert.assertTrue((boolean)range.validate("test-1", (Object)1234L));
        Assert.assertFalse((boolean)range.validate("test-2", (Object)1233L));
    }

    @Test
    public void testAtMostRangeValidator() {
        RangeValidator range = RangeValidator.atMost((Number)1234L);
        Assert.assertFalse((boolean)range.validate("test-0", (Object)1235L));
        Assert.assertTrue((boolean)range.validate("test-1", (Object)1234L));
        Assert.assertTrue((boolean)range.validate("test-2", (Object)1233L));
    }

    @Test
    public void testBetweenRangeValidator() {
        RangeValidator range = RangeValidator.between((Number)1230L, (Number)1240L);
        Assert.assertTrue((boolean)range.validate("test-0", (Object)1230L));
        Assert.assertTrue((boolean)range.validate("test-1", (Object)1235L));
        Assert.assertTrue((boolean)range.validate("test-2", (Object)1240L));
        Assert.assertFalse((boolean)range.validate("test-3", (Object)1229L));
        Assert.assertFalse((boolean)range.validate("test-4", (Object)1241L));
    }
}

