/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.testing;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.junit.Assert;

public final class MoreAsserts {
    private MoreAsserts() {
    }

    public static <T> void assertSetEquals(Set<T> expected, Set<T> actual) {
        Sets.SetView diff = Sets.difference(expected, actual);
        Assert.assertTrue((String)("Expected set contains items not exist at actual set : " + diff.immutableCopy()), (boolean)diff.isEmpty());
        diff = Sets.difference(actual, expected);
        Assert.assertTrue((String)("Actual set contains items not exist at expected set : " + diff.immutableCopy()), (boolean)diff.isEmpty());
    }

    public static <T> void assertUtil(Predicate<T> predicate, Supplier<T> supplier) throws InterruptedException {
        while (!predicate.test(supplier.get())) {
            TimeUnit.MILLISECONDS.sleep(100L);
        }
    }
}

