/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.util;

import java.util.Iterator;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.apache.bookkeeper.common.util.Backoff;
import org.apache.bookkeeper.common.util.StreamUtil;
import org.apache.commons.lang3.tuple.Pair;
import org.junit.Assert;
import org.junit.Test;

public class TestBackoff {
    static <T> void assertStreamEquals(Stream<T> s1, Stream<T> s2) {
        Iterator iter1 = s1.iterator();
        Iterator iter2 = s2.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            Object expectedValue = iter1.next();
            Object actualValue = iter2.next();
            Assert.assertEquals((String)("Expected = " + expectedValue + ", Actual = " + actualValue), expectedValue, actualValue);
        }
        Assert.assertTrue((!iter1.hasNext() && !iter2.hasNext() ? 1 : 0) != 0);
    }

    @Test
    public void testExponential() throws Exception {
        Stream backoffs = Backoff.exponential((long)1000L, (int)2, (long)Long.MAX_VALUE).limit(10L);
        Stream<Long> expectedBackoffs = LongStream.range(0L, 10L).mapToObj(i -> 1000L << (int)i);
        TestBackoff.assertStreamEquals(expectedBackoffs, backoffs);
    }

    @Test
    public void testExponentialPolicy() throws Exception {
        Stream<Long> expectedBackoffs = LongStream.range(0L, 10L).mapToObj(i -> 1000L << (int)i);
        Backoff.Exponential policy = Backoff.Exponential.of((long)1000L, (long)Long.MAX_VALUE, (int)2, (int)10);
        TestBackoff.assertStreamEquals(expectedBackoffs, policy.toBackoffs());
    }

    @Test
    public void testExponentialWithUpperLimit() throws Exception {
        Stream backoffs = Backoff.exponential((long)1000L, (int)2, (long)32000L).limit(10L);
        Stream<Long> expectedBackoffs = LongStream.range(0L, 10L).mapToObj(i -> Math.min(1000L << (int)i, 32000L));
        TestBackoff.assertStreamEquals(expectedBackoffs, backoffs);
    }

    @Test
    public void testExponentialPolicyWithUpperLimit() throws Exception {
        Stream<Long> expectedBackoffs = LongStream.range(0L, 10L).mapToObj(i -> Math.min(1000L << (int)i, 32000L));
        Backoff.Exponential policy = Backoff.Exponential.of((long)1000L, (long)32000L, (int)2, (int)10);
        TestBackoff.assertStreamEquals(expectedBackoffs, policy.toBackoffs());
    }

    @Test
    public void testExponentialJittered() throws Exception {
        Stream backoffs = Backoff.exponentialJittered((long)5L, (long)120L).limit(10L);
        Stream<Long> maxBackoffs = Stream.of(5L, 10L, 20L, 40L, 80L, 120L, 120L, 120L, 120L, 120L);
        StreamUtil.zip(backoffs, maxBackoffs, (expected, actual) -> {
            Assert.assertTrue((expected <= actual ? 1 : 0) != 0);
            return null;
        });
    }

    @Test
    public void testExponentialJitteredPolicy() throws Exception {
        Stream backoffs = Backoff.Jitter.of((Backoff.Jitter.Type)Backoff.Jitter.Type.EXPONENTIAL, (long)5L, (long)120L, (long)10L).toBackoffs();
        Stream<Long> maxBackoffs = Stream.of(5L, 10L, 20L, 40L, 80L, 120L, 120L, 120L, 120L, 120L);
        StreamUtil.zip((Stream)backoffs, maxBackoffs, (expected, actual) -> {
            Assert.assertTrue((expected <= actual ? 1 : 0) != 0);
            return null;
        });
    }

    @Test
    public void testConstant() throws Exception {
        Stream backoffs = Backoff.constant((long)12345L).limit(10L);
        Stream<Long> expectedBackoffs = LongStream.range(0L, 10L).mapToObj(i -> 12345L);
        TestBackoff.assertStreamEquals(expectedBackoffs, backoffs);
    }

    @Test
    public void testConstantPolicy() throws Exception {
        Stream backoffs = Backoff.Constant.of((long)12345L, (long)10L).toBackoffs();
        Stream<Long> expectedBackoffs = LongStream.range(0L, 10L).mapToObj(i -> 12345L);
        TestBackoff.assertStreamEquals(expectedBackoffs, backoffs);
    }

    @Test
    public void testEqualJittered() throws Exception {
        Stream backoffs = Backoff.equalJittered((long)5L, (long)120L).limit(10L);
        Stream<Pair> ranges = Stream.of(Pair.of((Object)5L, (Object)10L), Pair.of((Object)10L, (Object)20L), Pair.of((Object)20L, (Object)40L), Pair.of((Object)40L, (Object)80L), Pair.of((Object)80L, (Object)120L), Pair.of((Object)80L, (Object)120L), Pair.of((Object)80L, (Object)120L), Pair.of((Object)80L, (Object)120L), Pair.of((Object)80L, (Object)120L));
        StreamUtil.zip(backoffs, ranges, (backoff, maxPair) -> {
            Assert.assertTrue((backoff >= (Long)maxPair.getLeft() ? 1 : 0) != 0);
            Assert.assertTrue((backoff <= (Long)maxPair.getRight() ? 1 : 0) != 0);
            return null;
        });
    }

    @Test
    public void testEqualJitteredPolicy() throws Exception {
        Stream backoffs = Backoff.Jitter.of((Backoff.Jitter.Type)Backoff.Jitter.Type.EQUAL, (long)5L, (long)120L, (long)10L).toBackoffs();
        Stream<Pair> ranges = Stream.of(Pair.of((Object)5L, (Object)10L), Pair.of((Object)10L, (Object)20L), Pair.of((Object)20L, (Object)40L), Pair.of((Object)40L, (Object)80L), Pair.of((Object)80L, (Object)120L), Pair.of((Object)80L, (Object)120L), Pair.of((Object)80L, (Object)120L), Pair.of((Object)80L, (Object)120L), Pair.of((Object)80L, (Object)120L));
        StreamUtil.zip((Stream)backoffs, ranges, (backoff, maxPair) -> {
            Assert.assertTrue((backoff >= (Long)maxPair.getLeft() ? 1 : 0) != 0);
            Assert.assertTrue((backoff <= (Long)maxPair.getRight() ? 1 : 0) != 0);
            return null;
        });
    }

    @Test
    public void testDecorrelatedJittered() throws Exception {
        long startMs = ThreadLocalRandom.current().nextLong(1L, 1000L);
        long maxMs = ThreadLocalRandom.current().nextLong(startMs, startMs * 2L);
        Stream backoffs = Backoff.decorrelatedJittered((long)startMs, (long)maxMs).limit(10L);
        Iterator backoffIter = backoffs.iterator();
        Assert.assertTrue((boolean)backoffIter.hasNext());
        Assert.assertEquals((long)startMs, (long)((Long)backoffIter.next()));
        AtomicLong prevMs = new AtomicLong(startMs);
        backoffIter.forEachRemaining(backoffMs -> {
            Assert.assertTrue((backoffMs >= startMs ? 1 : 0) != 0);
            Assert.assertTrue((backoffMs <= prevMs.get() * 3L ? 1 : 0) != 0);
            Assert.assertTrue((backoffMs <= maxMs ? 1 : 0) != 0);
            prevMs.set((long)backoffMs);
        });
    }

    @Test
    public void testDecorrelatedJitteredPolicy() throws Exception {
        long startMs = ThreadLocalRandom.current().nextLong(1L, 1000L);
        long maxMs = ThreadLocalRandom.current().nextLong(startMs, startMs * 2L);
        Stream backoffs = Backoff.Jitter.of((Backoff.Jitter.Type)Backoff.Jitter.Type.DECORRELATED, (long)startMs, (long)maxMs, (long)10L).toBackoffs();
        Iterator backoffIter = backoffs.iterator();
        Assert.assertTrue((boolean)backoffIter.hasNext());
        Assert.assertEquals((long)startMs, (long)((Long)backoffIter.next()));
        AtomicLong prevMs = new AtomicLong(startMs);
        backoffIter.forEachRemaining(backoffMs -> {
            Assert.assertTrue((backoffMs >= startMs ? 1 : 0) != 0);
            Assert.assertTrue((backoffMs <= prevMs.get() * 3L ? 1 : 0) != 0);
            Assert.assertTrue((backoffMs <= maxMs ? 1 : 0) != 0);
            prevMs.set((long)backoffMs);
        });
    }
}

