/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.util;

import java.util.LinkedList;
import java.util.concurrent.Delayed;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.bookkeeper.common.util.SharedResourceManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestSharedResourceManager {
    private final LinkedList<MockScheduledFuture<?>> scheduledDestroyTasks = new LinkedList();
    private SharedResourceManager manager;
    private static final SharedResourceManager.Resource<ResourceInstance> SHARED_FOO = new ResourceFactory();
    private static final SharedResourceManager.Resource<ResourceInstance> SHARED_BAR = new ResourceFactory();

    @Before
    public void setUp() {
        this.manager = SharedResourceManager.create((Supplier)new MockExecutorFactory());
    }

    @Test
    public void destroyResourceWhenRefCountReachesZero() {
        ResourceInstance bar1;
        ResourceInstance foo1;
        ResourceInstance sharedFoo = foo1 = (ResourceInstance)this.manager.get(SHARED_FOO);
        ResourceInstance foo2 = (ResourceInstance)this.manager.get(SHARED_FOO);
        Assert.assertSame((Object)sharedFoo, (Object)foo2);
        ResourceInstance sharedBar = bar1 = (ResourceInstance)this.manager.get(SHARED_BAR);
        this.manager.release(SHARED_FOO, (Object)foo2);
        Assert.assertTrue((boolean)this.scheduledDestroyTasks.isEmpty());
        Assert.assertFalse((boolean)sharedFoo.closed);
        this.manager.release(SHARED_FOO, (Object)foo1);
        Assert.assertEquals((long)1L, (long)this.scheduledDestroyTasks.size());
        MockScheduledFuture<?> scheduledDestroyTask = this.scheduledDestroyTasks.poll();
        Assert.assertEquals((long)1L, (long)scheduledDestroyTask.getDelay(TimeUnit.SECONDS));
        scheduledDestroyTask.runTask();
        Assert.assertTrue((boolean)sharedFoo.closed);
        ResourceInstance foo3 = (ResourceInstance)this.manager.get(SHARED_FOO);
        Assert.assertNotSame((Object)sharedFoo, (Object)foo3);
        this.manager.release(SHARED_BAR, (Object)bar1);
        Assert.assertEquals((long)1L, (long)this.scheduledDestroyTasks.size());
        scheduledDestroyTask = this.scheduledDestroyTasks.poll();
        Assert.assertEquals((long)1L, (long)scheduledDestroyTask.getDelay(TimeUnit.SECONDS));
        scheduledDestroyTask.runTask();
        Assert.assertTrue((boolean)sharedBar.closed);
    }

    @Test
    public void cancelDestroyTask() {
        ResourceInstance foo1;
        ResourceInstance sharedFoo = foo1 = (ResourceInstance)this.manager.get(SHARED_FOO);
        this.manager.release(SHARED_FOO, (Object)foo1);
        MockScheduledFuture<?> scheduledDestroyTask = this.scheduledDestroyTasks.poll();
        Assert.assertFalse((boolean)((MockScheduledFuture)scheduledDestroyTask).cancelled);
        ResourceInstance foo2 = (ResourceInstance)this.manager.get(SHARED_FOO);
        Assert.assertTrue((boolean)((MockScheduledFuture)scheduledDestroyTask).cancelled);
        Assert.assertTrue((boolean)this.scheduledDestroyTasks.isEmpty());
        Assert.assertFalse((boolean)sharedFoo.closed);
        Assert.assertSame((Object)sharedFoo, (Object)foo2);
        this.manager.release(SHARED_FOO, (Object)foo2);
        scheduledDestroyTask = this.scheduledDestroyTasks.poll();
        Assert.assertFalse((boolean)((MockScheduledFuture)scheduledDestroyTask).cancelled);
        scheduledDestroyTask.runTask();
        Assert.assertTrue((boolean)sharedFoo.closed);
    }

    @Test
    public void releaseWrongInstance() {
        ResourceInstance uncached = new ResourceInstance();
        try {
            this.manager.release(SHARED_FOO, (Object)uncached);
            Assert.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ResourceInstance cached = (ResourceInstance)this.manager.get(SHARED_FOO);
        try {
            this.manager.release(SHARED_FOO, (Object)uncached);
            Assert.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.manager.release(SHARED_FOO, (Object)cached);
    }

    @Test
    public void overreleaseInstance() {
        ResourceInstance foo1 = (ResourceInstance)this.manager.get(SHARED_FOO);
        this.manager.release(SHARED_FOO, (Object)foo1);
        try {
            this.manager.release(SHARED_FOO, (Object)foo1);
            Assert.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private static class MockScheduledFuture<V>
    implements ScheduledFuture<V> {
        private boolean cancelled;
        private boolean finished;
        final Runnable command;
        final long delay;
        final TimeUnit unit;

        MockScheduledFuture(Runnable command, long delay, TimeUnit unit) {
            this.command = command;
            this.delay = delay;
            this.unit = unit;
        }

        void runTask() {
            this.command.run();
            this.finished = true;
        }

        @Override
        public boolean cancel(boolean interrupt) {
            if (this.cancelled || this.finished) {
                return false;
            }
            this.cancelled = true;
            return true;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public long getDelay(TimeUnit targetUnit) {
            return targetUnit.convert(this.delay, this.unit);
        }

        @Override
        public int compareTo(Delayed o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isDone() {
            return this.cancelled || this.finished;
        }

        @Override
        public V get() {
            throw new UnsupportedOperationException();
        }

        @Override
        public V get(long timeout, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }
    }

    private class MockExecutorFactory
    implements Supplier<ScheduledExecutorService> {
        private MockExecutorFactory() {
        }

        @Override
        public ScheduledExecutorService get() {
            ScheduledExecutorService mockExecutor = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
            Mockito.when(mockExecutor.schedule((Runnable)ArgumentMatchers.any(Runnable.class), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)))).thenAnswer(invocation -> {
                Object[] args = invocation.getArguments();
                Runnable command = (Runnable)args[0];
                long delay = (Long)args[1];
                TimeUnit unit = (TimeUnit)((Object)((Object)args[2]));
                MockScheduledFuture future = new MockScheduledFuture(command, delay, unit);
                TestSharedResourceManager.this.scheduledDestroyTasks.add(future);
                return future;
            });
            return mockExecutor;
        }
    }

    private static class ResourceFactory
    implements SharedResourceManager.Resource<ResourceInstance> {
        private ResourceFactory() {
        }

        public ResourceInstance create() {
            return new ResourceInstance();
        }

        public void close(ResourceInstance instance) {
            instance.closed = true;
        }
    }

    private static class ResourceInstance {
        volatile boolean closed;

        private ResourceInstance() {
        }
    }
}

