/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.assertions;

import com.datastax.oss.driver.api.core.loadbalancing.NodeDistance;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.NodeState;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;

public class NodeMetadataAssert
extends AbstractAssert<NodeMetadataAssert, Node> {
    public NodeMetadataAssert(Node actual) {
        super((Object)actual, NodeMetadataAssert.class);
    }

    public NodeMetadataAssert isUp() {
        Assertions.assertThat((Comparable)((Node)this.actual).getState()).isSameAs((Object)NodeState.UP);
        return this;
    }

    public NodeMetadataAssert isDown() {
        Assertions.assertThat((Comparable)((Node)this.actual).getState()).isSameAs((Object)NodeState.DOWN);
        return this;
    }

    public NodeMetadataAssert isUnknown() {
        Assertions.assertThat((Comparable)((Node)this.actual).getState()).isSameAs((Object)NodeState.UNKNOWN);
        return this;
    }

    public NodeMetadataAssert isForcedDown() {
        Assertions.assertThat((Comparable)((Node)this.actual).getState()).isSameAs((Object)NodeState.FORCED_DOWN);
        return this;
    }

    public NodeMetadataAssert hasOpenConnections(int expected) {
        Assertions.assertThat((int)((Node)this.actual).getOpenConnections()).isEqualTo(expected);
        return this;
    }

    public NodeMetadataAssert isReconnecting() {
        Assertions.assertThat((boolean)((Node)this.actual).isReconnecting()).isTrue();
        return this;
    }

    public NodeMetadataAssert isNotReconnecting() {
        Assertions.assertThat((boolean)((Node)this.actual).isReconnecting()).isFalse();
        return this;
    }

    public NodeMetadataAssert isLocal() {
        Assertions.assertThat((Comparable)((Node)this.actual).getDistance()).isSameAs((Object)NodeDistance.LOCAL);
        return this;
    }

    public NodeMetadataAssert isRemote() {
        Assertions.assertThat((Comparable)((Node)this.actual).getDistance()).isSameAs((Object)NodeDistance.REMOTE);
        return this;
    }

    public NodeMetadataAssert isIgnored() {
        Assertions.assertThat((Comparable)((Node)this.actual).getDistance()).isSameAs((Object)NodeDistance.IGNORED);
        return this;
    }
}

