/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.arrays;

import org.apache.commons.numbers.arrays.IndexSupport;
import org.apache.commons.numbers.arrays.Sorting;
import org.apache.commons.numbers.arrays.UpdatingInterval;

final class QuickSelect {
    static final int MODE_FR_SAMPLING = -1;
    static final int MODE_SAMPLING = 0;
    static final int MODE_ADAPTION = 1;
    static final int MODE_STRICT = 2;
    private static final int MIN_SORTSELECT_SIZE = 4;
    private static final int LINEAR_SORTSELECT_SIZE = 24;
    private static final int DP_SORTSELECT_SIZE = 20;
    private static final int FR_SAMPLING_SIZE = 1200;
    private static final int RECURSION_INCREMENT = 0x100000;
    private static final int SORTSELECT_MASK = 1048575;
    private static final double STEP_LEFT = 0.4375;
    private static final double STEP_RIGHT = 0.5625;
    private static final double STEP_FAR_LEFT = 0.08333333333333333;
    private static final double STEP_FAR_RIGHT = 0.9166666666666666;

    private QuickSelect() {
    }

    static void heapSelect(double[] a, int left, int right, int ka, int kb) {
        if (right <= left) {
            return;
        }
        if (kb - left < right - ka) {
            QuickSelect.heapSelectLeft(a, left, right, ka, kb);
        } else {
            QuickSelect.heapSelectRight(a, left, right, ka, kb);
        }
    }

    static void heapSelectLeft(double[] a, int left, int right, int ka, int kb) {
        int end = kb + 1;
        for (int p = left + (kb - left - 1 >> 1); p >= left; --p) {
            QuickSelect.maxHeapSiftDown(a, a[p], p, left, end);
        }
        double max = a[left];
        int i = right + 1;
        while (--i > kb) {
            double v = a[i];
            if (!(v < max)) continue;
            a[i] = max;
            QuickSelect.maxHeapSiftDown(a, v, left, left, end);
            max = a[left];
        }
        int last = Math.max(left, ka - 1);
        while (--end > last) {
            QuickSelect.maxHeapSiftDown(a, a[end], left, left, end);
            a[end] = max;
            max = a[left];
        }
    }

    private static void maxHeapSiftDown(double[] a, double v, int p, int root, int end) {
        int c;
        while ((c = (p << 1) - root + 2) <= end) {
            if (c == end || a[c] < a[c - 1]) {
                --c;
            }
            if (v >= a[c]) break;
            a[p] = a[c];
            p = c;
        }
        a[p] = v;
    }

    static void heapSelectRight(double[] a, int left, int right, int ka, int kb) {
        int end = ka - 1;
        for (int p = right - (right - ka - 1 >> 1); p <= right; ++p) {
            QuickSelect.minHeapSiftDown(a, a[p], p, right, end);
        }
        double min = a[right];
        int i = left - 1;
        while (++i < ka) {
            double v = a[i];
            if (!(v > min)) continue;
            a[i] = min;
            QuickSelect.minHeapSiftDown(a, v, right, right, end);
            min = a[right];
        }
        int last = Math.min(right, kb + 1);
        while (++end < last) {
            QuickSelect.minHeapSiftDown(a, a[end], right, right, end);
            a[end] = min;
            min = a[right];
        }
    }

    private static void minHeapSiftDown(double[] a, double v, int p, int root, int end) {
        int c;
        while ((c = (p << 1) - root - 2) >= end) {
            if (c == end || a[c] > a[c + 1]) {
                ++c;
            }
            if (v <= a[c]) break;
            a[p] = a[c];
            p = c;
        }
        a[p] = v;
    }

    static void sortSelect(double[] a, int left, int right, int ka, int kb) {
        if (right - left <= 4) {
            Sorting.sort(a, left, right);
            return;
        }
        if (kb - left < right - ka) {
            QuickSelect.sortSelectLeft(a, left, right, kb);
        } else {
            QuickSelect.sortSelectRight(a, left, right, ka);
        }
    }

    static void sortSelectLeft(double[] a, int left, int right, int k) {
        int i = left;
        while (++i <= k) {
            double v = a[i];
            if (!(v < a[i - 1])) continue;
            int j = i;
            while (--j >= left && v < a[j]) {
                a[j + 1] = a[j];
            }
            a[j + 1] = v;
        }
        double m = a[k];
        int i2 = right + 1;
        while (--i2 > k) {
            double v = a[i2];
            if (!(v < m)) continue;
            a[i2] = m;
            int j = k;
            while (--j >= left && v < a[j]) {
                a[j + 1] = a[j];
            }
            a[j + 1] = v;
            m = a[k];
        }
    }

    static void sortSelectRight(double[] a, int left, int right, int k) {
        int i = right;
        while (--i >= k) {
            double v = a[i];
            if (!(v > a[i + 1])) continue;
            int j = i;
            while (++j <= right && v > a[j]) {
                a[j - 1] = a[j];
            }
            a[j - 1] = v;
        }
        double m = a[k];
        int i2 = left - 1;
        while (++i2 < k) {
            double v = a[i2];
            if (!(v > m)) continue;
            a[i2] = m;
            int j = k;
            while (++j <= right && v > a[j]) {
                a[j - 1] = a[j];
            }
            a[j - 1] = v;
            m = a[k];
        }
    }

    static void select(double[] a, int left, int right, int k) {
        QuickSelect.quickSelectAdaptive(a, left, right, k, k, new int[1], -1);
    }

    static int select(double[] a, int left, int right, int[] k, int n) {
        if (n < 1) {
            return 0;
        }
        if (n == 1) {
            QuickSelect.quickSelectAdaptive(a, left, right, k[0], k[0], new int[1], -1);
            return -1;
        }
        UpdatingInterval keys = IndexSupport.createUpdatingInterval(left, right, k, n);
        int count = IndexSupport.countIndices(keys, n);
        int k1 = keys.left();
        int kn = keys.right();
        if (kn - k1 < 20) {
            QuickSelect.quickSelectAdaptive(a, left, right, k1, kn, new int[1], -1);
        } else {
            QuickSelect.dualPivotQuickSelect(a, left, right, keys, QuickSelect.dualPivotFlags(left, right, k1, kn));
        }
        return count;
    }

    static int quickSelectAdaptive(double[] a, int left, int right, int ka, int kb, int[] bounds, int flags) {
        int l = left;
        int r = right;
        int m = flags;
        while (true) {
            int p0;
            if (Math.min(kb - l, r - ka) < 24) {
                QuickSelect.sortSelect(a, l, r, ka, kb);
                bounds[0] = kb;
                return ka;
            }
            int n = r - l;
            double f = (double)(ka - l) / (double)n;
            int margin = n >> 2;
            if (m < 0 && r - l > 1200) {
                p0 = QuickSelect.sampleStep(a, l, r, ka, bounds);
                if (f <= 0.08333333333333333 || f >= 0.9166666666666666) {
                    margin += (n >> 5) + (n >> 6);
                } else if (f > 0.4375 && f < 0.5625) {
                    margin -= n >> 5;
                }
            } else if (f <= 0.4375) {
                if (f <= 0.08333333333333333) {
                    margin += (n >> 5) + (n >> 6);
                    p0 = QuickSelect.repeatedStepFarLeft(a, l, r, ka, bounds, m);
                } else {
                    p0 = QuickSelect.repeatedStepLeft(a, l, r, ka, bounds, m);
                }
            } else if (f >= 0.5625) {
                if (f >= 0.9166666666666666) {
                    margin += (n >> 5) + (n >> 6);
                    p0 = QuickSelect.repeatedStepFarRight(a, l, r, ka, bounds, m);
                } else {
                    p0 = QuickSelect.repeatedStepRight(a, l, r, ka, bounds, m);
                }
            } else {
                margin -= n >> 5;
                p0 = QuickSelect.repeatedStep(a, l, r, ka, bounds, m);
            }
            int p1 = bounds[0];
            if (kb < p0) {
                r = p0 - 1;
            } else if (ka > p1) {
                l = p1 + 1;
            } else {
                if (kb > p1) {
                    QuickSelect.sortSelectLeft(a, p1 + 1, r, kb);
                    bounds[0] = kb;
                }
                if (ka < p0) {
                    QuickSelect.sortSelectRight(a, l, p0 - 1, ka);
                    p0 = ka;
                }
                return p0;
            }
            if (r - l <= n - margin) continue;
            ++m;
        }
    }

    private static int sampleStep(double[] a, int l, int r, int k, int[] upper) {
        int n = r - l + 1;
        int ith = k - l + 1;
        double z = Math.log(n);
        double s = 0.5 * Math.exp(0.6666666666666666 * z);
        double sd = 0.5 * Math.sqrt(z * s * ((double)n - s) / (double)n) * (double)Integer.signum(ith - (n >> 1));
        int ll = Math.max(l, (int)((double)k - (double)ith * s / (double)n + sd));
        int rr = Math.min(r, (int)((double)k + (double)(n - ith) * s / (double)n + sd));
        int p = QuickSelect.quickSelectAdaptive(a, ll, rr, k, k, upper, -1);
        return QuickSelect.expandPartition(a, l, r, ll, rr, p, upper[0], upper);
    }

    private static int repeatedStep(double[] a, int l, int r, int k, int[] upper, int flags) {
        int p;
        int s;
        int fp;
        if (flags <= 0) {
            fp = (r - l + 1) / 12;
            s = k - QuickSelect.mapDistance(k - l, l, r, fp);
            p = k;
        } else {
            fp = (r - l + 1) / 9;
            int f3 = 3 * fp;
            int end = l + (f3 << 1);
            for (int i = l + f3; i < end; ++i) {
                Sorting.sort3(a, i - f3, i, i + f3);
            }
            s = l + (fp << 2);
            p = s + (flags == 1 ? QuickSelect.mapDistance(k - l, l, r, fp) : fp >>> 1);
        }
        int e = s + fp - 1;
        for (int i = s; i <= e; ++i) {
            Sorting.sort3(a, i - fp, i, i + fp);
        }
        p = QuickSelect.quickSelectAdaptive(a, s, e, p, p, upper, -1);
        return QuickSelect.expandPartition(a, l, r, s, e, p, upper[0], upper);
    }

    private static int repeatedStepLeft(double[] a, int l, int r, int k, int[] upper, int flags) {
        int p;
        int s;
        int fp;
        if (flags <= 0) {
            fp = (r - l + 1) / 12;
            s = Math.max(k - QuickSelect.mapDistance(k - l, l, r, fp), l + fp);
            p = k;
        } else {
            int f = r - l + 1 >> 2;
            int f2 = f + f;
            int end = l + f2;
            for (int i = l + f; i < end; ++i) {
                Sorting.lowerMedian4(a, i - f, i, i + f, i + f2);
            }
            fp = f / 3;
            s = l + f + fp;
            p = s + (flags == 1 ? QuickSelect.mapDistance(k - l, l, r, fp) : fp >>> 1);
        }
        int e = s + fp - 1;
        for (int i = s; i <= e; ++i) {
            Sorting.sort3(a, i - fp, i, i + fp);
        }
        p = QuickSelect.quickSelectAdaptive(a, s, e, p, p, upper, -1);
        return QuickSelect.expandPartition(a, l, r, s, e, p, upper[0], upper);
    }

    private static int repeatedStepRight(double[] a, int l, int r, int k, int[] upper, int flags) {
        int s;
        int p;
        int e;
        int fp;
        if (flags <= 0) {
            fp = (r - l + 1) / 12;
            e = Math.min(k + QuickSelect.mapDistance(r - k, l, r, fp), r - fp);
            p = k;
        } else {
            int f = r - l + 1 >> 2;
            int f2 = f + f;
            int end = r - f2;
            for (int i = r - f; i > end; --i) {
                Sorting.upperMedian4(a, i - f2, i - f, i, i + f);
            }
            fp = f / 3;
            e = r - f - fp;
            p = e - (flags == 1 ? QuickSelect.mapDistance(r - k, l, r, fp) : fp >>> 1);
        }
        for (int i = s = e - fp + 1; i <= e; ++i) {
            Sorting.sort3(a, i - fp, i, i + fp);
        }
        p = QuickSelect.quickSelectAdaptive(a, s, e, p, p, upper, -1);
        return QuickSelect.expandPartition(a, l, r, s, e, p, upper[0], upper);
    }

    private static int repeatedStepFarLeft(double[] a, int l, int r, int k, int[] upper, int flags) {
        int p;
        int s;
        int fp;
        if (flags <= 0) {
            fp = (r - l + 1) / 12;
            s = l + fp;
            p = s + QuickSelect.mapDistance(k - l, l, r, fp);
        } else {
            int f = r - l + 1 >> 2;
            int f2 = f + f;
            int end = l + f2;
            for (int i = l + f; i < end; ++i) {
                double u;
                if (a[i + f] < a[i - f]) {
                    u = a[i + f];
                    a[i + f] = a[i - f];
                    a[i - f] = u;
                }
                if (a[i + f2] < a[i]) {
                    double v = a[i + f2];
                    a[i + f2] = a[i];
                    a[i] = v;
                }
                if (!(a[i] < a[i - f])) continue;
                u = a[i];
                a[i] = a[i - f];
                a[i - f] = u;
            }
            fp = f / 3;
            s = l + fp;
            p = s + (k - l >>> 1);
        }
        int e = s + fp - 1;
        for (int i = s; i <= e; ++i) {
            Sorting.sort3(a, i - fp, i, i + fp);
        }
        p = QuickSelect.quickSelectAdaptive(a, s, e, p, p, upper, -1);
        return QuickSelect.expandPartition(a, l, r, s, e, p, upper[0], upper);
    }

    private static int repeatedStepFarRight(double[] a, int l, int r, int k, int[] upper, int flags) {
        int s;
        int p;
        int e;
        int fp;
        if (flags <= 0) {
            fp = (r - l + 1) / 12;
            e = r - fp;
            p = e - QuickSelect.mapDistance(r - k, l, r, fp);
        } else {
            int f = r - l + 1 >> 2;
            int f2 = f + f;
            int end = r - f2;
            for (int i = r - f; i > end; --i) {
                double u;
                if (a[i - f] > a[i + f]) {
                    u = a[i - f];
                    a[i - f] = a[i + f];
                    a[i + f] = u;
                }
                if (a[i - f2] > a[i]) {
                    double v = a[i - f2];
                    a[i - f2] = a[i];
                    a[i] = v;
                }
                if (!(a[i] > a[i + f])) continue;
                u = a[i];
                a[i] = a[i + f];
                a[i + f] = u;
            }
            fp = f / 3;
            e = r - fp;
            p = e - (r - k >>> 1);
        }
        for (int i = s = e - fp + 1; i <= e; ++i) {
            Sorting.sort3(a, i - fp, i, i + fp);
        }
        p = QuickSelect.quickSelectAdaptive(a, s, e, p, p, upper, -1);
        return QuickSelect.expandPartition(a, l, r, s, e, p, upper[0], upper);
    }

    static int expandPartition(double[] a, int left, int right, int start, int end, int pivot0, int pivot1, int[] upper) {
        int p1;
        int p0;
        block10: {
            double v = a[pivot0];
            double vi = a[start];
            double vj = a[end];
            a[start] = a[left];
            a[end] = a[right];
            a[left] = vj;
            a[right] = vi;
            int i = start + 1;
            int j = end - 1;
            p0 = pivot0 == start ? i : pivot0;
            int n = p1 = pivot1 == end ? j : pivot1;
            while (true) {
                if (a[--i] < v) {
                    continue;
                }
                while (a[++j] > v) {
                }
                vj = a[i];
                a[i] = vi = a[j];
                a[j] = vj;
                if (vi == v) {
                    a[i] = a[--p0];
                    a[p0] = v;
                }
                if (vj == v) {
                    a[j] = a[++p1];
                    a[p1] = v;
                }
                if (i == left) {
                    while (j < right) {
                        while (a[++j] > v) {
                        }
                        double w = a[j];
                        a[j] = a[++p1];
                        a[p1] = v;
                        if (w == v) continue;
                        a[p0] = w;
                        ++p0;
                    }
                    break block10;
                }
                if (j == right) break;
            }
            while (i > left) {
                while (a[--i] < v) {
                }
                double w = a[i];
                a[i] = a[--p0];
                a[p0] = v;
                if (w == v) continue;
                a[p1] = w;
                --p1;
            }
        }
        upper[0] = p1;
        return p0;
    }

    static void dualPivotQuickSelect(double[] a, int left, int right, UpdatingInterval k, int flags) {
        int l = left;
        int r = right;
        int f = flags;
        int ka = k.left();
        int kb = k.right();
        int[] upper = new int[]{0, 0, 0};
        while (true) {
            int n = r - l;
            if (Math.min(kb - l, r - ka) < 20 || n < (f & 0xFFFFF)) {
                QuickSelect.sortSelect(a, l, r, ka, kb);
                return;
            }
            if (kb - ka < 20) {
                QuickSelect.quickSelectAdaptive(a, l, r, ka, kb, upper, -1);
                return;
            }
            if (f < 0) {
                QuickSelect.heapSelect(a, l, r, ka, kb);
                return;
            }
            int p0 = QuickSelect.partition(a, l, r, upper);
            int p1 = upper[0];
            f += 0x100000;
            if (ka < p0) {
                if (kb <= p1) {
                    r = p0 - 1;
                    if (r >= kb) continue;
                    kb = k.updateRight(r);
                    continue;
                }
                QuickSelect.dualPivotQuickSelect(a, l, p0 - 1, k.splitLeft(p0, p1), f);
                ka = k.left();
            } else {
                if (kb <= p1) {
                    return;
                }
                if (ka <= p1) {
                    ka = k.updateLeft(p1 + 1);
                }
            }
            int p2 = upper[1];
            int p3 = upper[2];
            if (ka < p2) {
                l = p1 + 1;
                if (kb <= p3) {
                    r = p2 - 1;
                    if (r >= kb) continue;
                    kb = k.updateRight(r);
                    continue;
                }
                QuickSelect.dualPivotQuickSelect(a, l, p2 - 1, k.splitLeft(p2, p3), f);
                ka = k.left();
            } else {
                if (kb <= p3) {
                    return;
                }
                if (ka <= p3) {
                    ka = k.updateLeft(p3 + 1);
                }
            }
            l = p3 + 1;
        }
    }

    private static int partition(double[] a, int left, int right, int[] bounds) {
        int n = right - left;
        int step = 1 + (n >>> 3) + (n >>> 6);
        int i3 = left + (n >>> 1);
        int i2 = i3 - step;
        int i1 = i2 - step;
        int i4 = i3 + step;
        int i5 = i4 + step;
        Sorting.sort5(a, i1, i2, i3, i4, i5);
        double v1 = a[i2];
        a[i2] = a[left];
        a[left] = v1;
        double v2 = a[i4];
        a[i4] = a[right];
        a[right] = v2;
        int less = left;
        int great = right;
        while (a[++less] < v1) {
        }
        while (a[--great] > v2) {
        }
        int k = less - 1;
        block2: while (++k <= great) {
            double v = a[k];
            if (v < v1) {
                a[k] = a[less];
                a[less] = v;
                ++less;
                continue;
            }
            if (!(v > v2)) continue;
            while (a[great] > v2) {
                if (great-- != k) continue;
                break block2;
            }
            double w = a[great];
            a[great] = v;
            --great;
            if (w < v1) {
                a[k] = a[less];
                a[less] = w;
                ++less;
                continue;
            }
            a[k] = w;
        }
        a[left] = a[--less];
        a[less] = v1;
        a[right] = a[++great];
        a[great] = v2;
        int lower = less;
        bounds[2] = great;
        if (great - less > (n >>> 1) + (n >>> 3) && v1 != v2) {
            while (a[++less] == v1) {
            }
            while (a[--great] == v2) {
            }
            int k2 = less - 1;
            block6: while (++k2 <= great) {
                double v = a[k2];
                if (v == v1) {
                    a[k2] = a[less];
                    a[less] = v;
                    ++less;
                    continue;
                }
                if (v != v2) continue;
                while (a[great] == v2) {
                    if (great-- != k2) continue;
                    break block6;
                }
                double w = a[great];
                a[great] = v;
                --great;
                if (w == v1) {
                    a[k2] = a[less];
                    a[less] = w;
                    ++less;
                    continue;
                }
                a[k2] = w;
            }
            --less;
            ++great;
        }
        if (v1 != v2 && less < great - 1) {
            bounds[0] = less;
            bounds[1] = great;
        } else {
            bounds[0] = bounds[2];
            bounds[1] = lower;
        }
        return lower;
    }

    static void heapSelect(int[] a, int left, int right, int ka, int kb) {
        if (right <= left) {
            return;
        }
        if (kb - left < right - ka) {
            QuickSelect.heapSelectLeft(a, left, right, ka, kb);
        } else {
            QuickSelect.heapSelectRight(a, left, right, ka, kb);
        }
    }

    static void heapSelectLeft(int[] a, int left, int right, int ka, int kb) {
        int end = kb + 1;
        for (int p = left + (kb - left - 1 >> 1); p >= left; --p) {
            QuickSelect.maxHeapSiftDown(a, a[p], p, left, end);
        }
        int max = a[left];
        int i = right + 1;
        while (--i > kb) {
            int v = a[i];
            if (v >= max) continue;
            a[i] = max;
            QuickSelect.maxHeapSiftDown(a, v, left, left, end);
            max = a[left];
        }
        int last = Math.max(left, ka - 1);
        while (--end > last) {
            QuickSelect.maxHeapSiftDown(a, a[end], left, left, end);
            a[end] = max;
            max = a[left];
        }
    }

    private static void maxHeapSiftDown(int[] a, int v, int p, int root, int end) {
        int c;
        while ((c = (p << 1) - root + 2) <= end) {
            if (c == end || a[c] < a[c - 1]) {
                --c;
            }
            if (v >= a[c]) break;
            a[p] = a[c];
            p = c;
        }
        a[p] = v;
    }

    static void heapSelectRight(int[] a, int left, int right, int ka, int kb) {
        int end = ka - 1;
        for (int p = right - (right - ka - 1 >> 1); p <= right; ++p) {
            QuickSelect.minHeapSiftDown(a, a[p], p, right, end);
        }
        int min = a[right];
        int i = left - 1;
        while (++i < ka) {
            int v = a[i];
            if (v <= min) continue;
            a[i] = min;
            QuickSelect.minHeapSiftDown(a, v, right, right, end);
            min = a[right];
        }
        int last = Math.min(right, kb + 1);
        while (++end < last) {
            QuickSelect.minHeapSiftDown(a, a[end], right, right, end);
            a[end] = min;
            min = a[right];
        }
    }

    private static void minHeapSiftDown(int[] a, int v, int p, int root, int end) {
        int c;
        while ((c = (p << 1) - root - 2) >= end) {
            if (c == end || a[c] > a[c + 1]) {
                ++c;
            }
            if (v <= a[c]) break;
            a[p] = a[c];
            p = c;
        }
        a[p] = v;
    }

    static void sortSelect(int[] a, int left, int right, int ka, int kb) {
        if (right - left <= 4) {
            Sorting.sort(a, left, right);
            return;
        }
        if (kb - left < right - ka) {
            QuickSelect.sortSelectLeft(a, left, right, kb);
        } else {
            QuickSelect.sortSelectRight(a, left, right, ka);
        }
    }

    static void sortSelectLeft(int[] a, int left, int right, int k) {
        int i = left;
        while (++i <= k) {
            int v = a[i];
            if (v >= a[i - 1]) continue;
            int j = i;
            while (--j >= left && v < a[j]) {
                a[j + 1] = a[j];
            }
            a[j + 1] = v;
        }
        int m = a[k];
        int i2 = right + 1;
        while (--i2 > k) {
            int v = a[i2];
            if (v >= m) continue;
            a[i2] = m;
            int j = k;
            while (--j >= left && v < a[j]) {
                a[j + 1] = a[j];
            }
            a[j + 1] = v;
            m = a[k];
        }
    }

    static void sortSelectRight(int[] a, int left, int right, int k) {
        int i = right;
        while (--i >= k) {
            int v = a[i];
            if (v <= a[i + 1]) continue;
            int j = i;
            while (++j <= right && v > a[j]) {
                a[j - 1] = a[j];
            }
            a[j - 1] = v;
        }
        int m = a[k];
        int i2 = left - 1;
        while (++i2 < k) {
            int v = a[i2];
            if (v <= m) continue;
            a[i2] = m;
            int j = k;
            while (++j <= right && v > a[j]) {
                a[j - 1] = a[j];
            }
            a[j - 1] = v;
            m = a[k];
        }
    }

    static void select(int[] a, int left, int right, int k) {
        QuickSelect.quickSelectAdaptive(a, left, right, k, k, new int[1], -1);
    }

    static void select(int[] a, int left, int right, int[] k, int n) {
        if (n == 1) {
            QuickSelect.quickSelectAdaptive(a, left, right, k[0], k[0], new int[1], -1);
            return;
        }
        UpdatingInterval keys = IndexSupport.createUpdatingInterval(left, right, k, n);
        int k1 = keys.left();
        int kn = keys.right();
        if (kn - k1 < 20) {
            QuickSelect.quickSelectAdaptive(a, left, right, k1, kn, new int[1], -1);
        } else {
            QuickSelect.dualPivotQuickSelect(a, left, right, keys, QuickSelect.dualPivotFlags(left, right, k1, kn));
        }
    }

    static int quickSelectAdaptive(int[] a, int left, int right, int ka, int kb, int[] bounds, int flags) {
        int l = left;
        int r = right;
        int m = flags;
        while (true) {
            int p0;
            if (Math.min(kb - l, r - ka) < 24) {
                QuickSelect.sortSelect(a, l, r, ka, kb);
                bounds[0] = kb;
                return ka;
            }
            int n = r - l;
            double f = (double)(ka - l) / (double)n;
            int margin = n >> 2;
            if (m < 0 && r - l > 1200) {
                p0 = QuickSelect.sampleStep(a, l, r, ka, bounds);
                if (f <= 0.08333333333333333 || f >= 0.9166666666666666) {
                    margin += (n >> 5) + (n >> 6);
                } else if (f > 0.4375 && f < 0.5625) {
                    margin -= n >> 5;
                }
            } else if (f <= 0.4375) {
                if (f <= 0.08333333333333333) {
                    margin += (n >> 5) + (n >> 6);
                    p0 = QuickSelect.repeatedStepFarLeft(a, l, r, ka, bounds, m);
                } else {
                    p0 = QuickSelect.repeatedStepLeft(a, l, r, ka, bounds, m);
                }
            } else if (f >= 0.5625) {
                if (f >= 0.9166666666666666) {
                    margin += (n >> 5) + (n >> 6);
                    p0 = QuickSelect.repeatedStepFarRight(a, l, r, ka, bounds, m);
                } else {
                    p0 = QuickSelect.repeatedStepRight(a, l, r, ka, bounds, m);
                }
            } else {
                margin -= n >> 5;
                p0 = QuickSelect.repeatedStep(a, l, r, ka, bounds, m);
            }
            int p1 = bounds[0];
            if (kb < p0) {
                r = p0 - 1;
            } else if (ka > p1) {
                l = p1 + 1;
            } else {
                if (kb > p1) {
                    QuickSelect.sortSelectLeft(a, p1 + 1, r, kb);
                    bounds[0] = kb;
                }
                if (ka < p0) {
                    QuickSelect.sortSelectRight(a, l, p0 - 1, ka);
                    p0 = ka;
                }
                return p0;
            }
            if (r - l <= n - margin) continue;
            ++m;
        }
    }

    private static int sampleStep(int[] a, int l, int r, int k, int[] upper) {
        int n = r - l + 1;
        int ith = k - l + 1;
        double z = Math.log(n);
        double s = 0.5 * Math.exp(0.6666666666666666 * z);
        double sd = 0.5 * Math.sqrt(z * s * ((double)n - s) / (double)n) * (double)Integer.signum(ith - (n >> 1));
        int ll = Math.max(l, (int)((double)k - (double)ith * s / (double)n + sd));
        int rr = Math.min(r, (int)((double)k + (double)(n - ith) * s / (double)n + sd));
        int p = QuickSelect.quickSelectAdaptive(a, ll, rr, k, k, upper, -1);
        return QuickSelect.expandPartition(a, l, r, ll, rr, p, upper[0], upper);
    }

    private static int repeatedStep(int[] a, int l, int r, int k, int[] upper, int flags) {
        int p;
        int s;
        int fp;
        if (flags <= 0) {
            fp = (r - l + 1) / 12;
            s = k - QuickSelect.mapDistance(k - l, l, r, fp);
            p = k;
        } else {
            fp = (r - l + 1) / 9;
            int f3 = 3 * fp;
            int end = l + (f3 << 1);
            for (int i = l + f3; i < end; ++i) {
                Sorting.sort3(a, i - f3, i, i + f3);
            }
            s = l + (fp << 2);
            p = s + (flags == 1 ? QuickSelect.mapDistance(k - l, l, r, fp) : fp >>> 1);
        }
        int e = s + fp - 1;
        for (int i = s; i <= e; ++i) {
            Sorting.sort3(a, i - fp, i, i + fp);
        }
        p = QuickSelect.quickSelectAdaptive(a, s, e, p, p, upper, -1);
        return QuickSelect.expandPartition(a, l, r, s, e, p, upper[0], upper);
    }

    private static int repeatedStepLeft(int[] a, int l, int r, int k, int[] upper, int flags) {
        int p;
        int s;
        int fp;
        if (flags <= 0) {
            fp = (r - l + 1) / 12;
            s = Math.max(k - QuickSelect.mapDistance(k - l, l, r, fp), l + fp);
            p = k;
        } else {
            int f = r - l + 1 >> 2;
            int f2 = f + f;
            int end = l + f2;
            for (int i = l + f; i < end; ++i) {
                Sorting.lowerMedian4(a, i - f, i, i + f, i + f2);
            }
            fp = f / 3;
            s = l + f + fp;
            p = s + (flags == 1 ? QuickSelect.mapDistance(k - l, l, r, fp) : fp >>> 1);
        }
        int e = s + fp - 1;
        for (int i = s; i <= e; ++i) {
            Sorting.sort3(a, i - fp, i, i + fp);
        }
        p = QuickSelect.quickSelectAdaptive(a, s, e, p, p, upper, -1);
        return QuickSelect.expandPartition(a, l, r, s, e, p, upper[0], upper);
    }

    private static int repeatedStepRight(int[] a, int l, int r, int k, int[] upper, int flags) {
        int s;
        int p;
        int e;
        int fp;
        if (flags <= 0) {
            fp = (r - l + 1) / 12;
            e = Math.min(k + QuickSelect.mapDistance(r - k, l, r, fp), r - fp);
            p = k;
        } else {
            int f = r - l + 1 >> 2;
            int f2 = f + f;
            int end = r - f2;
            for (int i = r - f; i > end; --i) {
                Sorting.upperMedian4(a, i - f2, i - f, i, i + f);
            }
            fp = f / 3;
            e = r - f - fp;
            p = e - (flags == 1 ? QuickSelect.mapDistance(r - k, l, r, fp) : fp >>> 1);
        }
        for (int i = s = e - fp + 1; i <= e; ++i) {
            Sorting.sort3(a, i - fp, i, i + fp);
        }
        p = QuickSelect.quickSelectAdaptive(a, s, e, p, p, upper, -1);
        return QuickSelect.expandPartition(a, l, r, s, e, p, upper[0], upper);
    }

    private static int repeatedStepFarLeft(int[] a, int l, int r, int k, int[] upper, int flags) {
        int p;
        int s;
        int fp;
        if (flags <= 0) {
            fp = (r - l + 1) / 12;
            s = l + fp;
            p = s + QuickSelect.mapDistance(k - l, l, r, fp);
        } else {
            int f = r - l + 1 >> 2;
            int f2 = f + f;
            int end = l + f2;
            for (int i = l + f; i < end; ++i) {
                int u;
                if (a[i + f] < a[i - f]) {
                    u = a[i + f];
                    a[i + f] = a[i - f];
                    a[i - f] = u;
                }
                if (a[i + f2] < a[i]) {
                    int v = a[i + f2];
                    a[i + f2] = a[i];
                    a[i] = v;
                }
                if (a[i] >= a[i - f]) continue;
                u = a[i];
                a[i] = a[i - f];
                a[i - f] = u;
            }
            fp = f / 3;
            s = l + fp;
            p = s + (k - l >>> 1);
        }
        int e = s + fp - 1;
        for (int i = s; i <= e; ++i) {
            Sorting.sort3(a, i - fp, i, i + fp);
        }
        p = QuickSelect.quickSelectAdaptive(a, s, e, p, p, upper, -1);
        return QuickSelect.expandPartition(a, l, r, s, e, p, upper[0], upper);
    }

    private static int repeatedStepFarRight(int[] a, int l, int r, int k, int[] upper, int flags) {
        int s;
        int p;
        int e;
        int fp;
        if (flags <= 0) {
            fp = (r - l + 1) / 12;
            e = r - fp;
            p = e - QuickSelect.mapDistance(r - k, l, r, fp);
        } else {
            int f = r - l + 1 >> 2;
            int f2 = f + f;
            int end = r - f2;
            for (int i = r - f; i > end; --i) {
                int u;
                if (a[i - f] > a[i + f]) {
                    u = a[i - f];
                    a[i - f] = a[i + f];
                    a[i + f] = u;
                }
                if (a[i - f2] > a[i]) {
                    int v = a[i - f2];
                    a[i - f2] = a[i];
                    a[i] = v;
                }
                if (a[i] <= a[i + f]) continue;
                u = a[i];
                a[i] = a[i + f];
                a[i + f] = u;
            }
            fp = f / 3;
            e = r - fp;
            p = e - (r - k >>> 1);
        }
        for (int i = s = e - fp + 1; i <= e; ++i) {
            Sorting.sort3(a, i - fp, i, i + fp);
        }
        p = QuickSelect.quickSelectAdaptive(a, s, e, p, p, upper, -1);
        return QuickSelect.expandPartition(a, l, r, s, e, p, upper[0], upper);
    }

    static int expandPartition(int[] a, int left, int right, int start, int end, int pivot0, int pivot1, int[] upper) {
        int p1;
        int p0;
        block10: {
            int v = a[pivot0];
            int vi = a[start];
            int vj = a[end];
            a[start] = a[left];
            a[end] = a[right];
            a[left] = vj;
            a[right] = vi;
            int i = start + 1;
            int j = end - 1;
            p0 = pivot0 == start ? i : pivot0;
            int n = p1 = pivot1 == end ? j : pivot1;
            while (true) {
                if (a[--i] < v) {
                    continue;
                }
                while (a[++j] > v) {
                }
                vj = a[i];
                a[i] = vi = a[j];
                a[j] = vj;
                if (vi == v) {
                    a[i] = a[--p0];
                    a[p0] = v;
                }
                if (vj == v) {
                    a[j] = a[++p1];
                    a[p1] = v;
                }
                if (i == left) {
                    while (j < right) {
                        while (a[++j] > v) {
                        }
                        int w = a[j];
                        a[j] = a[++p1];
                        a[p1] = v;
                        if (w == v) continue;
                        a[p0] = w;
                        ++p0;
                    }
                    break block10;
                }
                if (j == right) break;
            }
            while (i > left) {
                while (a[--i] < v) {
                }
                int w = a[i];
                a[i] = a[--p0];
                a[p0] = v;
                if (w == v) continue;
                a[p1] = w;
                --p1;
            }
        }
        upper[0] = p1;
        return p0;
    }

    static void dualPivotQuickSelect(int[] a, int left, int right, UpdatingInterval k, int flags) {
        int l = left;
        int r = right;
        int f = flags;
        int ka = k.left();
        int kb = k.right();
        int[] upper = new int[]{0, 0, 0};
        while (true) {
            int n = r - l;
            if (Math.min(kb - l, r - ka) < 20 || n < (f & 0xFFFFF)) {
                QuickSelect.sortSelect(a, l, r, ka, kb);
                return;
            }
            if (kb - ka < 20) {
                QuickSelect.quickSelectAdaptive(a, l, r, ka, kb, upper, -1);
                return;
            }
            if (f < 0) {
                QuickSelect.heapSelect(a, l, r, ka, kb);
                return;
            }
            int p0 = QuickSelect.partition(a, l, r, upper);
            int p1 = upper[0];
            f += 0x100000;
            if (ka < p0) {
                if (kb <= p1) {
                    r = p0 - 1;
                    if (r >= kb) continue;
                    kb = k.updateRight(r);
                    continue;
                }
                QuickSelect.dualPivotQuickSelect(a, l, p0 - 1, k.splitLeft(p0, p1), f);
                ka = k.left();
            } else {
                if (kb <= p1) {
                    return;
                }
                if (ka <= p1) {
                    ka = k.updateLeft(p1 + 1);
                }
            }
            int p2 = upper[1];
            int p3 = upper[2];
            if (ka < p2) {
                l = p1 + 1;
                if (kb <= p3) {
                    r = p2 - 1;
                    if (r >= kb) continue;
                    kb = k.updateRight(r);
                    continue;
                }
                QuickSelect.dualPivotQuickSelect(a, l, p2 - 1, k.splitLeft(p2, p3), f);
                ka = k.left();
            } else {
                if (kb <= p3) {
                    return;
                }
                if (ka <= p3) {
                    ka = k.updateLeft(p3 + 1);
                }
            }
            l = p3 + 1;
        }
    }

    private static int partition(int[] a, int left, int right, int[] bounds) {
        int n = right - left;
        int step = 1 + (n >>> 3) + (n >>> 6);
        int i3 = left + (n >>> 1);
        int i2 = i3 - step;
        int i1 = i2 - step;
        int i4 = i3 + step;
        int i5 = i4 + step;
        Sorting.sort5(a, i1, i2, i3, i4, i5);
        int v1 = a[i2];
        a[i2] = a[left];
        a[left] = v1;
        int v2 = a[i4];
        a[i4] = a[right];
        a[right] = v2;
        int less = left;
        int great = right;
        while (a[++less] < v1) {
        }
        while (a[--great] > v2) {
        }
        int k = less - 1;
        block2: while (++k <= great) {
            int v = a[k];
            if (v < v1) {
                a[k] = a[less];
                a[less] = v;
                ++less;
                continue;
            }
            if (v <= v2) continue;
            while (a[great] > v2) {
                if (great-- != k) continue;
                break block2;
            }
            int w = a[great];
            a[great] = v;
            --great;
            if (w < v1) {
                a[k] = a[less];
                a[less] = w;
                ++less;
                continue;
            }
            a[k] = w;
        }
        a[left] = a[--less];
        a[less] = v1;
        a[right] = a[++great];
        a[great] = v2;
        int lower = less;
        bounds[2] = great;
        if (great - less > (n >>> 1) + (n >>> 3) && v1 != v2) {
            while (a[++less] == v1) {
            }
            while (a[--great] == v2) {
            }
            int k2 = less - 1;
            block6: while (++k2 <= great) {
                int v = a[k2];
                if (v == v1) {
                    a[k2] = a[less];
                    a[less] = v;
                    ++less;
                    continue;
                }
                if (v != v2) continue;
                while (a[great] == v2) {
                    if (great-- != k2) continue;
                    break block6;
                }
                int w = a[great];
                a[great] = v;
                --great;
                if (w == v1) {
                    a[k2] = a[less];
                    a[less] = w;
                    ++less;
                    continue;
                }
                a[k2] = w;
            }
            --less;
            ++great;
        }
        if (v1 != v2 && less < great - 1) {
            bounds[0] = less;
            bounds[1] = great;
        } else {
            bounds[0] = bounds[2];
            bounds[1] = lower;
        }
        return lower;
    }

    private static int mapDistance(int d, int l, int r, int n) {
        return (int)((double)d * ((double)n - 1.0) / (double)(r - l));
    }

    private static int dualPivotFlags(int left, int right, int k1, int kn) {
        int maxDepth = QuickSelect.dualPivotMaxDepth(right - left);
        int ss = QuickSelect.dualPivotSortSelectSize(k1, kn);
        return QuickSelect.dualPivotFlags(maxDepth, ss);
    }

    static int dualPivotFlags(int maxDepth, int ss) {
        int flags = Integer.MIN_VALUE - maxDepth * 0x100000;
        return (flags &= 0xFFF00000) | ss;
    }

    static int dualPivotMaxDepth(int x) {
        return (32 - Integer.numberOfLeadingZeros(x)) * 323 >>> 8;
    }

    private static int dualPivotSortSelectSize(int k1, int kn) {
        if (kn - k1 < 60) {
            return 0;
        }
        return 40;
    }
}

