/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.obs;

import com.obs.services.model.ServerAlgorithm;
import com.obs.services.model.ServerEncryption;
import com.obs.services.model.SseCHeader;
import com.obs.services.model.SseKmsHeader;
import org.apache.hadoop.conf.Configuration;

class SseWrapper {
    private static final String SSE_KMS = "sse-kms";
    private static final String SSE_C = "sse-c";
    private SseCHeader sseCHeader;
    private SseKmsHeader sseKmsHeader;

    SseWrapper(Configuration conf) {
        String sseType = conf.getTrimmed("fs.obs.server-side-encryption-type");
        if (null != sseType) {
            String sseKey = conf.getTrimmed("fs.obs.server-side-encryption-key");
            if (sseType.equalsIgnoreCase(SSE_C) && null != sseKey) {
                this.sseCHeader = new SseCHeader();
                this.sseCHeader.setSseCKeyBase64(sseKey);
                this.sseCHeader.setAlgorithm(ServerAlgorithm.AES256);
            } else if (sseType.equalsIgnoreCase(SSE_KMS)) {
                this.sseKmsHeader = new SseKmsHeader();
                this.sseKmsHeader.setEncryption(ServerEncryption.OBS_KMS);
                this.sseKmsHeader.setKmsKeyId(sseKey);
            }
        }
    }

    boolean isSseCEnable() {
        return this.sseCHeader != null;
    }

    boolean isSseKmsEnable() {
        return this.sseKmsHeader != null;
    }

    SseCHeader getSseCHeader() {
        return this.sseCHeader;
    }

    SseKmsHeader getSseKmsHeader() {
        return this.sseKmsHeader;
    }
}

