/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.swift.http;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.hadoop.fs.swift.exceptions.SwiftConnectionClosedException;
import org.apache.hadoop.fs.swift.util.SwiftUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpInputStreamWithRelease
extends InputStream {
    private static final Logger LOG = LoggerFactory.getLogger(HttpInputStreamWithRelease.class);
    private final URI uri;
    private HttpRequestBase req;
    private HttpResponse resp;
    private volatile boolean released;
    private volatile boolean dataConsumed;
    private InputStream inStream;
    private final Exception constructionStack;
    private String reasonClosed = "unopened";

    public HttpInputStreamWithRelease(URI uri, HttpRequestBase req, HttpResponse resp) throws IOException {
        this.uri = uri;
        this.req = req;
        this.resp = resp;
        Exception exception = this.constructionStack = LOG.isDebugEnabled() ? new Exception("stack") : null;
        if (req == null) {
            throw new IllegalArgumentException("Null 'request' parameter ");
        }
        try {
            this.inStream = resp.getEntity().getContent();
        }
        catch (IOException e) {
            this.inStream = new ByteArrayInputStream(new byte[0]);
            throw this.releaseAndRethrow("getResponseBodyAsStream() in constructor -" + e, e);
        }
    }

    @Override
    public void close() throws IOException {
        this.release("close()", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean release(String reason, Exception ex) throws IOException {
        if (!this.released) {
            this.reasonClosed = reason;
            try {
                LOG.debug("Releasing connection to {}:  {}", new Object[]{this.uri, reason, ex});
                if (this.req != null) {
                    if (!this.dataConsumed) {
                        this.req.abort();
                    }
                    this.req.releaseConnection();
                }
                if (this.inStream != null) {
                    this.inStream.close();
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.released = true;
                this.dataConsumed = true;
            }
        }
        return false;
    }

    private IOException releaseAndRethrow(String operation, IOException ex) {
        block2: {
            try {
                this.release(operation, ex);
            }
            catch (IOException ioe) {
                LOG.debug("Exception during release: {}", (Object)operation, (Object)ioe);
                if (ex != null) break block2;
                ex = ioe;
            }
        }
        return ex;
    }

    private synchronized void assumeNotReleased() throws SwiftConnectionClosedException {
        if (this.released || this.inStream == null) {
            throw new SwiftConnectionClosedException(this.reasonClosed);
        }
    }

    @Override
    public int available() throws IOException {
        this.assumeNotReleased();
        try {
            return this.inStream.available();
        }
        catch (IOException e) {
            throw this.releaseAndRethrow("available() failed -" + e, e);
        }
    }

    @Override
    public int read() throws IOException {
        this.assumeNotReleased();
        int read = 0;
        try {
            read = this.inStream.read();
        }
        catch (EOFException e) {
            LOG.debug("EOF exception", (Throwable)e);
            read = -1;
        }
        catch (IOException e) {
            throw this.releaseAndRethrow("read()", e);
        }
        if (read < 0) {
            this.dataConsumed = true;
            this.release("read() -all data consumed", null);
        }
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read;
        SwiftUtils.validateReadArgs(b, off, len);
        if (len == 0) {
            return 0;
        }
        this.assumeNotReleased();
        try {
            read = this.inStream.read(b, off, len);
        }
        catch (EOFException e) {
            LOG.debug("EOF exception", (Throwable)e);
            read = -1;
        }
        catch (IOException e) {
            throw this.releaseAndRethrow("read(b, off, " + len + ")", e);
        }
        if (read < 0) {
            this.dataConsumed = true;
            this.release("read() -all data consumed", null);
        }
        return read;
    }

    protected void finalize() {
        try {
            if (this.release("finalize()", this.constructionStack)) {
                LOG.warn("input stream of {} not closed properly -cleaned up in finalize()", (Object)this.uri);
            }
        }
        catch (Exception e) {
            LOG.warn("Exception while releasing {} in finalizer", (Object)this.uri, (Object)e);
        }
    }

    public String toString() {
        return "HttpInputStreamWithRelease working with " + this.uri + " released=" + this.released + " dataConsumed=" + this.dataConsumed;
    }
}

