/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.swift.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.util.EncodingUtils;

public abstract class HttpResponseUtils {
    public static byte[] getResponseBody(HttpResponse resp) throws IOException {
        try (InputStream instream = resp.getEntity().getContent();){
            if (instream != null) {
                int len;
                long contentLength = resp.getEntity().getContentLength();
                if (contentLength > Integer.MAX_VALUE) {
                    throw new IOException("Content too large to be buffered: " + contentLength + " bytes");
                }
                ByteArrayOutputStream outstream = new ByteArrayOutputStream(contentLength > 0L ? (int)contentLength : 4096);
                byte[] buffer = new byte[4096];
                while ((len = instream.read(buffer)) > 0) {
                    outstream.write(buffer, 0, len);
                }
                outstream.close();
                byte[] byArray = outstream.toByteArray();
                return byArray;
            }
        }
        return null;
    }

    public static String getResponseBodyAsString(HttpResponse resp) throws IOException {
        byte[] rawdata = HttpResponseUtils.getResponseBody(resp);
        if (rawdata != null) {
            return EncodingUtils.getString((byte[])rawdata, (String)"UTF-8");
        }
        return null;
    }

    public static long getContentLength(HttpResponse resp) {
        Header header = resp.getFirstHeader("Content-Length");
        if (header == null) {
            return -1L;
        }
        return Long.parseLong(header.getValue());
    }
}

