/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.deploy;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.deploy.AbstractDeployMojo;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

public class DeployMojo
extends AbstractDeployMojo
implements Contextualizable {
    private static final Pattern ALT_REPO_SYNTAX_PATTERN = Pattern.compile("(.+)::(.+)::(.+)");
    private Artifact artifact;
    private String packaging;
    private File pomFile;
    private ArtifactRepository deploymentRepository;
    private String altDeploymentRepository;
    private List attachedArtifacts;
    private boolean updateReleaseInfo;
    private PlexusContainer container;

    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean isPomArtifact;
        File sshFile;
        System.out.println("altDeploymentRepository = " + this.altDeploymentRepository);
        ArtifactRepository repo = this.getDeploymentRepository();
        String protocol = repo.getProtocol();
        if (protocol.equals("scp") && !(sshFile = new File(System.getProperty("user.home"), ".ssh")).exists()) {
            sshFile.mkdirs();
        }
        if (!(isPomArtifact = "pom".equals(this.packaging))) {
            ProjectArtifactMetadata metadata = new ProjectArtifactMetadata(this.artifact, this.pomFile);
            this.artifact.addMetadata((ArtifactMetadata)metadata);
        }
        if (this.updateReleaseInfo) {
            this.artifact.setRelease(true);
        }
        try {
            if (isPomArtifact) {
                this.getDeployer().deploy(this.pomFile, this.artifact, repo, this.getLocalRepository());
            } else {
                File file = this.artifact.getFile();
                if (file == null) {
                    throw new MojoExecutionException("The packaging for this project did not assign a file to the build artifact");
                }
                this.getDeployer().deploy(file, this.artifact, repo, this.getLocalRepository());
            }
            Iterator i = this.attachedArtifacts.iterator();
            while (i.hasNext()) {
                Artifact attached = (Artifact)i.next();
                this.getDeployer().deploy(attached.getFile(), attached, repo, this.getLocalRepository());
            }
        }
        catch (ArtifactDeploymentException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private ArtifactRepository getDeploymentRepository() throws MojoExecutionException, MojoFailureException {
        if (this.deploymentRepository == null && this.altDeploymentRepository == null) {
            String msg = "Deployment failed: repository element was not specified in the pom inside distributionManagement element or in -DaltDeploymentRepository=id::layout::url parameter";
            throw new MojoExecutionException(msg);
        }
        ArtifactRepository repo = null;
        if (this.altDeploymentRepository != null) {
            ArtifactRepositoryLayout repoLayout;
            this.getLog().info((CharSequence)("Using alternate deployment repository " + this.altDeploymentRepository));
            Matcher matcher = ALT_REPO_SYNTAX_PATTERN.matcher(this.altDeploymentRepository);
            if (!matcher.matches()) {
                throw new MojoFailureException((Object)this.altDeploymentRepository, "Invalid syntax for repository.", "Invalid syntax for alternative repository. Use \"id::layout::url\".");
            }
            String id = matcher.group(1).trim();
            String layout = matcher.group(2).trim();
            String url = matcher.group(3).trim();
            try {
                repoLayout = (ArtifactRepositoryLayout)this.container.lookup(ArtifactRepositoryLayout.ROLE, layout);
            }
            catch (ComponentLookupException e) {
                throw new MojoExecutionException("Cannot find repository layout: " + layout, (Exception)((Object)e));
            }
            repo = new DefaultArtifactRepository(id, url, repoLayout);
        }
        if (repo == null) {
            repo = this.deploymentRepository;
        }
        return repo;
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }
}

