/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.install;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.maven.api.Artifact;
import org.apache.maven.api.MojoExecution;
import org.apache.maven.api.Project;
import org.apache.maven.api.Session;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.model.Plugin;
import org.apache.maven.api.plugin.Log;
import org.apache.maven.api.plugin.MojoException;
import org.apache.maven.api.plugin.annotations.Mojo;
import org.apache.maven.api.plugin.annotations.Parameter;
import org.apache.maven.api.services.ArtifactInstaller;
import org.apache.maven.api.services.ArtifactInstallerRequest;
import org.apache.maven.api.services.ArtifactManager;
import org.apache.maven.api.services.ProjectManager;

@Mojo(name="install", defaultPhase="install")
public class InstallMojo
implements org.apache.maven.api.plugin.Mojo {
    @Inject
    private Log log;
    @Inject
    private Session session;
    @Inject
    private Project project;
    @Inject
    private MojoExecution mojoExecution;
    @Parameter(property="installAtEnd", defaultValue="false")
    private boolean installAtEnd;
    @Parameter(property="maven.install.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="allowIncompleteProjects", defaultValue="false")
    private boolean allowIncompleteProjects;
    private static final String INSTALL_PROCESSED_MARKER = InstallMojo.class.getName() + ".processed";

    private void putState(State state) {
        this.session.getPluginContext(this.project).put(INSTALL_PROCESSED_MARKER, state.name());
    }

    private void putState(State state, ArtifactInstallerRequest request) {
        this.session.getPluginContext(this.project).put(INSTALL_PROCESSED_MARKER, state.name());
        this.session.getPluginContext(this.project).put(ArtifactInstallerRequest.class.getName(), request);
    }

    private State getState(Project project) {
        Map pluginContext = this.session.getPluginContext(project);
        return State.valueOf((String)pluginContext.get(INSTALL_PROCESSED_MARKER));
    }

    private boolean hasState(Project project) {
        Map pluginContext = this.session.getPluginContext(project);
        return pluginContext.containsKey(INSTALL_PROCESSED_MARKER);
    }

    private boolean usingPlugin(Project project) {
        Plugin plugin = (Plugin)project.getBuild().getPluginsAsMap().get("org.apache.maven.plugins:maven-install-plugin");
        return plugin != null && plugin.getExecutions().stream().anyMatch(e -> Objects.equals(e.getId(), this.mojoExecution.getExecutionId()) && !"none".equals(e.getPhase()));
    }

    public void execute() {
        if (this.skip) {
            this.log.info((CharSequence)"Skipping artifact installation");
            this.putState(State.SKIPPED);
        } else if (!this.installAtEnd) {
            this.installProject(this.processProject(this.project));
            this.putState(State.INSTALLED);
        } else {
            this.getLog().info((CharSequence)("Deferring install for " + this.project.getGroupId() + ":" + this.project.getArtifactId() + ":" + this.project.getVersion() + " at end"));
            this.putState(State.TO_BE_INSTALLED, this.processProject(this.project));
        }
        List<Project> projectsUsingPlugin = this.session.getProjects().stream().filter(this::usingPlugin).collect(Collectors.toList());
        if (this.allProjectsMarked(projectsUsingPlugin)) {
            for (Project reactorProject : projectsUsingPlugin) {
                State state = this.getState(reactorProject);
                if (state != State.TO_BE_INSTALLED) continue;
                Map pluginContext = this.session.getPluginContext(reactorProject);
                ArtifactInstallerRequest request = (ArtifactInstallerRequest)pluginContext.get(ArtifactInstallerRequest.class.getName());
                this.installProject(request);
            }
        }
    }

    private boolean allProjectsMarked(List<Project> projectsUsingPlugin) {
        return projectsUsingPlugin.stream().allMatch(this::hasState);
    }

    private void installProject(ArtifactInstallerRequest request) {
        try {
            this.getArtifactInstaller().install(request);
        }
        catch (MojoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoException(e.getMessage(), (Throwable)e);
        }
    }

    private ArtifactInstallerRequest processProject(Project project) {
        ProjectManager projectManager = this.getProjectManager();
        Collection installables = projectManager.getAllArtifacts(project);
        Collection attachedArtifacts = projectManager.getAttachedArtifacts(project);
        this.getArtifactManager().setPath(project.getPomArtifact(), project.getPomPath());
        for (Artifact installable : installables) {
            if (this.isValidPath(installable)) continue;
            if (installable == project.getMainArtifact().orElse(null)) {
                if (attachedArtifacts.isEmpty()) {
                    throw new MojoException("The packaging for this project did not assign a file to the build artifact");
                }
                if (this.allowIncompleteProjects) {
                    this.getLog().warn((CharSequence)"");
                    this.getLog().warn((CharSequence)"The packaging plugin for this project did not assign");
                    this.getLog().warn((CharSequence)"a main file to the project but it has attachments. Change packaging to 'pom'.");
                    this.getLog().warn((CharSequence)"");
                    this.getLog().warn((CharSequence)"Incomplete projects like this will fail in future Maven versions!");
                    this.getLog().warn((CharSequence)"");
                    continue;
                }
                throw new MojoException("The packaging plugin for this project did not assign a main file to the project but it has attachments. Change packaging to 'pom'.");
            }
            throw new MojoException("The packaging for this project did not assign a file to the attached artifact: " + String.valueOf(installable));
        }
        return ArtifactInstallerRequest.build((Session)this.session, (Collection)installables);
    }

    private boolean isValidPath(Artifact a) {
        return this.getArtifactManager().getPath(a).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).isPresent();
    }

    void setSkip(boolean skip) {
        this.skip = skip;
    }

    protected Log getLog() {
        return this.log;
    }

    private ArtifactInstaller getArtifactInstaller() {
        return (ArtifactInstaller)this.session.getService(ArtifactInstaller.class);
    }

    private ArtifactManager getArtifactManager() {
        return (ArtifactManager)this.session.getService(ArtifactManager.class);
    }

    private ProjectManager getProjectManager() {
        return (ProjectManager)this.session.getService(ProjectManager.class);
    }

    private static enum State {
        SKIPPED,
        INSTALLED,
        TO_BE_INSTALLED;

    }
}

