/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.reporting.exec;

import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MavenPluginManager;
import org.apache.maven.plugin.PluginContainerException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.reporting.exec.MavenPluginManagerHelper;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.util.filter.ExclusionsDependencyFilter;

@Component(role=MavenPluginManagerHelper.class)
public class DefaultMavenPluginManagerHelper
implements MavenPluginManagerHelper {
    @Requirement
    protected MavenPluginManager mavenPluginManager;

    private DependencyFilter createExclusionsDependencyFilter(List<String> artifactIdsList) {
        return new ExclusionsDependencyFilter(artifactIdsList);
    }

    @Override
    public PluginDescriptor getPluginDescriptor(Plugin plugin, MavenSession session) throws PluginResolutionException, PluginDescriptorParsingException, InvalidPluginDescriptorException {
        RepositorySystemSession repositorySystemSession = session.getRepositorySession();
        List remoteRepositories = session.getCurrentProject().getRemotePluginRepositories();
        return this.mavenPluginManager.getPluginDescriptor(plugin, remoteRepositories, repositorySystemSession);
    }

    @Override
    public void setupPluginRealm(PluginDescriptor pluginDescriptor, MavenSession session, ClassLoader parent, List<String> imports, List<String> excludeArtifactIds) throws PluginResolutionException, PluginContainerException {
        this.mavenPluginManager.setupPluginRealm(pluginDescriptor, session, parent, imports, this.createExclusionsDependencyFilter(excludeArtifactIds));
    }
}

