/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import javax.annotation.Nonnull;
import org.apache.maven.surefire.booter.AbstractPathConfiguration;
import org.apache.maven.surefire.booter.Classpath;
import org.apache.maven.surefire.booter.PropertiesWrapper;

public class ClasspathConfiguration
extends AbstractPathConfiguration {
    private final Classpath testClasspathUrls;
    private final Classpath inprocClasspath;

    public ClasspathConfiguration(boolean enableAssertions, boolean childDelegation) {
        this(Classpath.emptyClasspath(), Classpath.emptyClasspath(), Classpath.emptyClasspath(), enableAssertions, childDelegation);
    }

    ClasspathConfiguration(@Nonnull PropertiesWrapper properties) {
        this(properties.getClasspath("classPathUrl."), properties.getClasspath("surefireClassPathUrl."), Classpath.emptyClasspath(), properties.getBooleanProperty("enableAssertions"), properties.getBooleanProperty("childDelegation"));
    }

    public ClasspathConfiguration(@Nonnull Classpath testClasspathUrls, @Nonnull Classpath surefireClassPathUrls, @Nonnull Classpath inprocClasspath, boolean enableAssertions, boolean childDelegation) {
        super(surefireClassPathUrls, enableAssertions, childDelegation);
        this.testClasspathUrls = testClasspathUrls;
        this.inprocClasspath = inprocClasspath;
    }

    @Override
    protected Classpath getInprocClasspath() {
        return this.inprocClasspath;
    }

    @Override
    public Classpath getTestClasspath() {
        return this.testClasspathUrls;
    }

    @Override
    public final boolean isModularPathConfig() {
        return !this.isClassPathConfig();
    }

    @Override
    public final boolean isClassPathConfig() {
        return true;
    }

    public void trickClassPathWhenManifestOnlyClasspath() {
        System.setProperty("surefire.real.class.path", System.getProperty("java.class.path"));
        this.getTestClasspath().writeToSystemProperty("java.class.path");
    }
}

